/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyAnyInteger
extends PropertyHelper<Integer> {
    private final ImmutableSet<Integer> allowedValues;

    protected PropertyAnyInteger(String name, int min, int max) {
        super(name, Integer.class);
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max < min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        HashSet set = Sets.newHashSet();
        for (int i = min; i <= max; ++i) {
            set.add(i);
        }
        this.allowedValues = ImmutableSet.copyOf((Collection)set);
    }

    public static PropertyAnyInteger create(String name, int min, int max) {
        return new PropertyAnyInteger(name, min, max);
    }

    public String getName(Integer value) {
        return value.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyAnyInteger)) {
            return false;
        }
        PropertyAnyInteger other = (PropertyAnyInteger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableSet<Integer> this$allowedValues = this.getAllowedValues();
        ImmutableSet<Integer> other$allowedValues = other.getAllowedValues();
        return !(this$allowedValues == null ? other$allowedValues != null : !this$allowedValues.equals(other$allowedValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyAnyInteger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ImmutableSet<Integer> $allowedValues = this.getAllowedValues();
        result = result * 59 + ($allowedValues == null ? 43 : $allowedValues.hashCode());
        return result;
    }

    public ImmutableSet<Integer> getAllowedValues() {
        return this.allowedValues;
    }
}

