/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import team.chisel.Chisel;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselTabs;

public class ItemChisel
extends Item {
    private final ChiselType type;

    public ItemChisel(ChiselType type) {
        this.type = type;
        this.func_77625_d(1);
        String name = "chisel_" + type.name().toLowerCase(Locale.US);
        this.setRegistryName(name);
        this.func_77655_b("chisel." + name);
        this.func_77637_a(ChiselTabs.tab);
    }

    public int getMaxDamage(ItemStack stack) {
        if (Configurations.allowChiselDamage) {
            return this.type.maxDamage;
        }
        return 0;
    }

    public boolean func_77645_m() {
        return Configurations.allowChiselDamage;
    }

    public boolean func_82789_a(ItemStack damagedItem, ItemStack repairMaterial) {
        switch (this.type) {
            case DIAMOND: {
                return repairMaterial.func_77973_b().equals(Items.field_151045_i);
            }
            case IRON: {
                return repairMaterial.func_77973_b().equals(Items.field_151042_j);
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean held) {
        String base = "item.chisel.chisel.desc.";
        String gui = I18n.func_135052_a((String)(base + "gui"), (Object[])new Object[0]);
        String lc1 = I18n.func_135052_a((String)(base + "lc1"), (Object[])new Object[0]);
        String lc2 = I18n.func_135052_a((String)(base + "lc2"), (Object[])new Object[0]);
        String modes = I18n.func_135052_a((String)(base + "modes"), (Object[])new Object[0]);
        list.add(gui);
        if (this.type == ChiselType.DIAMOND || Configurations.ironChiselCanLeftClick) {
            list.add(lc1);
            list.add(lc2);
        }
        if (this.type == ChiselType.DIAMOND || Configurations.ironChiselHasModes) {
            list.add("");
            list.add(modes);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Chisel Damage", (double)this.type.attackDamage, 0));
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return super.func_77644_a(stack, attacker, target);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)Chisel.instance, 0, worldIn, playerIn.func_180425_c().func_177958_n(), playerIn.func_180425_c().func_177956_o(), playerIn.func_180425_c().func_177952_p());
        }
        return itemStackIn;
    }

    public static enum ChiselType {
        IRON(Configurations.ironChiselMaxDamage, Configurations.ironChiselAttackDamage),
        DIAMOND(Configurations.diamondChiselMaxDamage, Configurations.diamondChiselAttackDamage);

        final int maxDamage;
        final int attackDamage;

        private ChiselType(int maxDamage, int attackDamage) {
            this.maxDamage = maxDamage;
            this.attackDamage = attackDamage;
        }
    }
}

