/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.render.QuadHelper;
import team.chisel.client.render.ctx.BlockRenderContextPosition;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeV;

public class ChiselTextureV
extends AbstractChiselTexture<BlockRenderTypeV> {
    public ChiselTextureV(BlockRenderTypeV type, EnumWorldBlockLayer layer, TextureSpriteCallback ... sprites) {
        super(type, layer, sprites);
    }

    @Override
    public List<BakedQuad> getSideQuads(EnumFacing side, IBlockRenderContext context, int quadGoal) {
        int ty;
        int tx;
        BlockPos pos = context == null ? new BlockPos(0, 0, 0) : ((BlockRenderContextPosition)context).getPosition();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int xSize = ((BlockRenderTypeV)this.getType()).getXSize();
        int ySize = ((BlockRenderTypeV)this.getType()).getYSize();
        if (side.func_176740_k().func_176720_b()) {
            tx = x % xSize;
            ty = z % ySize;
        } else if (side.func_176740_k() == EnumFacing.Axis.Z) {
            tx = x % xSize;
            ty = -y % ySize;
        } else {
            tx = z % xSize;
            ty = -y % ySize;
        }
        if (side == EnumFacing.NORTH || side == EnumFacing.EAST) {
            tx = (xSize - tx - 1) % xSize;
        }
        if (tx < 0) {
            tx += xSize;
        }
        if (ty < 0) {
            ty += ySize;
        }
        float intervalU = 16.0f / (float)xSize;
        float intervalV = 16.0f / (float)ySize;
        float minU = intervalU * (float)tx;
        float minV = intervalV * (float)ty;
        if (quadGoal != 4) {
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            list.add(QuadHelper.makeUVFaceQuad(side, this.sprites[0].getSprite(), new float[]{minU, minV, minU + intervalU, minV + intervalV}));
            return list;
        }
        return QuadHelper.makeFourQuads(side, this.sprites[0].getSprite(), new float[]{minU, minV, minU + intervalU, minV + intervalV});
    }
}

