/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.render.QuadHelper;
import team.chisel.client.render.ctx.BlockRenderContextPosition;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeR;

public class ChiselTextureR
extends AbstractChiselTexture<BlockRenderTypeR> {
    private static final Random rand = new Random();

    public ChiselTextureR(BlockRenderTypeR type, EnumWorldBlockLayer layer, TextureSpriteCallback[] sprites) {
        super(type, layer, sprites);
    }

    @Override
    public List<BakedQuad> getSideQuads(EnumFacing side, IBlockRenderContext context, int quadGoal) {
        BlockPos pos = context == null ? new BlockPos(0, 0, 0) : ((BlockRenderContextPosition)context).getPosition();
        rand.setSeed(MathHelper.func_180186_a((Vec3i)pos) + (long)side.ordinal());
        rand.nextBoolean();
        int w = ((BlockRenderTypeR)this.getType()).getXSize();
        int h = ((BlockRenderTypeR)this.getType()).getYSize();
        float intervalX = 16.0f / (float)w;
        float intervalY = 16.0f / (float)h;
        int unitsAcross = rand.nextInt(w) + 1;
        int unitsDown = rand.nextInt(h) + 1;
        float maxU = (float)unitsAcross * intervalX;
        float maxV = (float)unitsDown * intervalY;
        ArrayList<BakedQuad> toReturn = new ArrayList<BakedQuad>();
        float[] uvs = new float[]{maxU - intervalX, maxV - intervalY, maxU, maxV};
        toReturn.add(QuadHelper.makeUVFaceQuad(side, this.sprites[0].getSprite(), uvs));
        return toReturn;
    }
}

