/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.render.QuadHelper;
import team.chisel.client.render.ctx.CTMVBlockRenderContext;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeCTMV;

public class ChiselTextureCTMV
extends AbstractChiselTexture<BlockRenderTypeCTMV> {
    public ChiselTextureCTMV(BlockRenderTypeCTMV type, EnumWorldBlockLayer layer, TextureSpriteCallback[] sprites) {
        super(type, layer, sprites);
    }

    @Override
    public List<BakedQuad> getSideQuads(EnumFacing side, IBlockRenderContext context, int target) {
        if (context == null) {
            return Lists.newArrayList((Object[])new BakedQuad[]{QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), new float[]{0.0f, 0.0f, 8.0f, 8.0f})});
        }
        return Lists.newArrayList((Object[])new BakedQuad[]{this.getQuad(side, ((CTMVBlockRenderContext)context).getData())});
    }

    private BakedQuad getQuad(EnumFacing side, CTMVBlockRenderContext.ConnectionData data) {
        boolean connected;
        CTMVBlockRenderContext.Connections cons = data.getConnections();
        EnumSet<EnumFacing> realConnections = EnumSet.copyOf(data.getConnections().getConnections());
        if (cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            realConnections.removeIf(f -> f.func_176740_k().func_176722_c());
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            realConnections.removeIf(f -> f == EnumFacing.NORTH || f == EnumFacing.SOUTH);
            realConnections.removeIf(f -> this.blockConnectionZ((EnumFacing)f, data));
        } else {
            realConnections.removeIf(f -> this.blockConnectionY((EnumFacing)f, data));
        }
        cons = new CTMVBlockRenderContext.Connections(realConnections);
        int rotation = 0;
        float[] uvs = QuadHelper.UVS_TOP_LEFT;
        if (side.func_176740_k().func_176722_c() && cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            uvs = this.getUVs(EnumFacing.UP, EnumFacing.DOWN, cons);
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            rotation = 90;
            uvs = this.getUVs(EnumFacing.EAST, EnumFacing.WEST, cons);
        } else if (cons.connectedOr(EnumFacing.NORTH, EnumFacing.SOUTH)) {
            uvs = this.getUVs(EnumFacing.NORTH, EnumFacing.SOUTH, cons);
            if (side == EnumFacing.DOWN) {
                rotation += 180;
            }
        }
        boolean bl = connected = !cons.getConnections().isEmpty();
        if (connected && !cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            if (side == EnumFacing.EAST) {
                rotation += 90;
            }
            if (side == EnumFacing.NORTH) {
                rotation += 180;
            }
            if (side == EnumFacing.WEST) {
                rotation += 270;
            }
        }
        if (cons.connected(side.func_176734_d())) {
            connected = false;
        }
        if (cons.getConnections().isEmpty() && side.func_176740_k().func_176722_c()) {
            connected = true;
        }
        if (connected) {
            return QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), uvs, rotation);
        }
        return QuadHelper.makeNormalFaceQuad(side, this.sprites[0].getSprite());
    }

    private float[] getUVs(EnumFacing face1, EnumFacing face2, CTMVBlockRenderContext.Connections cons) {
        float[] uvs = cons.connectedAnd(face1, face2) ? QuadHelper.UVS_BOTTOM_LEFT : (cons.connected(face1) ? QuadHelper.UVS_BOTTOM_RIGHT : QuadHelper.UVS_TOP_RIGHT);
        return uvs;
    }

    private boolean blockConnectionY(EnumFacing dir, CTMVBlockRenderContext.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Y, data) || this.blockConnection(dir, dir.func_176732_a(EnumFacing.Axis.Y).func_176740_k(), data);
    }

    private boolean blockConnectionZ(EnumFacing dir, CTMVBlockRenderContext.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Z, data);
    }

    private boolean blockConnection(EnumFacing dir, EnumFacing.Axis axis, CTMVBlockRenderContext.ConnectionData data) {
        EnumFacing rot = dir.func_176732_a(axis);
        return data.getConnections(dir).connectedOr(rot, rot.func_176734_d());
    }
}

