/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.render.QuadHelper;
import team.chisel.client.render.ctm.CTM;
import team.chisel.client.render.ctx.CTMBlockRenderContext;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeCTMH;
import team.chisel.common.util.Dir;

public class ChiselTextureCTMH
extends AbstractChiselTexture<BlockRenderTypeCTMH> {
    public ChiselTextureCTMH(BlockRenderTypeCTMH type, EnumWorldBlockLayer layer, TextureSpriteCallback ... sprites) {
        super(type, layer, sprites);
    }

    @Override
    public List<BakedQuad> getSideQuads(EnumFacing side, IBlockRenderContext context, int target) {
        if (side.func_176740_k().func_176720_b()) {
            return Lists.newArrayList((Object[])new BakedQuad[]{QuadHelper.makeNormalFaceQuad(side, this.sprites[0].getSprite())});
        }
        if (context == null) {
            return Lists.newArrayList((Object[])new BakedQuad[]{QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), new float[]{0.0f, 0.0f, 8.0f, 8.0f})});
        }
        CTM ctm = ((CTMBlockRenderContext)context).getCTM(side);
        return Lists.newArrayList((Object[])new BakedQuad[]{this.getQuad(side, ctm)});
    }

    private BakedQuad getQuad(EnumFacing side, CTM ctm) {
        if (ctm.connectedAnd(Dir.LEFT, Dir.RIGHT)) {
            return QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), QuadHelper.UVS_TOP_RIGHT);
        }
        if (ctm.connected(Dir.LEFT)) {
            return QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), QuadHelper.UVS_BOTTOM_RIGHT);
        }
        if (ctm.connected(Dir.RIGHT)) {
            return QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), QuadHelper.UVS_BOTTOM_LEFT);
        }
        return QuadHelper.makeUVFaceQuad(side, this.sprites[1].getSprite(), QuadHelper.UVS_TOP_LEFT);
    }
}

