/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctx;

import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.render.IBlockRenderContext;

public class CTMVBlockRenderContext
implements IBlockRenderContext {
    private ConnectionData data;

    public CTMVBlockRenderContext(IBlockAccess world, BlockPos pos) {
        this.data = new ConnectionData(world, pos);
    }

    public ConnectionData getData() {
        return this.data;
    }

    public static class ConnectionData {
        private Connections connections;
        private Map<EnumFacing, Connections> connectionConnections = new EnumMap<EnumFacing, Connections>(EnumFacing.class);

        public ConnectionData(IBlockAccess world, BlockPos pos) {
            this.connections = Connections.forPos(world, pos);
            IBlockState state = world.func_180495_p(pos);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                this.connectionConnections.put(f, Connections.forPos(world, state, pos.func_177972_a(f)));
            }
        }

        public Connections getConnections(EnumFacing facing) {
            return this.connectionConnections.get(facing);
        }

        public String toString() {
            return "CTMVBlockRenderContext.ConnectionData(connections=" + this.getConnections() + ", connectionConnections=" + this.connectionConnections + ")";
        }

        public Connections getConnections() {
            return this.connections;
        }
    }

    public static class Connections {
        private EnumSet<EnumFacing> connections;

        public boolean connected(EnumFacing facing) {
            return this.connections.contains(facing);
        }

        public boolean connectedAnd(EnumFacing ... facings) {
            for (EnumFacing f : facings) {
                if (this.connected(f)) continue;
                return false;
            }
            return true;
        }

        public boolean connectedOr(EnumFacing ... facings) {
            for (EnumFacing f : facings) {
                if (!this.connected(f)) continue;
                return true;
            }
            return false;
        }

        public static Connections forPos(IBlockAccess world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return Connections.forPos(world, state, pos);
        }

        public static Connections forPos(IBlockAccess world, IBlockState baseState, BlockPos pos) {
            EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (world.func_180495_p(pos) != baseState || world.func_180495_p(pos.func_177972_a(f)) != baseState) continue;
                connections.add(f);
            }
            return new Connections(connections);
        }

        @ConstructorProperties(value={"connections"})
        public Connections(EnumSet<EnumFacing> connections) {
            this.connections = connections;
        }

        public EnumSet<EnumFacing> getConnections() {
            return this.connections;
        }

        public String toString() {
            return "CTMVBlockRenderContext.Connections(connections=" + this.getConnections() + ")";
        }
    }
}

