/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctm;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import org.lwjgl.util.vector.Vector3f;
import team.chisel.client.render.QuadPos;
import team.chisel.client.render.ctm.CTM;
import team.chisel.common.Reference;

public class CTMFaceBakery
extends FaceBakery
implements Reference {
    public static final QuadPos[] possibleQuads = new QuadPos[]{new QuadPos(new Vector3f(8.0f, 0.0f, 8.0f), new Vector3f(16.0f, 8.0f, 16.0f)), new QuadPos(new Vector3f(8.0f, 0.0f, 0.0f), new Vector3f(16.0f, 8.0f, 8.0f)), new QuadPos(new Vector3f(0.0f, 0.0f, 8.0f), new Vector3f(8.0f, 8.0f, 16.0f)), new QuadPos(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(8.0f, 8.0f, 8.0f)), new QuadPos(new Vector3f(8.0f, 8.0f, 8.0f), new Vector3f(16.0f, 16.0f, 16.0f)), new QuadPos(new Vector3f(8.0f, 8.0f, 0.0f), new Vector3f(16.0f, 16.0f, 8.0f)), new QuadPos(new Vector3f(0.0f, 8.0f, 8.0f), new Vector3f(8.0f, 16.0f, 16.0f)), new QuadPos(new Vector3f(0.0f, 8.0f, 0.0f), new Vector3f(8.0f, 16.0f, 8.0f))};

    public static QuadPos getCorrectQuadPos(EnumFacing f, int r) {
        boolean isNorth = false;
        boolean isWest = false;
        boolean isUp = false;
        boolean isSUp = false;
        boolean isSLeft = false;
        if (r == 4) {
            isSUp = true;
            isSLeft = true;
        } else if (r == 3) {
            isSUp = true;
        } else if (r == 1) {
            isSLeft = true;
        }
        if (f == EnumFacing.UP) {
            isUp = true;
            if (isSUp) {
                isNorth = true;
            }
            if (isSLeft) {
                isWest = true;
            }
        } else if (f == EnumFacing.DOWN) {
            if (!isSUp) {
                isNorth = true;
            }
            if (isSLeft) {
                isWest = true;
            }
        } else if (f == EnumFacing.NORTH) {
            isNorth = true;
            if (isSUp) {
                isUp = true;
            }
            if (!isSLeft) {
                isWest = true;
            }
        } else if (f == EnumFacing.SOUTH) {
            if (isSUp) {
                isUp = true;
            }
            if (isSLeft) {
                isWest = true;
            }
        } else if (f == EnumFacing.WEST) {
            isWest = true;
            if (isSUp) {
                isUp = true;
            }
            if (isSLeft) {
                isNorth = true;
            }
        } else if (f == EnumFacing.EAST) {
            if (isSUp) {
                isUp = true;
            }
            if (!isSLeft) {
                isNorth = true;
            }
        }
        int num = 0;
        if (isUp) {
            num = 4;
        }
        if (isNorth) {
            ++num;
        }
        if (isWest) {
            num += 2;
        }
        return possibleQuads[num];
    }

    public List<BakedQuad> makeCtmFace(EnumFacing side, TextureAtlasSprite[] sprites, int[] quads) {
        return Arrays.asList(this.makeQuadFor(side, sprites, quads[0], 1), this.makeQuadFor(side, sprites, quads[1], 2), this.makeQuadFor(side, sprites, quads[2], 3), this.makeQuadFor(side, sprites, quads[3], 4));
    }

    private BakedQuad makeQuadFor(EnumFacing side, TextureAtlasSprite[] sprites, int quad, int quadSection) {
        TextureAtlasSprite s = sprites[1];
        if (CTM.isDefaultTexture(quad)) {
            s = sprites[0];
        }
        QuadPos pos = CTMFaceBakery.getCorrectQuadPos(side, quadSection);
        return this.makeRealQuad(pos, side, s, quad);
    }

    private BakedQuad makeRealQuad(QuadPos pos, EnumFacing side, TextureAtlasSprite s, int quad) {
        return this.func_178414_a(pos.from, pos.to, new BlockPartFace(side, -1, s.func_94215_i(), new BlockFaceUV(CTM.uvs[quad], 0)), s, side, ModelRotation.X0_Y0, new BlockPartRotation(new Vector3f(1.0f, 0.0f, 0.0f), side.func_176740_k(), 0.0f, false), false, true);
    }
}

