/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import org.lwjgl.util.vector.Vector3f;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.render.QuadPos;
import team.chisel.client.render.ctm.CTMFaceBakery;

public class QuadHelper {
    private static final CTMFaceBakery ctmBakery = new CTMFaceBakery();
    private static final FaceBakery bakery = new FaceBakery();
    private static final QuadPos quadPos = new QuadPos(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f));
    public static final float[] UVS_TOP_LEFT = new float[]{0.0f, 0.0f, 8.0f, 8.0f};
    public static final float[] UVS_TOP_RIGHT = new float[]{8.0f, 0.0f, 16.0f, 8.0f};
    public static final float[] UVS_BOTTOM_LEFT = new float[]{0.0f, 8.0f, 8.0f, 16.0f};
    public static final float[] UVS_BOTTOM_RIGHT = new float[]{8.0f, 8.0f, 16.0f, 16.0f};

    public static BakedQuad makeNormalFaceQuad(EnumFacing f, TextureAtlasSprite sprite) {
        return QuadHelper.makeUVFaceQuad(f, sprite, new float[]{0.0f, 0.0f, 16.0f, 16.0f});
    }

    public static List<BakedQuad> makeFourQuads(EnumFacing f, TextureAtlasSprite sprite, float[] uvs) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float uDif = uvs[2] - uvs[0];
        float vDif = uvs[3] - uvs[1];
        quads.add(QuadHelper.makeUVQuad(f, sprite, new float[]{uvs[0], uvs[1], uvs[0] + uDif / 2.0f, uvs[1] + vDif / 2.0f}, CTMFaceBakery.getCorrectQuadPos(f, 4)));
        quads.add(QuadHelper.makeUVQuad(f, sprite, new float[]{uvs[0] + uDif / 2.0f, uvs[1], uvs[2], uvs[1] + vDif / 2.0f}, CTMFaceBakery.getCorrectQuadPos(f, 3)));
        quads.add(QuadHelper.makeUVQuad(f, sprite, new float[]{uvs[0] + uDif / 2.0f, uvs[1] + vDif / 2.0f, uvs[2], uvs[3]}, CTMFaceBakery.getCorrectQuadPos(f, 2)));
        quads.add(QuadHelper.makeUVQuad(f, sprite, new float[]{uvs[0], uvs[1] + vDif / 2.0f, uvs[0] + uDif / 2.0f, uvs[3]}, CTMFaceBakery.getCorrectQuadPos(f, 1)));
        return quads;
    }

    public static BakedQuad makeUVFaceQuad(EnumFacing f, TextureAtlasSprite sprite, float[] uvs) {
        return QuadHelper.makeUVFaceQuad(f, sprite, uvs, 0);
    }

    public static BakedQuad makeUVFaceQuad(EnumFacing f, TextureAtlasSprite sprite, float[] uvs, int rotation) {
        return QuadHelper.makeUVQuad(f, sprite, uvs, rotation, quadPos);
    }

    public static BakedQuad makeUVQuad(EnumFacing f, TextureAtlasSprite sprite, float[] uvs, QuadPos pos) {
        return QuadHelper.makeUVQuad(f, sprite, uvs, 0, pos);
    }

    public static BakedQuad makeUVQuad(EnumFacing f, TextureAtlasSprite sprite, float[] uvs, int rotation, QuadPos pos) {
        return bakery.func_178414_a(pos.from, pos.to, new BlockPartFace(f, -1, sprite.func_94215_i(), new BlockFaceUV(uvs, rotation)), sprite, f, ModelRotation.X0_Y0, new BlockPartRotation(new Vector3f(1.0f, 0.0f, 0.0f), f.func_176740_k(), 0.0f, false), false, true);
    }

    public static List<BakedQuad> makeCtmFace(EnumFacing side, TextureAtlasSprite[] sprites, int[] quads) {
        return ctmBakery.makeCtmFace(side, sprites, quads);
    }

    public static List<BakedQuad> makeCtmFace(EnumFacing side, TextureSpriteCallback[] sprites, int[] quads) {
        TextureAtlasSprite[] realSprites = new TextureAtlasSprite[sprites.length];
        for (int i = 0; i < sprites.length; ++i) {
            realSprites[i] = sprites[i].getSprite();
        }
        return ctmBakery.makeCtmFace(side, realSprites, quads);
    }
}

