/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Chisel;
import team.chisel.api.block.ICarvable;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.api.render.RenderContextList;
import team.chisel.client.BlockFaceData;
import team.chisel.client.ClientUtil;
import team.chisel.common.block.BlockCarvable;

public class ModelChiselBlock
implements ISmartBlockModel,
ISmartItemModel,
IPerspectiveAwareModel {
    private List<BakedQuad> quads;
    private BlockFaceData.VariationFaceData variationData;
    private Pair<IPerspectiveAwareModel, Matrix4f> thirdPersonTransform;

    public ModelChiselBlock(List<BakedQuad> quads, BlockFaceData.VariationFaceData data) {
        this.quads = quads;
        this.variationData = data;
    }

    public ModelChiselBlock() {
        this(new ArrayList<BakedQuad>(), null);
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        return FluentIterable.from(this.quads).filter(quad -> quad.func_178210_d() == facing).toList();
    }

    public List<BakedQuad> func_177550_a() {
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.variationData == null) {
            return null;
        }
        return this.variationData.defaultFace.getParticle();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public IBakedModel handleBlockState(IBlockState stateIn) {
        if (stateIn.func_177230_c() instanceof ICarvable && stateIn instanceof IExtendedBlockState) {
            IExtendedBlockState state = (IExtendedBlockState)stateIn;
            ICarvable block = (ICarvable)state.func_177230_c();
            RenderContextList ctxList = (RenderContextList)state.getValue((IUnlistedProperty)BlockCarvable.CTX_LIST);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            BlockFaceData.VariationFaceData variationData = block.getBlockFaceData().getForMeta(MathHelper.func_76125_a((int)block.getVariationIndex(state), (int)0, (int)block.getVariations().length));
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IChiselFace face = variationData.getFaceForSide(facing);
                if (MinecraftForgeClient.getRenderLayer() != face.getLayer()) {
                    Chisel.debug("Skipping Layer " + MinecraftForgeClient.getRenderLayer() + " for block " + state);
                    continue;
                }
                int quadGoal = (Integer)Ordering.natural().max((Iterable)FluentIterable.from(face.getTextureList()).transform(tex -> tex.getType().getQuadsPerSide()));
                for (IChiselTexture<?> tex2 : face.getTextureList()) {
                    quads.addAll(tex2.getSideQuads(facing, ctxList.getRenderContext((IBlockRenderType)tex2.getType()), quadGoal));
                }
            }
            return new ModelChiselBlock(quads, variationData);
        }
        return this;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        BlockCarvable block = (BlockCarvable)((ItemBlock)stack.func_77973_b()).func_179223_d();
        BlockFaceData.VariationFaceData variationData = block.getBlockFaceData().getForMeta(stack.func_77952_i());
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            for (IChiselTexture<?> tex : variationData.getFaceForSide(facing).getTextureList()) {
                quads.addAll(tex.getSideQuads(facing, null, 1));
            }
        }
        return new ModelChiselBlock(quads, variationData);
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON) {
            if (this.thirdPersonTransform == null) {
                this.thirdPersonTransform = ImmutablePair.of((Object)this, (Object)ClientUtil.DEFAULT_BLOCK_THIRD_PERSON_MATRIX);
            }
            return this.thirdPersonTransform;
        }
        return Pair.of((Object)this, null);
    }
}

