/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.chisel.Chisel;
import team.chisel.api.block.ICarvable;
import team.chisel.client.render.ModelChiselBlock;
import team.chisel.common.Reference;

public enum ChiselModelRegistry implements Reference
{
    INSTANCE;

    private final Map<ModelResourceLocation, ModelChiselBlock> models = new HashMap<ModelResourceLocation, ModelChiselBlock>();

    public void register(ModelResourceLocation loc, ModelChiselBlock block) {
        this.models.put(loc, block);
    }

    public <T extends Block> void register(T block) {
        for (int i = 0; i < ((ICarvable)block).getTotalVariations(); ++i) {
            int blockNum = i / 16;
            ModelResourceLocation location = blockNum == 0 ? new ModelResourceLocation(block.getRegistryName(), "variation=" + i) : new ModelResourceLocation(block.getRegistryName() + blockNum, "variation=" + i);
            this.register(location, new ModelChiselBlock());
            ModelResourceLocation inventoryLocation = i == 0 ? new ModelResourceLocation(block.getRegistryName(), "inventory") : new ModelResourceLocation(block.getRegistryName() + blockNum, "inventory");
            this.register(inventoryLocation, new ModelChiselBlock());
            Chisel.debug("Setting custom resource location for Item " + Item.func_150898_a(block) + " with meta " + i + " to location " + inventoryLocation);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a(block), (int)i, (ModelResourceLocation)inventoryLocation);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, ModelChiselBlock> entry : this.models.entrySet()) {
            Chisel.debug("Registering model for " + entry.getKey().toString());
            event.modelRegistry.func_82595_a((Object)entry.getKey(), (Object)entry.getValue());
        }
    }
}

