/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import java.util.Random;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class ClientUtil {
    public static final Random rand = new Random();
    public static final TRSRTransformation DEFAULT_BLOCK_THIRD_PERSON_TRANSOFRM = new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null);
    public static final Matrix4f DEFAULT_BLOCK_THIRD_PERSON_MATRIX = DEFAULT_BLOCK_THIRD_PERSON_TRANSOFRM.getMatrix();

    public static void playSound(World world, int x, int y, int z, String sound) {
        Minecraft.func_71410_x().field_71441_e.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, 0.3f + 0.7f * rand.nextFloat(), 0.6f + 0.4f * rand.nextFloat(), true);
    }

    public static void addHitEffects(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        state = block.func_176221_a(state, (IBlockAccess)world, pos);
        if (block.func_149645_b() != -1) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            double d0 = (double)i + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
            double d1 = (double)j + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
            double d2 = (double)k + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + block.func_149665_z() - (double)f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + block.func_149669_A() + (double)f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + block.func_149706_B() - (double)f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + block.func_149693_C() + (double)f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + block.func_149704_x() - (double)f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + block.func_149753_y() + (double)f;
            }
            ((EntityDiggingFX)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)state.func_177230_c())})).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f).func_180435_a(Minecraft.func_71410_x().func_175602_ab().func_175022_a(state, (IBlockAccess)world, pos).func_177554_e());
        }
    }

    public static void addDestroyEffects(World world, BlockPos pos, IBlockState state) {
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    ((EntityDiggingFX)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_149682_b((Block)state.func_177230_c())})).func_174846_a(pos).func_180435_a(Minecraft.func_71410_x().func_175602_ab().func_175022_a(state, (IBlockAccess)world, pos).func_177554_e());
                }
            }
        }
    }
}

