/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;

public final class ChiselFace
implements IChiselFace {
    private List<IChiselTexture<?>> textureList;
    private List<IChiselFace> childFaces;
    private ResourceLocation location;
    private EnumWorldBlockLayer layer;

    public ChiselFace(ResourceLocation location) {
        this(new ArrayList(), new ArrayList<IChiselFace>(), location);
    }

    public ChiselFace(ResourceLocation location, EnumWorldBlockLayer layer) {
        this(location);
        this.setLayer(layer);
    }

    public ChiselFace(List<IChiselTexture<?>> textureList, List<IChiselFace> childFaces, ResourceLocation location) {
        this.textureList = textureList;
        this.childFaces = childFaces;
        this.location = location;
    }

    @Override
    public List<IChiselTexture<?>> getTextureList() {
        ArrayList list = new ArrayList();
        list.addAll(this.textureList);
        for (IChiselFace face : this.childFaces) {
            list.addAll(face.getTextureList());
        }
        return list;
    }

    @Override
    public void addTexture(IChiselTexture<?> texture) {
        this.textureList.add(texture);
    }

    @Override
    public void addChildFace(IChiselFace face) {
        this.childFaces.add(face);
    }

    public boolean removeTexture(IChiselTexture<?> texture) {
        return this.textureList.remove(texture);
    }

    public boolean removeChildFace(IChiselFace face) {
        return this.childFaces.remove(face);
    }

    @Override
    public TextureAtlasSprite getParticle() {
        if (this.textureList.get(0) != null) {
            return this.textureList.get(0).getParticle();
        }
        return this.childFaces.get(0).getParticle();
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLayer(EnumWorldBlockLayer layer) {
        this.layer = layer;
    }

    @Override
    public EnumWorldBlockLayer getLayer() {
        return this.layer;
    }
}

