/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.block;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import team.chisel.Chisel;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselRecipe;
import team.chisel.api.block.VariationData;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.render.ChiselModelRegistry;
import team.chisel.common.init.BlockRegistry;

public class ChiselBlockBuilder<T extends Block> {
    private final Material material;
    private final String domain;
    private final String blockName;
    private Block.SoundType sound;
    private int curIndex;
    private List<VariationBuilder<T>> variations;
    private BlockProvider<T> provider;
    private String parentFolder;
    private String group;

    protected ChiselBlockBuilder(Material material, String domain, String blockName, BlockProvider<T> provider) {
        this.material = material;
        this.domain = domain;
        this.blockName = blockName;
        this.provider = provider;
        this.parentFolder = blockName;
        this.variations = new ArrayList<VariationBuilder<T>>();
    }

    public VariationBuilder<T> newVariation(String name) {
        return this.newVariation(name, this.group == null ? this.blockName : this.group);
    }

    public VariationBuilder<T> newVariation(String name, String group) {
        VariationBuilder builder = new VariationBuilder(this, name, group, this.curIndex);
        ++this.curIndex;
        return builder;
    }

    public T[] build() {
        if (this.variations.size() == 0) {
            throw new IllegalArgumentException("Must have at least one variation!");
        }
        VariationData[] vars = new VariationData[this.variations.size()];
        for (int i = 0; i < this.variations.size(); ++i) {
            vars[i] = ((VariationBuilder)this.variations.get(i)).doBuild();
        }
        VariationData[][] data = BlockRegistry.splitVariationArray(vars);
        Block[] ret = (Block[])Array.newInstance(this.provider.getBlockClass(), data.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.provider.createBlock(this.material, i, vars.length, data[i]);
            ret[i].setRegistryName(this.blockName + (i == 0 ? "" : Integer.valueOf(i)));
            ret[i].func_149663_c(this.domain + '.' + this.blockName);
            if (this.sound != null) {
                ret[i].field_149762_H = this.sound;
            }
            GameRegistry.registerBlock((Block)ret[i], this.provider.getItemClass());
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                ChiselModelRegistry.INSTANCE.register(ret[i]);
            }
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j].group == null) continue;
                CarvingUtils.getChiselRegistry().addVariation(data[i][j].group, ret[i].func_176203_a(j), i * 16 + j);
            }
        }
        return ret;
    }

    public ChiselBlockBuilder<T> setSound(Block.SoundType sound) {
        this.sound = sound;
        return this;
    }

    public ChiselBlockBuilder<T> setCurIndex(int curIndex) {
        this.curIndex = curIndex;
        return this;
    }

    public ChiselBlockBuilder<T> setVariations(List<VariationBuilder<T>> variations) {
        this.variations = variations;
        return this;
    }

    public ChiselBlockBuilder<T> setProvider(BlockProvider<T> provider) {
        this.provider = provider;
        return this;
    }

    public ChiselBlockBuilder<T> setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        return this;
    }

    public ChiselBlockBuilder<T> setGroup(String group) {
        this.group = group;
        return this;
    }

    public static class VariationBuilder<T extends Block> {
        private ChiselBlockBuilder<T> parent;
        private String name;
        private String group;
        private int index;
        private ChiselRecipe recipe;
        private ItemStack smeltedFrom;
        private int amountSmelted;
        private ResourceLocation textureLocation;
        private Map<EnumFacing, ResourceLocation> overrideMap;

        private VariationBuilder(ChiselBlockBuilder<T> parent, String name, String group, int index) {
            this.parent = parent;
            this.name = name;
            this.group = group;
            this.index = index;
            this.overrideMap = new HashMap<EnumFacing, ResourceLocation>();
            String path = ((ChiselBlockBuilder)parent).parentFolder;
            if (!path.isEmpty()) {
                path = path + "/";
            }
            this.textureLocation = new ResourceLocation(((ChiselBlockBuilder)parent).domain, path + name);
        }

        public VariationBuilder<T> setSmeltRecipe(ItemStack smeltedFrom, int amountSmelted) {
            this.smeltedFrom = smeltedFrom;
            this.amountSmelted = amountSmelted;
            return this;
        }

        public VariationBuilder<T> setTextureLocation(String path) {
            return this.setTextureLocation(new ResourceLocation(((ChiselBlockBuilder)this.parent).domain, path));
        }

        public VariationBuilder<T> setTextureLocation(String path, Predicate<EnumFacing> validFacings) {
            return this.setTextureLocation(this.getForPath(path), validFacings);
        }

        public VariationBuilder<T> setTextureLocation(ResourceLocation loc, Predicate<EnumFacing> validFacings) {
            return this.setTextureLocation(loc, (EnumFacing[])FluentIterable.from(Arrays.asList(EnumFacing.field_82609_l)).filter(validFacings).toArray(EnumFacing.class));
        }

        public VariationBuilder<T> setTextureLocation(String path, EnumFacing ... facings) {
            return this.setTextureLocation(this.getForPath(path), facings);
        }

        private ResourceLocation getForPath(String path) {
            return new ResourceLocation(((ChiselBlockBuilder)this.parent).domain, path);
        }

        public VariationBuilder<T> setTextureLocation(ResourceLocation loc, EnumFacing ... facings) {
            for (EnumFacing f : facings) {
                this.overrideMap.put(f, loc);
            }
            return this;
        }

        public ChiselBlockBuilder<T> buildVariation() {
            ((ChiselBlockBuilder)this.parent).variations.add(this);
            return this.parent;
        }

        public VariationBuilder<T> next(String name) {
            return this.buildVariation().newVariation(name);
        }

        public VariationBuilder<T> next(String name, String group) {
            return this.buildVariation().newVariation(name, group);
        }

        public T[] build() {
            return this.buildVariation().build();
        }

        private VariationData doBuild() {
            return Chisel.proxy.getBuilderDelegate().build(this.name, this.group, this.index, this.recipe, this.smeltedFrom, this.amountSmelted, this.textureLocation, this.overrideMap);
        }

        public VariationBuilder<T> setRecipe(ChiselRecipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public VariationBuilder<T> setTextureLocation(ResourceLocation textureLocation) {
            this.textureLocation = textureLocation;
            return this;
        }

        public static interface IVariationBuilderDelegate {
            public VariationData build(String var1, String var2, int var3, ChiselRecipe var4, ItemStack var5, int var6, ResourceLocation var7, Map<EnumFacing, ResourceLocation> var8);
        }
    }
}

