/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.mods;

import com.minimap.XaeroMinimap;
import com.minimap.minimap.MinimapChunk;
import com.minimap.settings.ModSettings;
import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.map.MapLoader;
import xaero.map.MapRegion;
import xaero.map.MapSaveLoad;
import xaero.map.WorldMap;
import xaero.map.gui.ChunksChunk;

public class SupportXaeroWorldmap {
    public boolean test = WorldMap.instance != null;
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color slime = new Color(82, 241, 64, 128);

    public void drawMinimap(int xFloored, int zFloored, int chunkAmount, boolean zooming, double zoom) {
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        Gui.func_73734_a((int)(-chunkAmount * 8), (int)(-chunkAmount * 8), (int)(chunkAmount * 8), (int)(chunkAmount * 8), (int)black.hashCode());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int minX = mapX - chunkAmount / 2 >> 2;
        int maxX = mapX + chunkAmount / 2 >> 2;
        int minZ = mapZ - chunkAmount / 2 >> 2;
        int maxZ = mapZ + chunkAmount / 2 >> 2;
        int viewSize = (int)((double)chunkAmount / zoom);
        int minViewX = (mapX - viewSize / 2 >> 2) - 1;
        int maxViewX = (mapX + viewSize / 2 >> 2) + 1;
        int minViewZ = (mapZ - viewSize / 2 >> 2) - 1;
        int maxViewZ = (mapZ + viewSize / 2 >> 2) + 1;
        for (int i = minX; i < maxX + 1; ++i) {
            for (int j = minZ; j < maxZ + 1; ++j) {
                ChunksChunk chunk;
                MapRegion region = MapLoader.getMapRegion((int)(i >> 3), (int)(j >> 3), (boolean)true);
                if (region.version != MapLoader.globalVersion) {
                    MapSaveLoad.requestLoad((MapRegion)region, null);
                }
                if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.chunks[i & 7][j & 7]) == null) continue;
                int textureSize = chunk.getTexture(16) == -1 ? 8 : 16;
                chunk.bindGlTexture(false, textureSize);
                if (chunk.getTexture(textureSize) == -1) continue;
                if (!zooming) {
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                } else {
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                }
                int drawX = 64 * (chunk.X - chunkX) - 16 * tileX - insideX;
                int drawZ = 64 * (chunk.Z - chunkZ) - 16 * tileZ - insideZ - 1;
                SupportXaeroWorldmap.drawMyTexturedModalRect(drawX, drawZ, 0, 0, 64.0f, 64.0f);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                int r = 0;
                int g = 0;
                int b = 0;
                if (XaeroMinimap.getSettings().chunkGrid > -1) {
                    int grid = ModSettings.COLORS[XaeroMinimap.getSettings().chunkGrid];
                    r = grid >> 16 & 0xFF;
                    g = grid >> 8 & 0xFF;
                    b = grid & 0xFF;
                }
                for (int t = 0; t < 16; ++t) {
                    if ((chunk.tileGridsCache[t % 4][t / 4] & 1) == 0) {
                        chunk.tileGridsCache[t % 4][t / 4] = 1 | (MinimapChunk.isSlimeChunk(chunk.X * 4 + t % 4, chunk.Z * 4 + t / 4) ? 2 : 0) | ((t % 4 & 1) == (t / 4 & 1) ? 4 : 0);
                    }
                    if (XaeroMinimap.getSettings().getSlimeChunks() && (chunk.tileGridsCache[t % 4][t / 4] & 2) != 0) {
                        int slimeDrawX = drawX + 16 * (t % 4);
                        int slimeDrawZ = drawZ + 16 * (t / 4);
                        Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)slime.hashCode());
                    }
                    if (XaeroMinimap.getSettings().chunkGrid <= -1 || (chunk.tileGridsCache[t % 4][t / 4] & 4) == 0) continue;
                    int gridDrawX = drawX + 16 * (t % 4);
                    int gridDrawZ = drawZ + 16 * (t / 4);
                    Gui.func_73734_a((int)gridDrawX, (int)gridDrawZ, (int)(gridDrawX + 16), (int)(gridDrawZ + 16), (int)new Color(r, g, b, 64).hashCode());
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_181673_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_181673_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

