/*
 * Decompiled with CFR 0.152.
 */
package com.minimap.minimap;

import com.minimap.XaeroMinimap;
import com.minimap.animation.Animation;
import com.minimap.interfaces.Interface;
import com.minimap.interfaces.InterfaceHandler;
import com.minimap.minimap.DynamicTexture;
import com.minimap.minimap.MinimapChunk;
import com.minimap.minimap.WaypointSet;
import com.minimap.minimap.WaypointWorld;
import com.minimap.mods.SupportMods;
import com.minimap.settings.ModSettings;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Blocks;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

public class Minimap {
    public Interface screen;
    public static final int frame = 9;
    public static int loadingSide = 16;
    public static int loadedSide = 16;
    public static int updateRadius = 16;
    public static boolean enlargedMap = false;
    public static Minecraft mc = Minecraft.func_71410_x();
    public int loadedCaving = -1;
    private int loadingCaving = -1;
    public static final Color radarPlayers = new Color(255, 255, 255);
    public static final Color radarShadow = new Color(0, 0, 0);
    public static ArrayList<Entity> loadedPlayers = new ArrayList();
    public static ArrayList<Entity> loadedLiving = new ArrayList();
    public static ArrayList<Entity> loadedHostile = new ArrayList();
    public static ArrayList<Entity> loadedItems = new ArrayList();
    public static ArrayList<Entity> loadedEntities = new ArrayList();
    public static int blocksLoaded = 0;
    public int loadingMapX = 0;
    public int loadingMapZ = 0;
    public int loadedMapX = 0;
    public int loadedMapZ = 0;
    public double minimapZoom = 1.0;
    public int minimapWidth = 0;
    public int minimapHeight = 0;
    public MapLoader loader = new MapLoader();
    public static HashMap<String, WaypointWorld> waypointMap = new HashMap();
    public static WaypointSet waypoints = null;
    private static String worldID = null;
    public static String customWorldID = null;
    public MinimapChunk[][] currentBlocks = new MinimapChunk[16][16];
    public MinimapChunk[][] loadingBlocks = new MinimapChunk[16][16];
    public static boolean frameIsUpdating = false;
    public static boolean frameUpdateNeeded = false;
    public static int bufferSizeToUpdate = -1;
    public static float frameUpdatePartialTicks = 1.0f;
    public static boolean updatePause = false;
    Integer previousTransparentBlock = null;
    int underRed;
    int underGreen;
    int underBlue;
    float divider = 1.0f;
    int sun;
    public float postBrightness;
    int blockY = 0;
    int blockColor = 0;
    public static HashMap<String, Integer> textureColours = new HashMap();
    public static HashMap<Integer, Integer> blockColours = new HashMap();
    public static boolean clearBlockColours = false;
    boolean isglowing = false;
    public int[] lastBlockY = new int[16];
    public static float sunBrightness;
    private byte[] bytes;
    private byte drawYState = 0;
    private static boolean toResetImage;
    public static double zoom;
    public static final int[] minimapSizes;
    public static final int[] bufferSizes;
    public static final int[] FBOMinimapSizes;
    public static final int[] FBOBufferSizes;
    public static boolean triedFBO;
    public static boolean loadedFBO;
    public static DynamicTexture mapTexture;
    public static Framebuffer scalingFrameBuffer;
    public static Framebuffer rotationFrameBuffer;
    public static int mapUpdateX;
    public static int mapUpdateZ;

    public static int getLoadSide() {
        return enlargedMap ? 31 : FBOMinimapSizes[XaeroMinimap.getSettings().getMinimapSize()];
    }

    public static int getUpdateRadius() {
        return (int)Math.ceil((double)loadingSide / 2.0 / (double)XaeroMinimap.getSettings().zooms[XaeroMinimap.getSettings().zoom]);
    }

    private static String getWorld() {
        if (mc.func_71401_C() != null) {
            return mc.func_71401_C().func_71270_I() + "_" + Minimap.mc.field_71441_e.field_73011_w.getSaveFolder();
        }
        if (mc.func_147104_D() != null) {
            String serverIP = Minimap.mc.func_147104_D().field_78845_b;
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            return "Multiplayer_" + serverIP.replaceAll(":", "\u00a7") + "_" + Minimap.mc.field_71441_e.field_73011_w.getSaveFolder();
        }
        return "Unknown_null";
    }

    public static String getCurrentWorldID() {
        if (customWorldID == null) {
            return worldID;
        }
        return customWorldID;
    }

    public static WaypointWorld getCurrentWorld() {
        return waypointMap.get(Minimap.getCurrentWorldID());
    }

    public static String getAutoWorldID() {
        return worldID;
    }

    private static WaypointSet getWaypoints() {
        if (customWorldID == null) {
            return waypointMap.get(worldID).getCurrentSet();
        }
        return waypointMap.get(customWorldID).getCurrentSet();
    }

    public static void addWorld(String id) {
        if (waypointMap.get(id) == null) {
            waypointMap.put(id, new WaypointWorld());
        }
    }

    public static void updateWaypoints() {
        worldID = Minimap.getWorld();
        Minimap.addWorld(worldID);
        waypoints = Minimap.getWaypoints();
    }

    public Minimap(Interface i) {
        this.screen = i;
        new Thread(this.loader).start();
    }

    public static int loadBlockColourFromTexture(IBlockState state, Block b, BlockPos pos, boolean convert) {
        int grassColor;
        int stateId = state.toString().hashCode();
        Integer c = blockColours.get(stateId);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (c == null) {
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            String name = null;
            try {
                Integer cachedColour;
                name = texture.func_94215_i() + ".png";
                if (b instanceof BlockGrass) {
                    name = "minecraft:blocks/grass_top.png";
                } else if (b == Blocks.field_150419_aX) {
                    name = "minecraft:blocks/mushroom_block_skin_red.png";
                } else if (b == Blocks.field_150420_aW) {
                    name = "minecraft:blocks/mushroom_block_skin_brown.png";
                } else if (b instanceof BlockOre && b != Blocks.field_150449_bY) {
                    name = "minecraft:blocks/stone.png";
                }
                if (convert) {
                    name = name.replaceAll("_side", "_top").replaceAll("_front.png", "_top.png");
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    args = new String[]{"minecraft", args[0]};
                }
                if ((cachedColour = textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                    InputStream input = resource.func_110527_b();
                    BufferedImage img = TextureUtil.func_177053_a((InputStream)input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            if (rgb == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    c = 0xFF000000 | (red /= total) << 16 | (green /= total) << 8 | (blue /= total);
                    textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return Minimap.loadBlockColourFromTexture(state, b, pos, false);
                }
                c = b.func_180659_g((IBlockState)state).field_76291_p;
                if (name != null) {
                    textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + b.func_149732_F());
            }
            catch (Exception e) {
                c = b.func_180659_g((IBlockState)state).field_76291_p;
                if (name != null) {
                    textureColours.put(name, c);
                }
                System.out.println("Block " + b.func_149732_F() + " has no texture, using material colour.");
            }
            if (c != null) {
                blockColours.put(stateId, c);
            }
        }
        if ((grassColor = b.func_176202_d((IBlockAccess)Minecraft.func_71410_x().field_71441_e, pos)) != 0xFFFFFF) {
            float rMultiplier = (float)(c >> 16 & 0xFF) / 255.0f;
            float gMultiplier = (float)(c >> 8 & 0xFF) / 255.0f;
            float bMultiplier = (float)(c & 0xFF) / 255.0f;
            red = (int)((float)(grassColor >> 16 & 0xFF) * rMultiplier);
            green = (int)((float)(grassColor >> 8 & 0xFF) * gMultiplier);
            blue = (int)((float)(grassColor & 0xFF) * bMultiplier);
            c = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return c;
    }

    public boolean applyTransparentBlock(Chunk bchunk, Block b, IBlockState state, BlockPos globalPos, BlockPos pos) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int intensity = 1;
        boolean skip = false;
        if (b instanceof BlockLiquid && b.func_149717_k() != 255 && b.func_149717_k() != 0) {
            switch (XaeroMinimap.getSettings().blockColours) {
                case 1: {
                    red = 0;
                    green = 100;
                    blue = 225;
                    break;
                }
                case 0: {
                    int waterColor = Minimap.loadBlockColourFromTexture(state, b, globalPos, true);
                    red = waterColor >> 16 & 0xFF;
                    green = waterColor >> 8 & 0xFF;
                    blue = waterColor & 0xFF;
                }
            }
            intensity = 2;
            skip = true;
        } else if (XaeroMinimap.getSettings().blockColours == 0 && (b.func_180664_k() == EnumWorldBlockLayer.TRANSLUCENT || b instanceof BlockGlass)) {
            int glassColor = Minimap.loadBlockColourFromTexture(state, b, globalPos, true);
            red = glassColor >> 16 & 0xFF;
            green = glassColor >> 8 & 0xFF;
            blue = glassColor & 0xFF;
            skip = true;
        } else if (XaeroMinimap.getSettings().blockColours == 1 && b instanceof BlockStainedGlass) {
            int i5 = bchunk.func_177418_c(pos);
            int color = b.func_180659_g((IBlockState)b.func_176203_a((int)i5)).field_76291_p;
            red = color >> 16 & 0xFF;
            green = color >> 8 & 0xFF;
            blue = color & 0xFF;
            skip = true;
        }
        if (skip) {
            if (this.previousTransparentBlock == null) {
                this.postBrightness = this.getBlockBrightness(bchunk, new BlockPos(pos.func_177958_n(), Math.min(pos.func_177956_o() + 1, 255), pos.func_177952_p()), 5.0f, this.sun, true);
            }
            int rgb = red << 16 | green << 8 | blue;
            if (this.previousTransparentBlock == null || this.previousTransparentBlock != rgb) {
                this.previousTransparentBlock = rgb;
                float overlayIntensity = (float)intensity * this.getBlockBrightness(bchunk, new BlockPos(pos.func_177958_n(), Math.min(pos.func_177956_o() + 1, 255), pos.func_177952_p()), 5.0f, this.sun, false);
                if (this.isGlowing(b)) {
                    int[] colours = this.getBrightestColour(red, green, blue);
                    red = colours[0];
                    green = colours[1];
                    blue = colours[2];
                }
                this.divider += overlayIntensity;
                this.underRed = (int)((float)this.underRed + (float)red * overlayIntensity);
                this.underGreen = (int)((float)this.underGreen + (float)green * overlayIntensity);
                this.underBlue = (int)((float)this.underBlue + (float)blue * overlayIntensity);
            }
            this.sun -= b.func_149717_k();
            if (this.sun < 0) {
                this.sun = 0;
            }
        }
        return skip;
    }

    public Block findBlock(Chunk bchunk, int insideX, int insideZ, int highY, int lowY) {
        boolean underair = false;
        for (int i = highY; i >= lowY; --i) {
            Block got = bchunk.func_177438_a(insideX, i, insideZ);
            if (!(got instanceof BlockAir) && (underair || this.loadingCaving == -1)) {
                if (got.func_149645_b() == -1 || got == Blocks.field_150478_aa || got == Blocks.field_150329_H || !XaeroMinimap.getSettings().showFlowers && (got instanceof BlockFlower || got instanceof BlockDoublePlant || got instanceof BlockDeadBush) || !XaeroMinimap.getSettings().displayRedstone && (got == Blocks.field_150429_aA || got == Blocks.field_150488_af || got instanceof BlockRedstoneRepeater || got instanceof BlockRedstoneComparator)) continue;
                this.blockY = i;
                int color = 0;
                BlockPos pos = new BlockPos(insideX, this.blockY, insideZ);
                BlockPos globalPos = this.getGlobalBlockPos(bchunk.field_76635_g, bchunk.field_76647_h, insideX, this.blockY, insideZ);
                IBlockState state = bchunk.func_177435_g(pos);
                if (XaeroMinimap.getSettings().blockColours == 0) {
                    state = got.getExtendedState(state, (IBlockAccess)Minimap.mc.field_71441_e, globalPos);
                }
                if (this.applyTransparentBlock(bchunk, got, state, globalPos, pos)) continue;
                if (XaeroMinimap.getSettings().blockColours == 1) {
                    MapColor minimapColor = got.func_180659_g(state);
                    color = minimapColor.field_76291_p;
                } else {
                    color = Minimap.loadBlockColourFromTexture(state, got, globalPos, true);
                }
                if (color == 0) continue;
                this.blockColor = color;
                return got;
            }
            if (!(got instanceof BlockAir)) continue;
            underair = true;
        }
        return null;
    }

    public BlockPos getGlobalBlockPos(int chunkX, int chunkZ, int x, int y, int z) {
        return new BlockPos(chunkX * 16 + x, y, chunkZ * 16 + z);
    }

    public float getBlockBrightness(Chunk c, BlockPos pos, float min, int sun, boolean dayLight) {
        if (!XaeroMinimap.getSettings().lighting) {
            return (min + (float)sun) / (15.0f + min);
        }
        return (min + Math.max((dayLight ? sunBrightness : 1.0f) * (float)c.func_177413_a(EnumSkyBlock.SKY, pos), (float)c.func_177413_a(EnumSkyBlock.BLOCK, pos))) / (15.0f + min);
    }

    public int[] getBrightestColour(int r, int g, int b) {
        int max = Math.max(r, Math.max(g, b));
        if (max == 0) {
            return new int[]{r, g, b};
        }
        r = 255 * r / max;
        g = 255 * g / max;
        b = 255 * b / max;
        return new int[]{r, g, b};
    }

    public boolean isGlowing(Block b) {
        return (double)b.func_149750_m() >= 0.5;
    }

    public void loadBlockColor(int par1, int par2, Chunk bchunk, int chunkX, int chunkZ) {
        MinimapChunk chunk;
        int lowY;
        int insideX = par1 & 0xF;
        int insideZ = par2 & 0xF;
        int playerY = (int)Minimap.mc.field_71439_g.field_70163_u;
        int height = bchunk.func_76611_b(insideX, insideZ);
        int highY = this.loadingCaving != -1 ? this.loadingCaving : height + 3;
        int n = lowY = this.loadingCaving != -1 ? playerY - 30 : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        this.blockY = 0;
        this.blockColor = 0;
        this.underRed = 0;
        this.underGreen = 0;
        this.underBlue = 0;
        this.divider = 1.0f;
        this.sun = 15;
        this.previousTransparentBlock = null;
        this.postBrightness = 1.0f;
        this.isglowing = false;
        Block block = this.findBlock(bchunk, insideX, insideZ, highY, lowY);
        this.isglowing = block != null && !(block instanceof BlockOre) && this.isGlowing(block);
        float brightness = 1.0f;
        if (!XaeroMinimap.getSettings().lighting && this.loadingCaving != -1) {
            brightness = (float)((double)brightness * Math.min((double)this.blockY / (double)height, 1.0));
        } else {
            BlockPos pos = new BlockPos(insideX, Math.min(this.blockY + 1, 255), insideZ);
            brightness = this.getBlockBrightness(bchunk, pos, 5.0f, this.sun, this.previousTransparentBlock == null);
        }
        double secondaryB = 1.0;
        if (this.lastBlockY[insideX] <= 0) {
            this.lastBlockY[insideX] = this.blockY;
            Chunk prevChunk = Minimap.mc.field_71441_e.func_72964_e(this.loadingMapX + chunkX, this.loadingMapZ + chunkZ - 1);
            if (prevChunk != null && prevChunk.func_177410_o()) {
                this.lastBlockY[insideX] = prevChunk.func_76611_b(insideX, 15) - 1;
            }
        }
        if (this.blockY < this.lastBlockY[insideX]) {
            secondaryB -= 0.15;
        }
        if (this.blockY > this.lastBlockY[insideX]) {
            secondaryB += 0.15;
        }
        brightness = (float)((double)brightness * secondaryB);
        this.lastBlockY[insideX] = this.blockY;
        if (this.blockColor == 0) {
            this.blockColor = 1;
        }
        int l = this.blockColor >> 16 & 0xFF;
        int i1 = this.blockColor >> 8 & 0xFF;
        int j1 = this.blockColor & 0xFF;
        if (this.isglowing) {
            int[] colours = this.getBrightestColour(l, i1, j1);
            l = colours[0];
            i1 = colours[1];
            j1 = colours[2];
        }
        if ((l = (int)(((float)l * brightness + (float)this.underRed) / this.divider * this.postBrightness)) > 255) {
            l = 255;
        }
        if ((i1 = (int)(((float)i1 * brightness + (float)this.underGreen) / this.divider * this.postBrightness)) > 255) {
            i1 = 255;
        }
        if ((j1 = (int)(((float)j1 * brightness + (float)this.underBlue) / this.divider * this.postBrightness)) > 255) {
            j1 = 255;
        }
        this.blockColor = 0xFF000000 | l << 16 | i1 << 8 | j1;
        if (chunkX < 0 || chunkX >= loadingSide || chunkZ < 0 || chunkZ >= loadingSide) {
            return;
        }
        MinimapChunk[] chunkmap = this.loadingBlocks[chunkX];
        if (chunkmap == null) {
            chunkmap = new MinimapChunk[loadingSide];
            this.loadingBlocks[chunkX] = chunkmap;
        }
        if ((chunk = chunkmap[chunkZ]) == null) {
            chunkmap[chunkZ] = chunk = new MinimapChunk(bchunk.field_76635_g, bchunk.field_76647_h);
        }
        chunk.colors[insideX][insideZ] = this.blockColor;
    }

    public int getMapCoord(int side, double coord) {
        return (Minimap.myFloor(coord) >> 4) - side / 2;
    }

    public int getLoadedBlockColor(int par1, int par2) {
        int cX = (par1 >> 4) - this.loadedMapX;
        int cZ = (par2 >> 4) - this.loadedMapZ;
        if (cX < 0 || cX >= loadedSide || cZ < 0 || cZ >= loadedSide) {
            return 1;
        }
        MinimapChunk current = this.currentBlocks[cX][cZ];
        if (current != null) {
            return this.chunkOverlay(current.colors[par1 & 0xF][par2 & 0xF], current);
        }
        return 1;
    }

    public MinimapChunk[] getLoadedYChunks(int par1) {
        int cX = (par1 >> 4) - this.loadedMapX;
        if (cX < 0 || cX >= loadedSide) {
            return null;
        }
        return this.currentBlocks[cX];
    }

    public int getLoadedBlockColor(MinimapChunk[] yChunks, int par1, int par2) {
        int cZ = (par2 >> 4) - this.loadedMapZ;
        if (cZ < 0 || cZ >= loadedSide) {
            return 1;
        }
        MinimapChunk current = yChunks[cZ];
        if (current != null) {
            return this.chunkOverlay(current.colors[par1 & 0xF][par2 & 0xF], current);
        }
        return 1;
    }

    public int gridOverlay(int color) {
        int grid = ModSettings.COLORS[XaeroMinimap.getSettings().chunkGrid];
        int r = ((color >> 16 & 0xFF) * 3 + (grid >> 16 & 0xFF)) / 4;
        int g = ((color >> 8 & 0xFF) * 3 + (grid >> 8 & 0xFF)) / 4;
        int b = ((color & 0xFF) * 3 + (grid & 0xFF)) / 4;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public int slimeOverlay(int color) {
        int r = ((color >> 16 & 0xFF) + 82) / 2;
        int g = ((color >> 8 & 0xFF) + 241) / 2;
        int b = ((color & 0xFF) + 64) / 2;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public int chunkOverlay(int color, MinimapChunk c) {
        if (XaeroMinimap.getSettings().getSlimeChunks() && c.slimeChunk) {
            return this.slimeOverlay(color);
        }
        if (XaeroMinimap.getSettings().chunkGrid > -1 && c.chunkGrid) {
            return this.gridOverlay(color);
        }
        return color;
    }

    public static double getRenderAngle() {
        if (XaeroMinimap.getSettings().getLockNorth()) {
            return 90.0;
        }
        return Minimap.getActualAngle();
    }

    public static double getActualAngle() {
        double angle;
        double rotation = Minimap.mc.field_71439_g.field_70177_z;
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    public double getZoom() {
        return this.minimapZoom;
    }

    public void updateZoom() {
        double off;
        double target = XaeroMinimap.getSettings().zooms[XaeroMinimap.getSettings().zoom] * (XaeroMinimap.getSettings().caveZoom && this.loadedCaving != -1 ? 3.0f : 1.0f);
        if (target > (double)XaeroMinimap.getSettings().zooms[XaeroMinimap.getSettings().zooms.length - 1]) {
            target = XaeroMinimap.getSettings().zooms[XaeroMinimap.getSettings().zooms.length - 1];
        }
        off = (off = target - this.minimapZoom) > 0.01 || off < -0.01 ? (double)((float)Animation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public static double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)partial;
    }

    public static double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)partial;
    }

    public static void resetImage() {
        toResetImage = true;
    }

    public static int myFloor(double d) {
        if (d < 0.0) {
            d -= 1.0;
        }
        return (int)d;
    }

    public int getMinimapWidth() {
        return enlargedMap ? 448 : minimapSizes[XaeroMinimap.getSettings().getMinimapSize()];
    }

    public int getBufferSize() {
        return enlargedMap ? 512 : bufferSizes[XaeroMinimap.getSettings().getMinimapSize()];
    }

    public int getFBOBufferSize() {
        return enlargedMap ? 512 : FBOBufferSizes[XaeroMinimap.getSettings().getMinimapSize()];
    }

    public static boolean usingFBO() {
        return loadedFBO && !XaeroMinimap.getSettings().mapSafeMode;
    }

    public void updateMapFrame(int bufferSize, float partial) {
        EntityPlayerSP p = Minimap.mc.field_71439_g;
        long before = System.currentTimeMillis();
        if (toResetImage || Minimap.usingFBO()) {
            this.bytes = new byte[bufferSize * bufferSize * 3];
            toResetImage = false;
        }
        boolean motionBlur = Minecraft.func_175610_ah() >= 35;
        int increaseY = motionBlur ? 2 : 1;
        int mapW = 0;
        int mapH = 0;
        int halfW = 0;
        int halfH = 0;
        if (!Minimap.usingFBO()) {
            mapH = mapW = this.getMinimapWidth();
            halfW = (mapW + 1) / 2;
            halfH = (mapH + 1) / 2;
        }
        double halfWZoomed = (double)halfW / zoom;
        double halfHZoomed = (double)halfH / zoom;
        if (Minimap.usingFBO()) {
            int chunkAmount = loadedSide;
            int actualSize = Minimap.getLoadSide();
            mapUpdateX = this.getMapCoord(actualSize, Minimap.getEntityX((Entity)Minimap.mc.field_71439_g, partial));
            mapUpdateZ = this.getMapCoord(actualSize, Minimap.getEntityZ((Entity)Minimap.mc.field_71439_g, partial));
            int chunkOffsetX = mapUpdateX - this.loadedMapX;
            int chunkOffsetZ = mapUpdateZ - this.loadedMapZ;
            mapH = mapW = Math.min(bufferSize, actualSize * 16);
            double corner = enlargedMap ? 0.0 : (double)((int)((double)actualSize * (Math.sqrt(2.0) - 1.0) / Math.sqrt(2.0)));
            int cornerZoomed = (int)(corner + (double)actualSize * Math.sqrt(0.5) * (1.0 - 1.0 / zoom) - 1.0);
            int thing = actualSize - 1;
            for (int chunkX = 0; chunkX < chunkAmount - chunkOffsetX; ++chunkX) {
                MinimapChunk[] yChunks;
                int transformedX = chunkX + chunkOffsetX;
                if (transformedX < 0 || transformedX >= chunkAmount || (yChunks = this.currentBlocks[transformedX]) == null) continue;
                int drawX = 16 * chunkX;
                for (int chunkZ = 0; chunkZ < yChunks.length - chunkOffsetZ; ++chunkZ) {
                    MinimapChunk c;
                    int transformedZ;
                    if (chunkX + chunkZ < cornerZoomed || thing - chunkZ + chunkX < cornerZoomed || thing - chunkX + chunkZ < cornerZoomed || 2 * thing - chunkX - chunkZ < cornerZoomed || (transformedZ = chunkZ + chunkOffsetZ) < 0 || transformedZ >= chunkAmount || (c = yChunks[transformedZ]) == null) continue;
                    int drawY = 16 * chunkZ;
                    for (int insideX = 0; insideX < 16; ++insideX) {
                        int[] blocks = c.colors[insideX];
                        int pixelX = drawX + insideX;
                        if (pixelX >= mapW || pixelX < 0) continue;
                        for (int insideZ = 0; insideZ < 16; ++insideZ) {
                            int pixelY = drawY + insideZ;
                            if (pixelY < 0 || pixelY >= mapH) continue;
                            this.putColor(this.bytes, pixelX, pixelY, this.chunkOverlay(blocks[insideZ], c), bufferSize);
                        }
                    }
                }
            }
        } else {
            int currentState = this.drawYState;
            double angle = Math.toRadians(Minimap.getRenderAngle());
            double ps = Math.sin(Math.PI - angle);
            double pc = Math.cos(Math.PI - angle);
            double playerX = Minimap.getEntityX((Entity)Minimap.mc.field_71439_g, partial);
            double playerZ = Minimap.getEntityZ((Entity)Minimap.mc.field_71439_g, partial);
            for (int currentX = 0; currentX <= mapW + 1; ++currentX) {
                int currentY;
                double currentXZoomed = (double)currentX / zoom;
                double offx = currentXZoomed - halfWZoomed;
                double psx = ps * offx;
                double pcx = pc * offx;
                int n = currentY = motionBlur ? currentState : 0;
                while (currentY <= mapH + 1) {
                    double offy = (double)currentY / zoom - halfHZoomed;
                    this.putColor(this.bytes, currentX, currentY, this.getLoadedBlockColor(Minimap.myFloor(playerX + psx + pc * offy), Minimap.myFloor(playerZ + ps * offy - pcx)), bufferSize);
                    currentY += increaseY;
                }
                currentState = (byte)(currentState != 1 ? 1 : 0);
            }
            this.renderEntityListSafeMode((EntityPlayer)p, loadedEntities, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.renderEntityListSafeMode((EntityPlayer)p, loadedItems, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.renderEntityListSafeMode((EntityPlayer)p, loadedHostile, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.renderEntityListSafeMode((EntityPlayer)p, loadedLiving, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.renderEntityListSafeMode((EntityPlayer)p, loadedPlayers, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.renderEntityDotSafeMode((EntityPlayer)p, (Entity)p, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial);
            this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
            ByteBuffer buffer = mapTexture.getBuffer(bufferSize);
            buffer.put(this.bytes);
            buffer.flip();
        }
    }

    public void renderEntityListSafeMode(EntityPlayer p, ArrayList<Entity> list, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial) {
        for (int i = 0; i < list.size(); ++i) {
            Entity e = list.get(i);
            if (p != e && this.renderEntityDotSafeMode(p, e, pc, ps, mapW, bufferSize, halfW, halfH, playerX, playerZ, partial)) continue;
        }
    }

    public boolean renderEntityDotSafeMode(EntityPlayer p, Entity e, double pc, double ps, int mapW, int bufferSize, int halfW, int halfH, double playerX, double playerZ, float partial) {
        if (!Minimap.shouldRenderEntity(e)) {
            return false;
        }
        double offx = Minimap.getEntityX(e, partial) - playerX;
        double offz = Minimap.getEntityZ(e, partial) - playerZ;
        double offh = p.field_70163_u - e.field_70163_u;
        double Z = pc * offx + ps * offz;
        double X = ps * offx - pc * offz;
        int drawX = Minimap.myFloor((double)halfW + X * zoom);
        int drawY = Minimap.myFloor((double)halfH + Z * zoom);
        int color = Minimap.getEntityColour(p, e, offh);
        for (int a = drawX - 2; a < drawX + 4; ++a) {
            if (a < 0 || a > mapW) continue;
            for (int b = drawY - 2; b < drawY + 4; ++b) {
                if (b < 0 || b > mapW || (a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                    this.putColor(this.bytes, a, b, 0, bufferSize);
                    continue;
                }
                this.putColor(this.bytes, a, b, color, bufferSize);
            }
        }
        return true;
    }

    public int getCaving() {
        if (!XaeroMinimap.settings.getCaveMaps()) {
            return -1;
        }
        int x = Minimap.myFloor(Minimap.mc.field_71439_g.field_70165_t);
        int y = Math.max((int)Minimap.mc.field_71439_g.field_70163_u + 1, 0);
        int z = Minimap.myFloor(Minimap.mc.field_71439_g.field_70161_v);
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int insideX = x & 0xF;
        int insideZ = z & 0xF;
        Chunk bchunk = Minimap.mc.field_71439_g.field_70170_p.func_72964_e(chunkX, chunkZ);
        int top = bchunk.func_76611_b(insideX, insideZ);
        if (y < top) {
            for (int i = y; i < top; ++i) {
                Block got = bchunk.func_177438_a(insideX, i, insideZ);
                if (!got.func_149688_o().func_76218_k()) continue;
                return Math.min(y + 3, i);
            }
        }
        return -1;
    }

    private void putColor(byte[] bytes, int x, int y, int color, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)(color >> 16 & 0xFF);
        bytes[++pixel] = (byte)(color >> 8 & 0xFF);
        bytes[++pixel] = (byte)(color & 0xFF);
    }

    public static void loadFrameBuffer() {
        if (!GLContext.getCapabilities().GL_EXT_framebuffer_object) {
            System.out.println("FBO not supported! Using minimap safe mode.");
        } else {
            if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                System.out.println("FBO is supported but off. Turning it on.");
            }
            scalingFrameBuffer = new Framebuffer(512, 512, false);
            rotationFrameBuffer = new Framebuffer(512, 512, false);
            loadedFBO = Minimap.scalingFrameBuffer.field_147616_f != -1;
        }
        triedFBO = true;
    }

    public void renderFrameToFBO(int bufferSize, int viewW, float sizeFix, float partial, boolean retryIfError) {
        double zInsidePixel;
        updatePause = true;
        int chunkAmount = Minimap.getLoadSide();
        int mapW = chunkAmount * 16;
        double playerX = Minimap.getEntityX((Entity)Minimap.mc.field_71439_g, partial);
        double playerZ = Minimap.getEntityZ((Entity)Minimap.mc.field_71439_g, partial);
        int xFloored = Minimap.myFloor(playerX);
        int zFloored = Minimap.myFloor(playerZ);
        int offsetX = xFloored & 0xF;
        int offsetZ = zFloored & 0xF;
        int mapX = this.getMapCoord(chunkAmount, playerX);
        int mapZ = this.getMapCoord(chunkAmount, playerZ);
        boolean zooming = (double)((int)zoom) != zoom;
        ByteBuffer buffer = mapTexture.getBuffer(bufferSize);
        if (!(SupportMods.usingWorldMapChunks() && this.getCaving() == -1 || mapX == mapUpdateX && mapZ == mapUpdateZ && !zooming && retryIfError)) {
            if (!frameIsUpdating) {
                frameIsUpdating = true;
                this.updateMapFrame(bufferSize, partial);
                frameIsUpdating = false;
                buffer.put(this.bytes);
                buffer.flip();
                bufferSizeToUpdate = -1;
                frameUpdateNeeded = false;
            } else {
                offsetX += 16 * (mapX - mapUpdateX);
                offsetZ += 16 * (mapZ - mapUpdateZ);
            }
        }
        scalingFrameBuffer.func_147610_a(true);
        GL11.glClear((int)16640);
        GL11.glEnable((int)3553);
        RenderHelper.func_74518_a();
        try {
            Minimap.bindTextureBuffer(buffer, bufferSize, bufferSize, mapTexture.func_110552_b());
        }
        catch (Exception e) {
            if (retryIfError) {
                System.out.println("Error when binding texture buffer. Retrying...");
                this.renderFrameToFBO(bufferSize, viewW, sizeFix, partial, false);
            }
            System.out.println("Error after retrying... :( Please report to Xaero96 on MinecraftForum of PlanetMinecraft!");
        }
        long before = System.currentTimeMillis();
        if (!zooming) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GL11.glPushMatrix();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GL11.glPushMatrix();
        GlStateManager.func_179096_D();
        before = System.currentTimeMillis();
        double xInsidePixel = Minimap.getEntityX((Entity)Minimap.mc.field_71439_g, partial) - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = Minimap.getEntityZ((Entity)Minimap.mc.field_71439_g, partial) - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        zInsidePixel = 1.0 - zInsidePixel;
        float halfW = (float)mapW / 2.0f;
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - Minimap.getRenderAngle());
        GlStateManager.func_179109_b((float)256.0f, (float)256.0f, (float)-2000.0f);
        GlStateManager.func_179139_a((double)zoom, (double)zoom, (double)1.0);
        if (SupportMods.usingWorldMapChunks()) {
            SupportMods.worldmapSupport.drawMinimap(xFloored, zFloored, chunkAmount, zooming, zoom);
        } else {
            Minimap.drawMyTexturedModalRect(-halfW - (float)offsetX + 8.0f, -halfW - (float)offsetZ + 7.0f, 0, 0, mapW + offsetX, mapW + offsetZ, bufferSize);
        }
        scalingFrameBuffer.func_147609_e();
        rotationFrameBuffer.func_147610_a(false);
        GL11.glClear((int)16640);
        scalingFrameBuffer.func_147612_c();
        GlStateManager.func_179096_D();
        if (XaeroMinimap.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179109_b((float)(halfWView + 0.5f), (float)(511.5f - halfWView), (float)-2000.0f);
        if (!XaeroMinimap.getSettings().getLockNorth()) {
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)(-xInsidePixel * zoom), (double)(-zInsidePixel * zoom), (double)0.0);
        GlStateManager.func_179084_k();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(XaeroMinimap.getSettings().minimapOpacity / 100.0f));
        Minimap.drawMyTexturedModalRect(-256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        before = System.currentTimeMillis();
        mc.func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
        if (XaeroMinimap.getSettings().getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        EntityPlayerSP p = Minimap.mc.field_71439_g;
        Minimap.renderEntityListToFBO((EntityPlayer)p, loadedEntities, angle, playerX, playerZ, partial);
        Minimap.renderEntityListToFBO((EntityPlayer)p, loadedItems, angle, playerX, playerZ, partial);
        Minimap.renderEntityListToFBO((EntityPlayer)p, loadedLiving, angle, playerX, playerZ, partial);
        Minimap.renderEntityListToFBO((EntityPlayer)p, loadedHostile, angle, playerX, playerZ, partial);
        Minimap.renderEntityListToFBO((EntityPlayer)p, loadedPlayers, angle, playerX, playerZ, partial);
        mc.func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
        Minimap.renderEntityDotToFBO((EntityPlayer)p, (Entity)p, angle, playerX, playerZ, partial);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        rotationFrameBuffer.func_147609_e();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        updatePause = false;
        GlStateManager.func_179128_n((int)5889);
        GL11.glPopMatrix();
        GlStateManager.func_179128_n((int)5888);
        GL11.glPopMatrix();
    }

    public static void renderEntityListToFBO(EntityPlayer p, ArrayList<Entity> list, float angle, double playerX, double playerZ, float partial) {
        for (int i = 0; i < list.size(); ++i) {
            Entity e = list.get(i);
            if (p == e) continue;
            if ((Keyboard.isKeyDown((int)15) || XaeroMinimap.getSettings().playerHeads) && e instanceof AbstractClientPlayer) {
                Minimap.renderPlayerHeadToFBO(p, (AbstractClientPlayer)e, angle, playerX, playerZ, partial);
                continue;
            }
            Minimap.renderEntityDotToFBO(p, e, angle, playerX, playerZ, partial);
        }
    }

    public static void renderPlayerHeadToFBO(EntityPlayer mainPlayer, AbstractClientPlayer e, float angle, double playerX, double playerZ, float partial) {
        if (!Minimap.shouldRenderEntity((Entity)e)) {
            return;
        }
        double offx = Minimap.getEntityX((Entity)e, partial) - playerX;
        double offz = playerZ - Minimap.getEntityZ((Entity)e, partial);
        double offh = mainPlayer.field_70163_u - e.field_70163_u;
        GL11.glPushMatrix();
        GlStateManager.func_179137_b((double)(offx * zoom), (double)(offz * zoom), (double)0.0);
        if (!XaeroMinimap.getSettings().getLockNorth()) {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)0.0f);
        double brightness = Minimap.getEntityBrightness(offh);
        GL11.glColor3d((double)brightness, (double)brightness, (double)brightness);
        boolean flag1 = e != null && e.func_175148_a(EnumPlayerModelParts.CAPE) && (e.func_146103_bH().getName().equals("Dinnerbone") || e.func_146103_bH().getName().equals("Grumm"));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(e.func_110306_p());
        int l2 = 8 + (flag1 ? 8 : 0);
        int i3 = 8 * (flag1 ? -1 : 1);
        Gui.func_152125_a((int)0, (int)0, (float)8.0f, (float)((float)l2 + (float)i3), (int)8, (int)(-i3), (int)8, (int)8, (float)64.0f, (float)64.0f);
        if (e != null && e.func_175148_a(EnumPlayerModelParts.HAT)) {
            int j3 = 8 + (flag1 ? 8 : 0);
            int k3 = 8 * (flag1 ? -1 : 1);
            Gui.func_152125_a((int)0, (int)0, (float)40.0f, (float)((float)j3 + (float)k3), (int)8, (int)(-k3), (int)8, (int)8, (float)64.0f, (float)64.0f);
        }
        GL11.glPopMatrix();
    }

    public static void renderEntityDotToFBO(EntityPlayer p, Entity e, float angle, double playerX, double playerZ, float partial) {
        try {
            if (!Minimap.shouldRenderEntity(e)) {
                return;
            }
            double offx = Minimap.getEntityX(e, partial) - playerX;
            double offz = playerZ - Minimap.getEntityZ(e, partial);
            double offh = p.field_70163_u - e.field_70163_u;
            GL11.glPushMatrix();
            GlStateManager.func_179137_b((double)(offx * zoom), (double)(offz * zoom), (double)0.0);
            if (!XaeroMinimap.getSettings().getLockNorth()) {
                GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.0f);
            int color = Minimap.getEntityColour(p, e, offh);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
            GL11.glScalef((float)XaeroMinimap.getSettings().dotsScale, (float)XaeroMinimap.getSettings().dotsScale, (float)1.0f);
            Minimap.drawMyTexturedModalRect(-2.0f, -3.0f, XaeroMinimap.getSettings().getSmoothDots() ? 2 : 10, XaeroMinimap.getSettings().getSmoothDots() ? 89 : 78, 6.0f, 6.0f, 256.0f);
            GL11.glPopMatrix();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + 0) * f), (double)(((float)textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)(((float)textureX + width) * f), (double)(((float)textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_181673_a((double)(((float)textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GL11.glBindTexture((int)3553, (int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
    }

    public static boolean shouldRenderEntity(Entity e) {
        return !e.func_70093_af() && !e.func_82150_aj();
    }

    public static int getEntityColour(EntityPlayer p, Entity e, double offh) {
        int color = ModSettings.COLORS[XaeroMinimap.getSettings().otherColor];
        if (e instanceof EntityPlayer) {
            ScorePlayerTeam team;
            color = XaeroMinimap.getSettings().otherTeamColor != -1 && p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp() ? ModSettings.COLORS[XaeroMinimap.getSettings().otherTeamColor] : (XaeroMinimap.getSettings().playersColor != -1 ? ModSettings.COLORS[XaeroMinimap.getSettings().playersColor] : ((team = (ScorePlayerTeam)((EntityPlayer)e).func_96124_cp()) != null && team.func_96668_e() != null && team.func_96668_e().length() > 1 ? Minecraft.func_71410_x().field_71466_p.func_175064_b(team.func_96668_e().charAt(1)) : radarPlayers.hashCode()));
        } else if (e instanceof EntityMob || e instanceof IMob) {
            color = ModSettings.COLORS[XaeroMinimap.getSettings().hostileColor];
        } else if (e instanceof EntityLiving) {
            color = ModSettings.COLORS[XaeroMinimap.getSettings().mobsColor];
        } else if (e instanceof EntityItem) {
            color = ModSettings.COLORS[XaeroMinimap.getSettings().itemsColor];
        }
        int l = color >> 16 & 0xFF;
        int i1 = color >> 8 & 0xFF;
        int j1 = color & 0xFF;
        double brightness = Minimap.getEntityBrightness(offh);
        if (brightness < 1.0) {
            if ((l = (int)((double)l * brightness)) > 255) {
                l = 255;
            }
            if ((i1 = (int)((double)i1 * brightness)) > 255) {
                i1 = 255;
            }
            if ((j1 = (int)((double)j1 * brightness)) > 255) {
                j1 = 255;
            }
            color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        }
        return color;
    }

    public static double getEntityBrightness(double offh) {
        double level = (double)XaeroMinimap.getSettings().heightLimit - offh;
        if (level < 0.0) {
            level = 0.0;
        }
        double brightness = 1.0;
        if (level <= (double)(XaeroMinimap.getSettings().heightLimit / 2) && XaeroMinimap.getSettings().showEntityHeight) {
            brightness = level / (double)XaeroMinimap.getSettings().heightLimit;
        }
        return brightness;
    }

    static {
        toResetImage = true;
        zoom = 1.0;
        minimapSizes = new int[]{112, 168, 224, 336};
        bufferSizes = new int[]{128, 256, 256, 512};
        FBOMinimapSizes = new int[]{11, 17, 21, 31};
        FBOBufferSizes = new int[]{256, 512, 512, 512};
        triedFBO = false;
        loadedFBO = false;
        mapTexture = new DynamicTexture(InterfaceHandler.mapTextures);
    }

    public class MapLoader
    implements Runnable {
        @Override
        public void run() {
            int updateChunkX = 0;
            int updateChunkZ = 0;
            while (true) {
                long before = System.currentTimeMillis();
                boolean sleep = true;
                try {
                    if (XaeroMinimap.getSettings() == null || !XaeroMinimap.getSettings().getMinimap() || Minimap.mc.field_71439_g == null || Minimap.mc.field_71441_e == null) {
                        Thread.sleep(100L);
                    } else {
                        long before1 = System.currentTimeMillis();
                        if (!SupportMods.usingWorldMapChunks() || Minimap.this.getCaving() != -1) {
                            if (updateChunkX == 0 && updateChunkZ == 0) {
                                if (clearBlockColours) {
                                    clearBlockColours = false;
                                    if (!blockColours.isEmpty()) {
                                        blockColours.clear();
                                        textureColours.clear();
                                        System.out.println("Minimap block colour cache cleaned.");
                                    }
                                }
                                sunBrightness = Minimap.mc.field_71441_e.getSunBrightnessFactor(1.0f);
                                loadingSide = Minimap.getLoadSide();
                                updateRadius = Minimap.getUpdateRadius();
                                Minimap.this.loadingMapX = Minimap.this.getMapCoord(loadingSide, Minimap.mc.field_71439_g.field_70165_t);
                                Minimap.this.loadingMapZ = Minimap.this.getMapCoord(loadingSide, Minimap.mc.field_71439_g.field_70161_v);
                                Minimap.this.loadingCaving = Minimap.this.getCaving();
                                Minimap.this.loadingBlocks = new MinimapChunk[loadingSide][loadingSide];
                            }
                            sleep = this.updateChunk(updateChunkX, updateChunkZ);
                            if (updateChunkX == loadingSide - 1 && updateChunkZ == loadingSide - 1) {
                                Minimap.this.currentBlocks = Minimap.this.loadingBlocks;
                                loadedSide = loadingSide;
                                Minimap.this.loadedMapX = Minimap.this.loadingMapX;
                                Minimap.this.loadedMapZ = Minimap.this.loadingMapZ;
                                Minimap.this.loadedCaving = Minimap.this.loadingCaving;
                                frameUpdateNeeded = Minimap.usingFBO();
                            }
                        }
                        if ((updateChunkZ = (updateChunkZ + 1) % loadingSide) == 0) {
                            updateChunkX = (updateChunkX + 1) % loadingSide;
                            Minimap.this.lastBlockY = new int[16];
                            EntityPlayerSP p = Minimap.mc.field_71439_g;
                            ArrayList loadingPlayers = new ArrayList();
                            ArrayList loadingHostile = new ArrayList();
                            ArrayList loadingLiving = new ArrayList();
                            ArrayList loadingItems = new ArrayList();
                            ArrayList<Entity> loadingEntities = new ArrayList<Entity>();
                            for (int i = 0; i < p.field_70170_p.field_72996_f.size(); ++i) {
                                try {
                                    Entity e = (Entity)p.field_70170_p.field_72996_f.get(i);
                                    int type = 0;
                                    if (e instanceof EntityPlayer) {
                                        if (e != p && (!XaeroMinimap.getSettings().getShowPlayers() || !XaeroMinimap.settings.getShowOtherTeam() && p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp())) continue;
                                        type = 1;
                                    } else if (e instanceof EntityMob || e instanceof IMob) {
                                        if (!XaeroMinimap.getSettings().getShowHostile()) continue;
                                        type = 2;
                                    } else if (e instanceof EntityLiving) {
                                        if (!XaeroMinimap.getSettings().getShowMobs()) continue;
                                        type = 3;
                                    } else if (e instanceof EntityItem) {
                                        if (!XaeroMinimap.getSettings().getShowItems()) continue;
                                        type = 4;
                                    } else if (!XaeroMinimap.getSettings().getShowOther()) continue;
                                    double offx = e.field_70165_t - p.field_70165_t;
                                    double offy = e.field_70161_v - p.field_70161_v;
                                    double offh = p.field_70163_u - e.field_70163_u;
                                    double offheight2 = offh * offh;
                                    double offx2 = offx * offx;
                                    double offy2 = offy * offy;
                                    double maxDistance = 31250.0 / (Minimap.this.getZoom() * Minimap.this.getZoom());
                                    if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(XaeroMinimap.getSettings().heightLimit * XaeroMinimap.getSettings().heightLimit)) continue;
                                    ArrayList<Entity> typeList = loadingEntities;
                                    switch (type) {
                                        case 1: {
                                            typeList = loadingPlayers;
                                            break;
                                        }
                                        case 2: {
                                            typeList = loadingHostile;
                                            break;
                                        }
                                        case 3: {
                                            typeList = loadingLiving;
                                            break;
                                        }
                                        case 4: {
                                            typeList = loadingItems;
                                        }
                                    }
                                    typeList.add(e);
                                    if (XaeroMinimap.getSettings().entityAmount == 0 || typeList.size() < 100 * XaeroMinimap.getSettings().entityAmount) continue;
                                    break;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            loadedPlayers = loadingPlayers;
                            loadedHostile = loadingHostile;
                            loadedLiving = loadingLiving;
                            loadedItems = loadingItems;
                            loadedEntities = loadingEntities;
                        }
                        if (!frameIsUpdating && frameUpdateNeeded) {
                            frameUpdateNeeded = false;
                            frameIsUpdating = true;
                            bufferSizeToUpdate = Minimap.this.getFBOBufferSize();
                            Minimap.this.updateMapFrame(bufferSizeToUpdate, frameUpdatePartialTicks);
                            frameIsUpdating = false;
                        }
                        if (!updatePause && bufferSizeToUpdate != -1) {
                            ByteBuffer buffer = mapTexture.getBuffer(bufferSizeToUpdate);
                            buffer.put(Minimap.this.bytes);
                            buffer.flip();
                            bufferSizeToUpdate = -1;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    frameIsUpdating = false;
                }
                int passed = (int)(System.currentTimeMillis() - before);
                try {
                    if (sleep && passed <= 5) {
                        Thread.sleep(5 - passed);
                        continue;
                    }
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public boolean updateChunk(int x, int z) {
            Chunk bchunk;
            int chunkX = Minimap.this.loadingMapX + x;
            int chunkZ = Minimap.this.loadingMapZ + z;
            int halfSide = loadingSide / 2;
            int fromCenterX = x - halfSide;
            int fromCenterZ = z - halfSide;
            int xOld = chunkX - Minimap.this.loadedMapX;
            int zOld = chunkZ - Minimap.this.loadedMapZ;
            MinimapChunk current = null;
            if (Minimap.this.currentBlocks != null && xOld > -1 && xOld < Minimap.this.currentBlocks.length && zOld > -1 && zOld < Minimap.this.currentBlocks.length) {
                current = Minimap.this.currentBlocks[xOld][zOld];
            }
            if (!(bchunk = Minimap.mc.field_71439_g.field_70170_p.func_72964_e(chunkX, chunkZ)).func_177410_o() || (fromCenterX > updateRadius || fromCenterZ > updateRadius || fromCenterX < -updateRadius || fromCenterZ < -updateRadius) && current != null) {
                if (current != null) {
                    Minimap.this.loadingBlocks[x][z] = current;
                    for (int i = 0; i < 16; ++i) {
                        Minimap.this.lastBlockY[i] = current.lastHeights[i];
                    }
                } else {
                    Minimap.this.lastBlockY = new int[16];
                }
                return false;
            }
            int x1 = chunkX * 16;
            int z1 = chunkZ * 16;
            for (int blockX = x1; blockX < x1 + 16; ++blockX) {
                for (int blockZ = z1; blockZ < z1 + 16; ++blockZ) {
                    Minimap.this.loadBlockColor(blockX, blockZ, bchunk, x, z);
                    if ((blockZ & 0xF) != 15) continue;
                    Minimap.this.loadingBlocks[x][z].lastHeights[blockX & 0xF] = Minimap.this.lastBlockY[blockX & 0xF];
                }
            }
            return true;
        }
    }
}

