/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class LiquidUtil {
    public static List<Fluid> getAllFluids() {
        HashSet fluids = new HashSet(FluidRegistry.getRegisteredFluids().values());
        fluids.remove(null);
        ArrayList<Fluid> ret = new ArrayList<Fluid>(fluids);
        Collections.sort(ret, new Comparator<Fluid>(){

            @Override
            public int compare(Fluid a, Fluid b) {
                String nameA = a.getName();
                String nameB = b.getName();
                if (nameA == null) {
                    if (nameB == null) {
                        return 0;
                    }
                    return 1;
                }
                if (nameB == null) {
                    return -1;
                }
                return nameA.toLowerCase(Locale.ENGLISH).compareTo(nameB.toLowerCase(Locale.ENGLISH));
            }
        });
        return ret;
    }

    public static LiquidData getLiquid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Fluid liquid = null;
        boolean isSource = false;
        if (block instanceof IFluidBlock) {
            IFluidBlock fblock = (IFluidBlock)block;
            liquid = fblock.getFluid();
            isSource = fblock.canDrain(world, pos);
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            liquid = FluidRegistry.WATER;
            isSource = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            liquid = FluidRegistry.LAVA;
            boolean bl = isSource = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        }
        if (liquid != null) {
            return new LiquidData(liquid, isSource);
        }
        return null;
    }

    public static FluidStack drain(ItemStack stack, Fluid fluid, int maxAmount, MutableObject<ItemStack> output, FluidContainerOutputMode outputMode, boolean simulate) {
        if (output == null && outputMode != FluidContainerOutputMode.InPlace) {
            throw new IllegalArgumentException("no output specified for output mode " + (Object)((Object)outputMode));
        }
        if (output != null && outputMode == FluidContainerOutputMode.InPlace) {
            throw new IllegalArgumentException("output specified for output mode " + (Object)((Object)outputMode));
        }
        if (output != null) {
            output.setValue(null);
        }
        if (stack == null || stack.field_77994_a < 1) {
            return null;
        }
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (fs == null || fluid != null && fluid != fs.getFluid()) {
                return null;
            }
            if (maxAmount <= 0) {
                return new FluidStack(fs.getFluid(), 0);
            }
            if (fs.amount <= 0 || fs.amount > maxAmount) {
                return null;
            }
            if (!stack.func_77973_b().hasContainerItem(stack)) {
                if (!simulate) {
                    --stack.field_77994_a;
                }
            } else if (outputMode.outputEmptyFull || outputMode == FluidContainerOutputMode.InPlacePreferred && stack.field_77994_a > 1) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (container != null) {
                    output.setValue((Object)container.func_77946_l());
                }
                if (!simulate) {
                    --stack.field_77994_a;
                }
            } else {
                if (stack.field_77994_a > 1) {
                    return null;
                }
                if (!simulate) {
                    StackUtil.copyStack(stack, stack.func_77973_b().getContainerItem(stack));
                }
            }
            return fs;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)stack.func_77973_b();
            FluidStack fs = container.getFluid(stack);
            if (fs == null) {
                return null;
            }
            if (fluid != null && fs.getFluid() != fluid) {
                return null;
            }
            if (maxAmount <= 0) {
                return new FluidStack(fs.getFluid(), 0);
            }
            ItemStack singleStack = StackUtil.copyWithSize(stack, 1);
            fs = container.drain(singleStack, maxAmount, true);
            if (fs == null || fs.amount <= 0) {
                return null;
            }
            if (singleStack.field_77994_a <= 0) {
                if (!simulate) {
                    --stack.field_77994_a;
                }
            } else {
                boolean isEmpty;
                boolean bl = isEmpty = container.getFluid(singleStack) == null;
                if (isEmpty && outputMode.outputEmptyFull || outputMode == FluidContainerOutputMode.AnyToOutput || outputMode == FluidContainerOutputMode.InPlacePreferred && stack.field_77994_a > 1) {
                    output.setValue((Object)singleStack);
                    if (!simulate) {
                        --stack.field_77994_a;
                    }
                } else {
                    if (stack.field_77994_a > 1) {
                        return null;
                    }
                    if (!simulate) {
                        StackUtil.copyStack(singleStack, stack);
                    }
                }
            }
            return fs;
        }
        return null;
    }

    public static int fill(ItemStack stack, FluidStack fs, MutableObject<ItemStack> output, FluidContainerOutputMode outputMode, boolean simulate) {
        int ret;
        if (output == null && outputMode != FluidContainerOutputMode.InPlace) {
            throw new IllegalArgumentException("no output specified for output mode " + (Object)((Object)outputMode));
        }
        if (output != null && outputMode == FluidContainerOutputMode.InPlace) {
            throw new IllegalArgumentException("output specified for output mode " + (Object)((Object)outputMode));
        }
        if (output != null) {
            output.setValue(null);
        }
        if (stack == null || stack.field_77994_a < 1) {
            return 0;
        }
        if (fs == null || fs.amount <= 0) {
            return 0;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)fs, (ItemStack)stack);
            if (filled == null) {
                return 0;
            }
            if (outputMode.outputEmptyFull || outputMode == FluidContainerOutputMode.InPlacePreferred && stack.field_77994_a > 1) {
                output.setValue((Object)filled);
                if (!simulate) {
                    --stack.field_77994_a;
                }
            } else {
                if (stack.field_77994_a > 1) {
                    return 0;
                }
                if (!simulate) {
                    StackUtil.copyStack(filled, stack);
                }
            }
            ret = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
        } else if (stack.func_77973_b() instanceof IFluidContainerItem) {
            boolean isFull;
            ItemStack singleStack;
            IFluidContainerItem container = (IFluidContainerItem)stack.func_77973_b();
            int amount = container.fill(singleStack = StackUtil.copyWithSize(stack, 1), fs.copy(), true);
            if (amount <= 0) {
                return 0;
            }
            assert (singleStack.field_77994_a == 1);
            boolean bl = isFull = container.getFluid((ItemStack)singleStack).amount == container.getCapacity(singleStack);
            if (isFull && outputMode.outputEmptyFull || outputMode == FluidContainerOutputMode.AnyToOutput || outputMode == FluidContainerOutputMode.InPlacePreferred && stack.field_77994_a > 1) {
                output.setValue((Object)singleStack);
                if (!simulate) {
                    --stack.field_77994_a;
                }
            } else {
                if (stack.field_77994_a > 1) {
                    return 0;
                }
                if (!simulate) {
                    StackUtil.copyStack(singleStack, stack);
                }
            }
            ret = amount;
        } else {
            ret = 0;
        }
        return ret;
    }

    @Deprecated
    public static int fillContainerStack(ItemStack stack, EntityPlayer player, FluidStack fluid, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return 0;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.fill(stack, fluid, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        int amount = container.fill(testStack, fluid, true);
        if (amount <= 0) {
            return 0;
        }
        if (StackUtil.storeInventoryItem(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return amount;
        }
        return 0;
    }

    @Deprecated
    public static FluidStack drainContainerStack(ItemStack stack, EntityPlayer player, int maxAmount, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return null;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.drain(stack, maxAmount, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        FluidStack ret = container.drain(testStack, maxAmount, true);
        if (ret == null || ret.amount <= 0) {
            return null;
        }
        if (StackUtil.storeInventoryItem(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return ret;
        }
        return null;
    }

    public static List<AdjacentFluidHandler> getAdjacentHandlers(TileEntity source) {
        ArrayList<AdjacentFluidHandler> ret = new ArrayList<AdjacentFluidHandler>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = source.func_145831_w().func_175625_s(source.func_174877_v().func_177972_a(dir));
            if (!(te instanceof IFluidHandler)) continue;
            ret.add(new AdjacentFluidHandler((IFluidHandler)te, dir));
        }
        return ret;
    }

    public static AdjacentFluidHandler getAdjacentHandler(TileEntity source, EnumFacing dir) {
        TileEntity te = source.func_145831_w().func_175625_s(source.func_174877_v().func_177972_a(dir));
        if (!(te instanceof IFluidHandler)) {
            return null;
        }
        return new AdjacentFluidHandler((IFluidHandler)te, dir);
    }

    public static int distribute(TileEntity source, FluidStack stack, boolean simulate) {
        int transferred = 0;
        for (AdjacentFluidHandler handler : LiquidUtil.getAdjacentHandlers(source)) {
            int amount = LiquidUtil.distributeTo(handler.handler, stack, handler.dir, simulate);
            transferred += amount;
            stack.amount -= amount;
            if (stack.amount > 0) continue;
            break;
        }
        stack.amount += transferred;
        return transferred;
    }

    public static int distributeTo(IFluidHandler target, FluidStack stack, EnumFacing dirTo, boolean simulate) {
        int amount = target.fill(dirTo.func_176734_d(), stack, !simulate);
        return amount;
    }

    public static int distributeAll(IFluidHandler source, int amount) {
        if (!(source instanceof TileEntity)) {
            throw new IllegalArgumentException("source has to be a tile entity");
        }
        TileEntity srcTe = (TileEntity)source;
        int transferred = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            FluidStack stack;
            TileEntity te = srcTe.func_145831_w().func_175625_s(srcTe.func_174877_v().func_177972_a(dir));
            if (!(te instanceof IFluidHandler) || (stack = LiquidUtil.transfer(source, dir, (IFluidHandler)te, amount)) == null) continue;
            transferred += stack.amount;
            if ((amount -= stack.amount) <= 0) break;
        }
        return transferred;
    }

    public static FluidStack transfer(IFluidHandler source, EnumFacing dir, IFluidHandler target, int amount) {
        FluidStack ret;
        int cAmount;
        do {
            if ((ret = source.drain(dir, amount, false)) == null || ret.amount <= 0) {
                return null;
            }
            if (ret.amount > amount) {
                throw new IllegalStateException("The fluid handler " + source + " drained more than the requested amount.");
            }
            cAmount = target.fill(dir.func_176734_d(), ret, false);
            if (cAmount <= amount) continue;
            throw new IllegalStateException("The fluid handler " + target + " filled more than the requested amount.");
        } while ((amount = cAmount) != ret.amount && amount > 0);
        if (amount <= 0) {
            return null;
        }
        ret = source.drain(dir, amount, true);
        if (ret.amount != amount) {
            throw new IllegalStateException("The fluid handler " + source + " drained inconsistently. Expected " + amount + ", got " + ret.amount + ".");
        }
        amount = target.fill(dir.func_176734_d(), ret, true);
        if (amount != ret.amount) {
            throw new IllegalStateException("The fluid handler " + target + " filled inconsistently. Expected " + ret.amount + ", got " + amount + ".");
        }
        return ret;
    }

    public static boolean check(FluidStack fs) {
        return fs.getFluid() != null;
    }

    public static FluidStack drainBlock(World world, BlockPos pos, boolean simulate) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)block;
            if (liquid.canDrain(world, pos)) {
                return liquid.drain(world, pos, !simulate);
            }
        } else if (block instanceof BlockLiquid && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            FluidStack fluid = null;
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                fluid = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (fluid != null && !simulate) {
                world.func_175698_g(pos);
            }
            return fluid;
        }
        return null;
    }

    public static boolean drainBlockToContainer(World world, BlockPos pos, ItemStack stack, MutableObject<ItemStack> output, FluidContainerOutputMode outputMode, boolean simulate) {
        FluidStack fs = LiquidUtil.drainBlock(world, pos, true);
        if (fs == null || fs.amount <= 0) {
            return false;
        }
        int amount = LiquidUtil.fill(stack, fs, output, outputMode, true);
        if (amount != fs.amount) {
            return false;
        }
        if (!simulate) {
            fs = LiquidUtil.drainBlock(world, pos, false);
            if (fs == null || fs.amount <= 0) {
                return false;
            }
            LiquidUtil.fill(stack, fs, output, outputMode, false);
        }
        return true;
    }

    public static boolean drainBlockToContainer(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        MutableObject output = new MutableObject();
        if (!LiquidUtil.drainBlockToContainer(world, pos, stack, (MutableObject<ItemStack>)output, FluidContainerOutputMode.InPlacePreferred, true)) {
            return false;
        }
        if (output.getValue() != null && !StackUtil.storeInventoryItem((ItemStack)output.getValue(), player, false)) {
            return false;
        }
        LiquidUtil.drainBlockToContainer(world, pos, stack, (MutableObject<ItemStack>)output, FluidContainerOutputMode.InPlacePreferred, false);
        return true;
    }

    public static boolean fillBlock(FluidStack fs, World world, BlockPos pos, boolean simulate) {
        if (fs == null || fs.amount < 1000) {
            return false;
        }
        Fluid fluid = fs.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld() || fluid.getBlock() == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Object block = state.func_177230_c();
        if (!block.isAir((IBlockAccess)world, pos) && block.func_149688_o().func_76220_a()) {
            return false;
        }
        if (block == fluid.getBlock() && LiquidUtil.isFullFluidBlock(world, pos, block, state)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (world.field_73011_w.func_177500_n() && fluid.getBlock().func_149688_o() == Material.field_151586_h) {
            world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(world.field_72995_K || block.func_149688_o().func_76220_a() || block.func_149688_o().func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            if (!world.func_175656_a(pos, (block = fluid == FluidRegistry.WATER ? Blocks.field_150358_i : (fluid == FluidRegistry.LAVA ? Blocks.field_150356_k : fluid.getBlock())).func_176223_P())) {
                return false;
            }
        }
        fs.amount -= 1000;
        return true;
    }

    private static boolean isFullFluidBlock(World world, BlockPos pos, Block block, IBlockState state) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fBlock = (IFluidBlock)block;
            FluidStack drained = fBlock.drain(world, pos, false);
            return drained != null && drained.amount >= 1000;
        }
        if (state.func_177228_b().containsKey((Object)BlockLiquid.field_176367_b)) {
            return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
        }
        return false;
    }

    public static boolean fillBlockFromContainer(World world, BlockPos pos, ItemStack stack, MutableObject<ItemStack> output, FluidContainerOutputMode outputMode, boolean simulate) {
        FluidStack fs = LiquidUtil.drain(stack, null, 1000, output, outputMode, true);
        if (fs == null || fs.amount < 1000) {
            return false;
        }
        if (!LiquidUtil.fillBlock(fs, world, pos, simulate)) {
            return false;
        }
        if (!simulate) {
            LiquidUtil.drain(stack, null, 1000, output, outputMode, false);
        }
        return true;
    }

    public static boolean fillBlockFromContainer(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        MutableObject output = new MutableObject();
        if (!LiquidUtil.fillBlockFromContainer(world, pos, stack, (MutableObject<ItemStack>)output, FluidContainerOutputMode.InPlacePreferred, true)) {
            return false;
        }
        if (output.getValue() != null && !StackUtil.storeInventoryItem((ItemStack)output.getValue(), player, false)) {
            return false;
        }
        LiquidUtil.fillBlockFromContainer(world, pos, stack, (MutableObject<ItemStack>)output, FluidContainerOutputMode.InPlacePreferred, false);
        return true;
    }

    public static String toStringSafe(FluidStack fluidStack) {
        if (fluidStack.getFluid() == null) {
            return fluidStack.amount + "(mb)x(null)@(unknown)";
        }
        return fluidStack.toString();
    }

    public static class AdjacentFluidHandler {
        public final IFluidHandler handler;
        public final EnumFacing dir;

        private AdjacentFluidHandler(IFluidHandler handler, EnumFacing dir) {
            this.handler = handler;
            this.dir = dir;
        }
    }

    public static enum FluidContainerOutputMode {
        EmptyFullToOutput(true),
        AnyToOutput(true),
        InPlacePreferred(false),
        InPlace(false);

        private final boolean outputEmptyFull;

        private FluidContainerOutputMode(boolean outputEmptyFull) {
            this.outputEmptyFull = outputEmptyFull;
        }
    }

    public static class LiquidData {
        public final Fluid liquid;
        public final boolean isSource;

        LiquidData(Fluid liquid1, boolean isSource1) {
            this.liquid = liquid1;
            this.isSource = isSource1;
        }
    }
}

