/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.WorldData;
import ic2.core.block.TileEntityBlock;
import ic2.core.network.DataEncoder;
import ic2.core.network.GrowingBuffer;
import ic2.core.network.NetworkManager;
import ic2.core.network.TeUpdateDataClient;
import ic2.core.network.TeUpdateDataServer;
import ic2.core.ref.TeBlock;
import ic2.core.util.ReflectionUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

class TeUpdate {
    TeUpdate() {
    }

    public static void send(WorldData worldData, NetworkManager network) throws IOException {
        if (worldData.tesToUpdate.isEmpty()) {
            return;
        }
        IdentityHashMap<EntityPlayerMP, GrowingBuffer> buffers = new IdentityHashMap<EntityPlayerMP, GrowingBuffer>();
        Set<EntityPlayerMP> playersInRange = Collections.newSetFromMap(new IdentityHashMap());
        GrowingBuffer commonBuffer = new GrowingBuffer();
        for (Map.Entry<TileEntity, TeUpdateDataServer> entry : worldData.tesToUpdate.entrySet()) {
            TileEntity te = entry.getKey();
            TeUpdateDataServer updateData = entry.getValue();
            TeUpdate.getPlayersInRange(te, playersInRange);
            DataEncoder.encode(commonBuffer, te.func_174877_v(), false);
            commonBuffer.mark();
            commonBuffer.writeShort(0);
            for (String field : updateData.getGlobalFields()) {
                NetworkManager.writeFieldData(te, field, commonBuffer);
            }
            commonBuffer.flip();
            for (EntityPlayerMP player : playersInRange) {
                Collection<String> playerFields = updateData.getPlayerFields(player);
                int fieldCount = updateData.getGlobalFields().size() + playerFields.size();
                if (fieldCount == 0) continue;
                if (fieldCount > 65535) {
                    throw new RuntimeException("too many fields for " + te + ": " + fieldCount);
                }
                commonBuffer.reset();
                commonBuffer.writeShort(fieldCount);
                commonBuffer.rewind();
                GrowingBuffer playerBuffer = (GrowingBuffer)buffers.get(player);
                if (playerBuffer == null) {
                    playerBuffer = new GrowingBuffer(0);
                    buffers.put(player, playerBuffer);
                    playerBuffer.writeInt(player.field_70170_p.field_73011_w.func_177502_q());
                }
                commonBuffer.writeTo(playerBuffer);
                commonBuffer.rewind();
                for (String field : playerFields) {
                    NetworkManager.writeFieldData(te, field, playerBuffer);
                }
            }
            commonBuffer.clear();
        }
        worldData.tesToUpdate.clear();
        for (Map.Entry<Object, TeUpdateDataServer> entry : buffers.entrySet()) {
            EntityPlayerMP player = (EntityPlayerMP)entry.getKey();
            GrowingBuffer playerBuffer = (GrowingBuffer)((Object)entry.getValue());
            playerBuffer.flip();
            network.sendLargePacket(player, 0, playerBuffer);
        }
    }

    private static void getPlayersInRange(TileEntity te, Set<EntityPlayerMP> result) {
        World world = te.func_145831_w();
        if (world == null) {
            return;
        }
        for (EntityPlayer rawPlayer : world.field_73010_i) {
            if (!(rawPlayer instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)rawPlayer;
            int distance = Math.min(Math.abs(te.func_174877_v().func_177958_n() - (int)player.field_70165_t), Math.abs(te.func_174877_v().func_177952_p() - (int)player.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            result.add(player);
        }
    }

    static void receive(GrowingBuffer buffer) throws IOException {
        final int dimensionId = buffer.readInt();
        final TeUpdateDataClient updateData = new TeUpdateDataClient();
        while (buffer.hasAvailable()) {
            BlockPos pos = DataEncoder.decode(buffer, BlockPos.class);
            int fieldCount = buffer.readUnsignedShort();
            TeUpdateDataClient.TeData teData = updateData.addTe(pos, fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = buffer.readString();
                Object value = DataEncoder.decode(buffer);
                if (fieldName.equals("teBlk")) {
                    teData.teClass = TeBlock.get((String)value).getTeClass();
                    continue;
                }
                teData.addField(fieldName, value);
            }
            if (teData.teClass == null) continue;
            for (TeUpdateDataClient.FieldData fieldData : teData.getFields()) {
                fieldData.field = ReflectionUtil.getFieldRecursive(teData.teClass, fieldData.name);
            }
        }
        IC2.platform.requestTick(false, new Runnable(){

            @Override
            public void run() {
                World world = IC2.platform.getPlayerWorld();
                if (world == null || world.field_73011_w.func_177502_q() != dimensionId) {
                    return;
                }
                for (TeUpdateDataClient.TeData update : updateData.getTes()) {
                    TeUpdate.apply(update, world);
                }
            }
        });
    }

    private static void apply(TeUpdateDataClient.TeData update, World world) {
        IBlockState state = world.func_180495_p(update.pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return;
        }
        TileEntity te = world.func_175625_s(update.pos);
        if (update.teClass != null && (te == null || te.getClass() != update.teClass)) {
            te = TileEntityBlock.instantiate(update.teClass);
            world.func_175690_a(update.pos, te);
        } else if (te == null) {
            return;
        }
        for (TeUpdateDataClient.FieldData fieldUpdate : update.getFields()) {
            Object value = DataEncoder.getValue(fieldUpdate.value);
            if (fieldUpdate.field != null) {
                ReflectionUtil.setValue(te, fieldUpdate.field, value);
            } else {
                ReflectionUtil.setValueRecursive(te, fieldUpdate.name, value);
            }
            if (!(te instanceof INetworkUpdateListener)) continue;
            ((INetworkUpdateListener)te).onNetworkUpdate(fieldUpdate.name);
        }
    }
}

