/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.ref.ItemName;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemElectricToolHoe
extends ItemElectricTool {
    public ItemElectricToolHoe() {
        super(ItemName.electric_hoe, 50, ItemElectricTool.HarvestLevel.Iron, EnumSet.of(ItemElectricTool.ToolClass.Hoe));
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 16.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
        return false;
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(player, stack, world, pos))) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (side != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a()) && (block == Blocks.field_150391_bh || block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            block = Blocks.field_150458_ak;
            world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, block.field_149762_H.func_150498_e(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            if (IC2.platform.isSimulating()) {
                world.func_175656_a(pos, block.func_176223_P());
                ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
            }
            return true;
        }
        return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
    }
}

