/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IWorldTickCallback;
import ic2.core.item.tool.ContainerCropnalyzer;
import ic2.core.item.tool.GuiCropnalyzer;
import ic2.core.item.tool.HandHeldInventory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HandHeldCropnalyzer
extends HandHeldInventory
implements IWorldTickCallback {
    public HandHeldCropnalyzer(EntityPlayer player, ItemStack stack) {
        super(player, stack, 3);
        if (IC2.platform.isSimulating()) {
            IC2.tickHandler.requestContinuousWorldTick(player.field_70170_p, this);
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.containerStack.func_77978_p().func_74779_i("display");
        }
        return "Cropnalyzer";
    }

    public boolean func_145818_k_() {
        return StackUtil.getOrCreateNbtData(this.containerStack).func_74764_b("display");
    }

    public ContainerBase<HandHeldCropnalyzer> getGuiContainer(EntityPlayer player) {
        return new ContainerCropnalyzer(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiCropnalyzer(new ContainerCropnalyzer(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        super.onGuiClosed(player);
        if (IC2.platform.isSimulating()) {
            IC2.tickHandler.removeContinuousWorldTick(player.field_70170_p, this);
        }
    }

    @Override
    public void onTick(World world) {
        double get;
        double need;
        ItemStack battery = this.inventory[2];
        ItemStack input = this.inventory[0];
        ItemStack output = this.inventory[1];
        if (battery != null && battery.func_77973_b() instanceof IElectricItem && (need = ElectricItem.manager.charge(this.containerStack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true)) > 0.0 && (get = ElectricItem.manager.discharge(battery, need, Integer.MAX_VALUE, false, true, false)) > 0.0) {
            ElectricItem.manager.charge(this.containerStack, get, 3, true, false);
        }
        if (output == null && input != null && input.func_77973_b() instanceof ICropSeed) {
            int level = ((ICropSeed)input.func_77973_b()).getScannedFromStack(this.inventory[0]);
            if (level < 4) {
                double ned = HandHeldCropnalyzer.energyForLevel(level);
                double got = ElectricItem.manager.discharge(this.containerStack, ned, 2, true, false, false);
                if (!Util.isSimilar(got, ned)) {
                    return;
                }
                ((ICropSeed)input.func_77973_b()).incrementScannedFromStack(this.inventory[0]);
            }
            this.inventory[1] = input;
            this.inventory[0] = null;
        }
    }

    public static int energyForLevel(int i) {
        switch (i) {
            default: {
                return 10;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 900;
            }
            case 3: 
        }
        return 9000;
    }

    public CropCard crop() {
        return Crops.instance.getCropCard(this.inventory[1]);
    }

    public int getScannedLevel() {
        ItemStack output = this.inventory[1];
        if (output == null || !(output.func_77973_b() instanceof ICropSeed)) {
            return -1;
        }
        return ((ICropSeed)output.func_77973_b()).getScannedFromStack(output);
    }

    public String getSeedName() {
        return StatCollector.func_74838_a((String)this.crop().getDisplayName());
    }

    public String getSeedTier() {
        switch (this.crop().getProperties().getTier()) {
            default: {
                return "0";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
            case 11: {
                return "XI";
            }
            case 12: {
                return "XII";
            }
            case 13: {
                return "XIII";
            }
            case 14: {
                return "XIV";
            }
            case 15: {
                return "XV";
            }
            case 16: 
        }
        return "XVI";
    }

    public String getSeedDiscovered() {
        return this.crop().getDiscoveredBy();
    }

    public String getSeedDesc(int i) {
        return this.crop().desc(i);
    }

    public int getSeedGrowth() {
        return ((ICropSeed)this.inventory[1].func_77973_b()).getGrowthFromStack(this.inventory[1]);
    }

    public int getSeedGain() {
        return ((ICropSeed)this.inventory[1].func_77973_b()).getGainFromStack(this.inventory[1]);
    }

    public int getSeedResistence() {
        return ((ICropSeed)this.inventory[1].func_77973_b()).getResistanceFromStack(this.inventory[1]);
    }
}

