/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.crop;

import ic2.api.crops.Crops;
import ic2.core.IC2;
import ic2.core.crop.TileEntityCrop;
import ic2.core.ref.FluidName;
import ic2.core.util.Util;
import java.util.List;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class CropInternalInfo {
    private byte statGrowth;
    private byte statGain;
    private byte statResistance;
    private short storageNutrient;
    private short storageWater;
    private short storageWeedEX;
    private byte terrainAirQuality;
    private byte terrainHumidity;
    private byte terrainNutrients;
    private byte currentSize;
    private short growthPoints;
    private byte scanLevel;
    private boolean crossingBase;

    public CropInternalInfo() {
        this.resetTile();
    }

    public void readFromNbt(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("internalInfo")) {
            NBTTagCompound nbtTagInfo = nbtTagCompound.func_74775_l("internalInfo");
            this.setStatGrowth(nbtTagInfo.func_74771_c("statGrowth"));
            this.setStatGain(nbtTagInfo.func_74771_c("statGain"));
            this.setStatResistance(nbtTagInfo.func_74771_c("statResistance"));
            this.setStorageNutrient(nbtTagInfo.func_74765_d("storageNutrient"));
            this.setStorageWater(nbtTagInfo.func_74765_d("storageWater"));
            this.setStorageWeedEX(nbtTagInfo.func_74765_d("storageWeedEX"));
            this.setTerrainHumidity(nbtTagInfo.func_74771_c("terrainHumidity"));
            this.setTerrainNutrients(nbtTagInfo.func_74771_c("terrainNutrients"));
            this.setTerrainAirQuality(nbtTagInfo.func_74771_c("terrainAirQuality"));
            this.setCurrentSize(nbtTagInfo.func_74771_c("currentSize"));
            this.setGrowthPoints(nbtTagInfo.func_74765_d("growthPoints"));
            this.setScanLevel(nbtTagInfo.func_74771_c("scanLevel"));
            this.setCrossingBase(nbtTagInfo.func_74767_n("crossingBase"));
        } else {
            this.resetTile();
        }
    }

    public void writeToNbt(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbtTagInfo = new NBTTagCompound();
        nbtTagInfo.func_74774_a("statGrowth", this.statGrowth);
        nbtTagInfo.func_74774_a("statGain", this.statGain);
        nbtTagInfo.func_74774_a("statResistance", this.statResistance);
        nbtTagInfo.func_74777_a("storageNutrient", this.storageNutrient);
        nbtTagInfo.func_74777_a("storageWater", this.storageWater);
        nbtTagInfo.func_74777_a("storageWeedEX", this.storageWeedEX);
        nbtTagInfo.func_74774_a("terrainHumidity", this.terrainHumidity);
        nbtTagInfo.func_74774_a("terrainNutrients", this.terrainNutrients);
        nbtTagInfo.func_74774_a("terrainAirQuality", this.terrainAirQuality);
        nbtTagInfo.func_74774_a("currentSize", this.currentSize);
        nbtTagInfo.func_74777_a("growthPoints", this.growthPoints);
        nbtTagInfo.func_74774_a("scanLevel", this.scanLevel);
        nbtTagInfo.func_74757_a("crossingBase", this.crossingBase);
        nbtTagCompound.func_74782_a("internalInfo", (NBTBase)nbtTagInfo);
    }

    public void resetCrop() {
        this.setStatGrowth(0);
        this.setStatGain(0);
        this.setStatResistance(0);
        this.terrainAirQuality = (byte)-1;
        this.terrainHumidity = (byte)-1;
        this.terrainNutrients = (byte)-1;
        this.setCurrentSize(0);
        this.setGrowthPoints(0);
        this.setScanLevel(0);
        this.setCrossingBase(false);
    }

    public void resetTile() {
        this.setStatGrowth(0);
        this.setStatGain(0);
        this.setStatResistance(0);
        this.setStorageNutrient(0);
        this.setStorageWater(0);
        this.setStorageWeedEX(0);
        this.terrainAirQuality = (byte)-1;
        this.terrainHumidity = (byte)-1;
        this.terrainNutrients = (byte)-1;
        this.setCurrentSize(0);
        this.setGrowthPoints(0);
        this.setScanLevel(0);
        this.setCrossingBase(false);
    }

    public void mixStats(List<TileEntityCrop> cropTes) {
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        for (TileEntityCrop te : cropTes) {
            this.statGrowth = (byte)(this.statGrowth + te.getStatGrowth());
            this.statResistance = (byte)(this.statResistance + te.getStatResistance());
            this.statGain = (byte)(this.statGain + te.getStatGain());
        }
        int count = cropTes.size();
        this.statGrowth = (byte)(this.statGrowth / count);
        this.statResistance = (byte)(this.statResistance / count);
        this.statGain = (byte)(this.statGain / count);
        this.statGrowth = (byte)(this.statGrowth + (IC2.random.nextInt(1 + 2 * count) - count));
        this.statGain = (byte)(this.statGain + (IC2.random.nextInt(1 + 2 * count) - count));
        this.statResistance = (byte)(this.statResistance + (IC2.random.nextInt(1 + 2 * count) - count));
        this.setStatGrowth(Util.limit(this.statGrowth, 0, 31));
        this.setStatGain(Util.limit(this.statGain, 0, 31));
        this.setStatResistance(Util.limit(this.statResistance, 0, 31));
    }

    public int getStatGrowth() {
        return this.statGrowth;
    }

    public void setStatGrowth(int statGrowth) {
        this.statGrowth = (byte)statGrowth;
    }

    public void increaseStatGrowth() {
        this.statGrowth = (byte)(this.statGrowth + 1);
    }

    public void increaseStatGrowth(int value) {
        this.statGrowth = (byte)(this.statGrowth + value);
    }

    public void decreaseStatGrowth() {
        this.statGrowth = (byte)(this.statGrowth - 1);
    }

    public void decreaseStatGrowth(int value) {
        this.statGrowth = (byte)(this.statGrowth - value);
    }

    public int getStatGain() {
        return this.statGain;
    }

    public void setStatGain(int statGain) {
        this.statGain = (byte)statGain;
    }

    public void increaseStatGain() {
        this.statGain = (byte)(this.statGain + 1);
    }

    public void increaseStatGain(int value) {
        this.statGain = (byte)(this.statGain + value);
    }

    public void decreaseStatGain() {
        this.statGain = (byte)(this.statGain - 1);
    }

    public void decreaseStatGain(int value) {
        this.statGain = (byte)(this.statGain - value);
    }

    public int getStatResistance() {
        return this.statResistance;
    }

    public void setStatResistance(int statResistance) {
        this.statResistance = (byte)statResistance;
    }

    public void increaseStatResistance() {
        this.statResistance = (byte)(this.statResistance + 1);
    }

    public void increaseStatResistance(int value) {
        this.statResistance = (byte)(this.statResistance + value);
    }

    public void decreaseStatResistance() {
        this.statResistance = (byte)(this.statResistance - 1);
    }

    public void decreaseStatResistance(int value) {
        this.statResistance = (byte)(this.statResistance - value);
    }

    public int getStorageNutrient() {
        return this.storageNutrient;
    }

    public void setStorageNutrient(int storageNutrient) {
        this.storageNutrient = (short)storageNutrient;
    }

    public void increaseStorageNutrient() {
        this.storageNutrient = (short)(this.storageNutrient + 1);
    }

    public void increaseStorageNutrient(int value) {
        this.storageNutrient = (short)(this.storageNutrient + value);
    }

    public void decreaseStorageNutrient() {
        this.storageNutrient = (short)(this.storageNutrient - 1);
    }

    public void decreaseStorageNutrient(int value) {
        this.storageNutrient = (short)(this.storageNutrient - value);
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.storageNutrient >= 100) {
            return false;
        }
        this.storageNutrient = (short)(this.storageNutrient + (manual ? 100 : 90));
        return true;
    }

    public int getStorageWater() {
        return this.storageWater;
    }

    public void setStorageWater(int storageWater) {
        this.storageWater = (short)storageWater;
    }

    public void increaseStorageWater() {
        this.storageWater = (short)(this.storageWater + 1);
    }

    public void increaseStorageWater(int value) {
        this.storageWater = (short)(this.storageWater + value);
    }

    public void decreaseStorageWater() {
        this.storageWater = (short)(this.storageWater - 1);
    }

    public void decreaseStorageWater(int value) {
        this.storageWater = (short)(this.storageWater - value);
    }

    public boolean applyWater(FluidTank fluidTank) {
        if (this.storageWater >= 200) {
            return false;
        }
        int apply = 200 - this.storageWater;
        if (fluidTank.getFluid().getFluid() != FluidRegistry.WATER) {
            return false;
        }
        FluidStack drain = fluidTank.drain(apply, true);
        if (drain != null) {
            this.increaseStorageWater(drain.amount);
            return true;
        }
        return false;
    }

    public int getStorageWeedEX() {
        return this.storageWeedEX;
    }

    public void setStorageWeedEX(int storageWeedEX) {
        this.storageWeedEX = (short)storageWeedEX;
    }

    public void increaseStorageWeedEX() {
        this.storageWeedEX = (short)(this.storageWeedEX + 1);
    }

    public void increaseStorageWeedEX(int value) {
        this.storageWeedEX = (short)(this.storageWeedEX + value);
    }

    public void decreaseStorageWeedEX() {
        this.storageWeedEX = (short)(this.storageWeedEX - 1);
    }

    public void decreaseStorageWeedEX(int value) {
        this.storageWeedEX = (short)(this.storageWeedEX - value);
    }

    public boolean applyWeedEX(FluidTank fluidTank) {
        if (this.storageWeedEX >= 150) {
            return false;
        }
        int apply = 150 - this.storageWeedEX;
        if (fluidTank.getFluid().getFluid() != FluidName.weed_ex.getInstance()) {
            return false;
        }
        FluidStack drain = fluidTank.drain(apply, true);
        if (drain != null) {
            this.increaseStorageWeedEX(drain.amount);
            return true;
        }
        return false;
    }

    public int getTerrainHumidity() {
        return this.terrainHumidity;
    }

    public void setTerrainHumidity(int value) {
        this.terrainHumidity = (byte)value;
    }

    public void updateTerrainHumidity(World world, BlockPos pos) {
        int value = Crops.instance.getHumidityBiomeBonus(world.func_180494_b(pos));
        if ((Integer)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7) {
            value += 2;
        }
        if (this.getStorageWater() >= 5) {
            value += 2;
        }
        this.setTerrainHumidity(value += (this.getStorageWater() + 24) / 25);
    }

    public int getTerrainNutrients() {
        return this.terrainNutrients;
    }

    public void setTerrainNutrients(int value) {
        this.terrainNutrients = (byte)value;
    }

    public void updateTerrainNutrients(World world, BlockPos pos) {
        int value = Crops.instance.getNutrientBiomeBonus(world.func_180494_b(pos));
        for (int i = 1; i < 5 && world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == Blocks.field_150346_d; ++i) {
            ++value;
        }
        this.setTerrainNutrients(value += (this.storageNutrient + 19) / 20);
    }

    public int getTerrainAirQuality() {
        return this.terrainAirQuality;
    }

    public void setTerrainAirQuality(int value) {
        this.terrainAirQuality = (byte)value;
    }

    public void updateTerrainAirQuality(World world, BlockPos pos) {
        int value = 0;
        int height = (pos.func_177956_o() - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 1 && fresh > 0; ++x) {
            for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 1 && fresh > 0; ++z) {
                if (!world.func_175677_d(new BlockPos(x, pos.func_177956_o(), z), false) && !(world.func_175625_s(new BlockPos(x, pos.func_177956_o(), z)) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (world.func_175678_i(pos.func_177984_a())) {
            value += 2;
        }
        this.setTerrainAirQuality(value);
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(int currentSize) {
        this.currentSize = (byte)currentSize;
    }

    public void increaseCurrentSize() {
        this.currentSize = (byte)(this.currentSize + 1);
    }

    public void increaseCurrentSize(int value) {
        this.currentSize = (byte)(this.currentSize + value);
    }

    public void decreaseCurrentSize() {
        this.currentSize = (byte)(this.currentSize - 1);
    }

    public void decreaseCurrentSize(int value) {
        this.currentSize = (byte)(this.currentSize - value);
    }

    public int getGrowthPoints() {
        return this.growthPoints;
    }

    public void setGrowthPoints(int growthPoints) {
        this.growthPoints = (short)growthPoints;
    }

    public void increaseGrowthPoints() {
        this.growthPoints = (short)(this.growthPoints + 1);
    }

    public void increaseGrowthPoints(int value) {
        this.growthPoints = (short)(this.growthPoints + value);
    }

    public void decreaseGrowthPoints() {
        this.growthPoints = (short)(this.growthPoints - 1);
    }

    public void decreaseGrowthPoints(int value) {
        this.growthPoints = (short)(this.growthPoints - value);
    }

    public int getScanLevel() {
        return this.scanLevel;
    }

    public void setScanLevel(int scanLevel) {
        this.scanLevel = (byte)scanLevel;
    }

    public boolean isCrossingBase() {
        return this.crossingBase;
    }

    public void setCrossingBase(boolean crossingBase) {
        this.crossingBase = crossingBase;
    }
}

