/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.IWorldTickCallback;
import ic2.core.Ic2Player;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.Redstone;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityLuminator
extends TileEntityBlock {
    private static final int manualChargeCapacity = 10000;
    private static final Map<EnumFacing, List<AxisAlignedBB>> aabbMap = TileEntityLuminator.getAabbMap();
    private final Energy energy = this.addComponent(Energy.asBasicSink(this, 5.0));
    private final Redstone redstone = this.addComponent(new Redstone(this));
    private boolean invertRedstone;
    public static boolean ignoreBlockStay = false;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.invertRedstone = nbt.func_74767_n("invert");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("invert", this.invertRedstone);
    }

    @Override
    public void onLoaded() {
        this.energy.setDirections(Collections.singleton(this.getFacing().func_176734_d()), Collections.<EnumFacing>emptySet());
        super.onLoaded();
        IC2.tickHandler.requestSingleWorldTick(this.field_145850_b, new IWorldTickCallback(){

            @Override
            public void onTick(World world) {
                TileEntityLuminator.this.checkPlacement();
            }
        });
    }

    @Override
    protected EnumFacing getPlacementFacing(EntityLivingBase placer, EnumFacing facing) {
        return facing;
    }

    @Override
    protected void updateEntityServer() {
        boolean lit;
        super.updateEntityServer();
        boolean bl = lit = this.isLit() && this.energy.useEnergy(0.25);
        if (this.getActive() != lit) {
            this.setActive(lit);
            this.updateLight();
        }
    }

    private boolean isLit() {
        return this.redstone.hasRedstoneInput() != this.invertRedstone;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onActivated(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) return true;
        ItemStack stack = player.func_71045_bC();
        double amount = 10000.0 - this.energy.getEnergy();
        if (stack != null && amount > 0.0) {
            double d;
            amount = ElectricItem.manager.discharge(stack, amount, this.energy.getSinkTier(), true, true, false);
            if (d > 0.0) {
                this.energy.forceAddEnergy(amount);
                return true;
            }
        }
        this.invertRedstone = !this.invertRedstone;
        IC2.network.get(!this.field_145850_b.field_72995_K).updateTileEntityField(this, "invertRedstone");
        return true;
    }

    @Override
    protected void onNeighborChange(Block neighbor) {
        super.onNeighborChange(neighbor);
        this.checkPlacement();
    }

    private void checkPlacement() {
        if (!TileEntityLuminator.isValidPosition(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing().func_176734_d()), this.getFacing())) {
            this.getBlockType().func_180657_a(this.field_145850_b, Ic2Player.get(this.field_145850_b), this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this);
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public static boolean isValidPosition(World world, BlockPos pos, EnumFacing side) {
        if (world.field_72995_K || ignoreBlockStay) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isSideSolid((IBlockAccess)world, pos, side)) {
            return true;
        }
        IEnergyTile tile = EnergyNet.instance.getSubTile(world, pos);
        return tile instanceof IEnergyEmitter;
    }

    @Override
    protected List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return aabbMap.get(this.getFacing());
    }

    @Override
    public int getLightValue() {
        return this.getActive() ? 15 : 0;
    }

    @Override
    protected void onEntityCollision(Entity entity) {
        super.onEntityCollision(entity);
        if (this.getActive() && entity instanceof EntityMob) {
            boolean isUndead = entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD;
            entity.func_70015_d(isUndead ? 20 : 10);
        }
    }

    @Override
    protected int getComparatorInputOverride() {
        return this.energy.getComparatorValue();
    }

    @Override
    protected boolean setFacingWrench(EnumFacing facing, EntityPlayer player) {
        this.invertRedstone = !this.invertRedstone;
        return true;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer player) {
        return false;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("active")) {
            this.updateLight();
        }
    }

    private void updateLight() {
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
    }

    private static Map<EnumFacing, List<AxisAlignedBB>> getAabbMap() {
        EnumMap<EnumFacing, List<AxisAlignedBB>> ret = new EnumMap<EnumFacing, List<AxisAlignedBB>>(EnumFacing.class);
        double height = 0.0625;
        double remHeight = 0.9375;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int dx = side.func_82601_c();
            int dy = side.func_96559_d();
            int dz = side.func_82599_e();
            double xS = (double)((dx + 1) / 2) * 0.9375;
            double yS = (double)((dy + 1) / 2) * 0.9375;
            double zS = (double)((dz + 1) / 2) * 0.9375;
            double xE = 0.0625 + (double)((dx + 2) / 2) * 0.9375;
            double yE = 0.0625 + (double)((dy + 2) / 2) * 0.9375;
            double zE = 0.0625 + (double)((dz + 2) / 2) * 0.9375;
            ret.put(side.func_176734_d(), Arrays.asList(new AxisAlignedBB(xS, yS, zS, xE, yE, zE)));
        }
        return ret;
    }
}

