/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.reactor.tileentity;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotReactor;
import ic2.core.block.reactor.container.ContainerNuclearReactor;
import ic2.core.block.reactor.gui.GuiNuclearReactor;
import ic2.core.block.reactor.tileentity.TileEntityReactorAccessHatch;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorFluidPort;
import ic2.core.block.reactor.tileentity.TileEntityReactorRedstonePort;
import ic2.core.block.type.ResourceBlock;
import ic2.core.init.MainConfig;
import ic2.core.item.reactor.ItemReactorHeatStorage;
import ic2.core.item.type.NuclearResourceType;
import ic2.core.ref.BlockName;
import ic2.core.ref.FluidName;
import ic2.core.ref.ItemName;
import ic2.core.ref.TeBlock;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import ic2.core.util.WorldSearchUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.Level;

public class TileEntityNuclearReactorElectric
extends TileEntityInventory
implements IHasGui,
IReactor,
IEnergySource,
IMetaDelegate,
IFluidHandler {
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    private float lastOutput = 0.0f;
    public final FluidTank inputTank;
    public final FluidTank outputTank;
    private final List<IEnergyTile> subTiles = new ArrayList<IEnergyTile>();
    public final InvSlotReactor reactorSlot;
    public final InvSlotOutput coolantoutputSlot;
    public final InvSlotOutput hotcoolantoutputSlot;
    public final InvSlotConsumableLiquidByList coolantinputSlot;
    public final InvSlotConsumableLiquidByTank hotcoolinputSlot;
    public final Redstone redstone;
    public float output = 0.0f;
    public int updateTicker = IC2.random.nextInt(this.getTickRate());
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    private int EmitHeatbuffer = 0;
    public int EmitHeat = 0;
    private boolean fluidCooled = false;
    public boolean addedToEnergyNet = false;
    private static final float huOutputModifier = 2.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/FluidReactor/outputModifier");

    public TileEntityNuclearReactorElectric() {
        this.inputTank = new FluidTank(10000);
        this.outputTank = new FluidTank(10000);
        this.reactorSlot = new InvSlotReactor(this, "reactor", 54);
        this.coolantinputSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "coolantinputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.ANY, InvSlotConsumableLiquid.OpType.Drain, FluidName.coolant.getInstance());
        this.hotcoolinputSlot = new InvSlotConsumableLiquidByTank(this, "hotcoolinputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.ANY, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.outputTank);
        this.coolantoutputSlot = new InvSlotOutput(this, "coolantoutputSlot", 1);
        this.hotcoolantoutputSlot = new InvSlotOutput(this, "hotcoolantoutputSlot", 1);
        this.redstone = this.addComponent(new Redstone(this));
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K && !this.isFluidCooled()) {
            this.refreshChambers();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.createChamberRedstoneLinks();
        if (this.isFluidCooled()) {
            this.createCasingRedstoneLinks();
        }
    }

    @Override
    protected void onUnloaded() {
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public int gaugeHeatScaled(int i) {
        return i * this.heat / (this.maxHeat / 100 * 85);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
        this.output = nbt.func_74765_d("output");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound inputTankTag = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTag);
        nbt.func_74782_a("inputTank", (NBTBase)inputTankTag);
        NBTTagCompound outputTankTag = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTag);
        nbt.func_74782_a("outputTank", (NBTBase)outputTankTag);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74777_a("output", (short)this.getReactorEnergyOutput());
    }

    @Override
    protected void onNeighborChange(Block neighbor) {
        super.onNeighborChange(neighbor);
        if (this.addedToEnergyNet) {
            this.refreshChambers();
        }
    }

    @Override
    public void drawEnergy(double amount) {
    }

    public float sendEnergy(float send) {
        return 0.0f;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.getReactorEnergyOutput() * 5.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/nuclear");
    }

    @Override
    public int getSourceTier() {
        return 4;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.getOfferedEnergy();
    }

    @Override
    public List<IEnergyTile> getSubTiles() {
        return this.subTiles;
    }

    private void processfluidsSlots() {
        RecipeOutput outputoutputSlot;
        RecipeOutput outputinputSlot = this.processInputSlot(true);
        if (outputinputSlot != null) {
            this.processInputSlot(false);
            List<ItemStack> processResult = outputinputSlot.items;
            this.coolantoutputSlot.add(processResult);
        }
        if ((outputoutputSlot = this.processOutputSlot(true)) != null) {
            this.processOutputSlot(false);
            List<ItemStack> processResult = outputoutputSlot.items;
            this.hotcoolantoutputSlot.add(processResult);
        }
    }

    public void refreshChambers() {
        ArrayList<TileEntityBlock> newSubTiles = new ArrayList<TileEntityBlock>();
        newSubTiles.add(this);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (!(te instanceof TileEntityReactorChamberElectric) || te.func_145837_r()) continue;
            newSubTiles.add((TileEntityReactorChamberElectric)te);
        }
        if (!newSubTiles.equals(this.subTiles)) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.subTiles.clear();
            this.subTiles.addAll(newSubTiles);
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
        }
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (!this.field_145850_b.func_175697_a(this.field_174879_c, 8)) {
            this.output = 0.0f;
        } else {
            boolean toFluidCooled = this.isFluidReactor();
            if (this.fluidCooled != toFluidCooled) {
                if (toFluidCooled) {
                    this.enableFluidMode();
                } else {
                    this.disableFluidMode();
                }
                this.fluidCooled = toFluidCooled;
            }
            this.dropAllUnfittingStuff();
            this.output = 0.0f;
            this.maxHeat = 10000;
            this.hem = 1.0f;
            this.processChambers();
            if (this.fluidCooled) {
                this.processfluidsSlots();
                int huOtput = (int)(huOutputModifier * (float)this.EmitHeatbuffer);
                int outputroom = this.outputTank.getCapacity() - this.outputTank.getFluidAmount();
                if (outputroom > 0) {
                    FluidStack draincoolant = huOtput < outputroom ? this.inputTank.drain(huOtput, false) : this.inputTank.drain(outputroom, false);
                    if (draincoolant != null) {
                        this.EmitHeat = draincoolant.amount;
                        huOtput -= this.inputTank.drain((int)draincoolant.amount, (boolean)true).amount;
                        this.outputTank.fill(new FluidStack(FluidName.hot_coolant.getInstance(), draincoolant.amount), true);
                    } else {
                        this.EmitHeat = 0;
                    }
                } else {
                    this.EmitHeat = 0;
                }
                this.addHeat(huOtput / 2);
            }
            this.EmitHeatbuffer = 0;
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.heat >= 1000 || this.output > 0.0f);
            this.func_70296_d();
        }
        IC2.network.get(true).updateTileEntityField(this, "output");
    }

    @Override
    protected void updateEntityClient() {
        super.updateEntityClient();
        TileEntityNuclearReactorElectric.showHeatEffects(this.field_145850_b, this.field_174879_c, this.heat);
    }

    public static void showHeatEffects(World world, BlockPos pos, int heat) {
        Random rnd = world.field_73012_v;
        if (rnd.nextInt(8) != 0) {
            return;
        }
        int puffs = heat / 1000;
        if (puffs > 0) {
            int n;
            puffs = rnd.nextInt(puffs);
            for (n = 0; n < puffs; ++n) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rnd.nextFloat()), (double)((float)pos.func_177956_o() + 0.95f), (double)((float)pos.func_177952_p() + rnd.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            puffs -= rnd.nextInt(4) + 3;
            for (n = 0; n < puffs; ++n) {
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + rnd.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + rnd.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void dropAllUnfittingStuff() {
        ItemStack stack;
        int i;
        for (i = 0; i < this.reactorSlot.size(); ++i) {
            stack = this.reactorSlot.get(i);
            if (stack == null || this.isUsefulItem(stack, false)) continue;
            this.reactorSlot.put(i, null);
            this.eject(stack);
        }
        for (i = this.reactorSlot.size(); i < this.reactorSlot.rawSize(); ++i) {
            stack = this.reactorSlot.get(i);
            this.reactorSlot.put(i, null);
            this.eject(stack);
        }
    }

    public boolean isUsefulItem(ItemStack stack, boolean forInsertion) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (forInsertion && this.fluidCooled && item.getClass() == ItemReactorHeatStorage.class && ((ItemReactorHeatStorage)item).getCustomDamage(stack) > 0) {
            return false;
        }
        if (item instanceof IReactorComponent) {
            return true;
        }
        return item == ItemName.tritium_fuel_rod.getInstance() || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_uranium)) || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_dual_uranium)) || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_quad_uranium)) || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_mox)) || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_dual_mox)) || StackUtil.checkItemEquality(stack, ItemName.nuclear.getItemStack(NuclearResourceType.depleted_quad_mox));
    }

    public void eject(ItemStack drop) {
        if (!IC2.platform.isSimulating() || drop == null) {
            return;
        }
        StackUtil.dropAsEntity(this.field_145850_b, this.field_174879_c, drop);
    }

    public boolean calculateHeatEffects() {
        Material mat;
        Block block;
        BlockPos coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || ConfigUtil.getFloat(MainConfig.get(), "protection/reactorExplosionPowerLimit") <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.field_145850_b.field_73012_v.nextFloat() <= 0.2f * this.hem) {
            coord = this.getRandCoord(2);
            block = this.field_145850_b.func_180495_p(coord).func_177230_c();
            if (block.isAir((IBlockAccess)this.field_145850_b, coord)) {
                this.field_145850_b.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
            } else if (block.func_176195_g(this.field_145850_b, coord) >= 0.0f && this.field_145850_b.func_175625_s(coord) == null) {
                Material mat2 = block.func_149688_o();
                if (mat2 == Material.field_151576_e || mat2 == Material.field_151573_f || mat2 == Material.field_151587_i || mat2 == Material.field_151578_c || mat2 == Material.field_151571_B) {
                    this.field_145850_b.func_175656_a(coord, Blocks.field_150356_k.func_176223_P());
                } else {
                    this.field_145850_b.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                Entity ent = (Entity)list1.get(l);
                ent.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)this.field_145850_b.field_73012_v.nextInt(4) * this.hem)));
            }
        }
        if (power >= 0.5f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && (block = this.field_145850_b.func_180495_p(coord = this.getRandCoord(2)).func_177230_c()).func_149688_o() == Material.field_151586_h) {
            this.field_145850_b.func_175698_g(coord);
        }
        if (power >= 0.4f && this.field_145850_b.field_73012_v.nextFloat() <= this.hem && this.field_145850_b.func_175625_s(coord = this.getRandCoord(2)) == null && ((mat = this.field_145850_b.func_180495_p(coord).func_177230_c().func_149688_o()) == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151580_n)) {
            this.field_145850_b.func_175656_a(coord, Blocks.field_150480_ab.func_176223_P());
        }
        return false;
    }

    public BlockPos getRandCoord(int radius) {
        BlockPos ret;
        if (radius <= 0) {
            return null;
        }
        while ((ret = this.field_174879_c.func_177982_a(this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_145850_b.field_73012_v.nextInt(2 * radius + 1) - radius)).equals((Object)this.field_174879_c)) {
        }
        return ret;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < size; ++x) {
                    ItemStack stack = this.reactorSlot.get(x, y);
                    if (stack == null || !(stack.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)stack.func_77973_b();
                    comp.processChamber(stack, this, x, y, pass == 0);
                }
            }
        }
    }

    @Override
    public boolean produceEnergy() {
        return this.redstone.hasRedstoneInput() && ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/generator") > 0.0f;
    }

    public int getReactorSize() {
        if (this.field_145850_b == null) {
            return 9;
        }
        int cols = 3;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (!(target instanceof TileEntityReactorChamberElectric)) continue;
            ++cols;
        }
        return cols;
    }

    private boolean isFullSize() {
        return this.getReactorSize() == 9;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (StackUtil.checkItemEquality(player.func_71045_bC(), BlockName.te.getItemStack(TeBlock.reactor_chamber))) {
            return false;
        }
        return super.onActivated(player, side, hitX, hitY, hitZ);
    }

    public ContainerBase<TileEntityNuclearReactorElectric> getGuiContainer(EntityPlayer player) {
        return new ContainerNuclearReactor(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiNuclearReactor(new ContainerNuclearReactor(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0.0f) {
                if (this.lastOutput <= 0.0f) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40.0f) {
                    if (this.lastOutput <= 0.0f || this.lastOutput >= 40.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80.0f) {
                    if (this.lastOutput < 40.0f || this.lastOutput >= 80.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80.0f && this.lastOutput < 80.0f) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0.0f) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat1) {
        this.heat = heat1;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return null;
        }
        return this.reactorSlot.get(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return;
        }
        this.reactorSlot.put(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int i = 0; i < this.reactorSlot.size(); ++i) {
            ItemStack stack = this.reactorSlot.get(i);
            if (stack != null && stack.func_77973_b() instanceof IReactorComponent) {
                float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(stack, this);
                if (f > 0.0f && f < 1.0f) {
                    boomMod *= f;
                } else {
                    boomPower += f;
                }
            }
            this.reactorSlot.put(i, null);
        }
        IC2.log.log(LogCategory.PlayerActivity, Level.INFO, "Nuclear Reactor at %s melted (raw explosion power %f)", Util.formatPosition(this), Float.valueOf(boomPower *= this.hem * boomMod));
        boomPower = Math.min(boomPower, ConfigUtil.getFloat(MainConfig.get(), "protection/reactorExplosionPowerLimit"));
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (!(target instanceof TileEntityReactorChamberElectric)) continue;
            this.field_145850_b.func_175698_g(target.func_174877_v());
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, this.field_174879_c, boomPower, 0.01f, ExplosionIC2.Type.Nuclear);
        explosion.doExplosion();
    }

    @Override
    public void addEmitHeat(int heat) {
        this.EmitHeatbuffer += heat;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        return this.output += energy;
    }

    private RecipeOutput processInputSlot(boolean simulate) {
        MutableObject output;
        if (!this.coolantinputSlot.isEmpty() && this.coolantinputSlot.transferToTank((IFluidTank)this.inputTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.coolantoutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    private RecipeOutput processOutputSlot(boolean simulate) {
        MutableObject output;
        if (!this.hotcoolinputSlot.isEmpty() && this.hotcoolinputSlot.transferFromTank((IFluidTank)this.outputTank, (MutableObject<ItemStack>)(output = new MutableObject()), simulate) && (output.getValue() == null || this.hotcoolantoutputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, (ItemStack)output.getValue());
        }
        return null;
    }

    @Override
    public boolean isFluidCooled() {
        return this.fluidCooled;
    }

    private void createChamberRedstoneLinks() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos cPos = this.field_174879_c.func_177972_a(facing);
            TileEntity te = this.field_145850_b.func_175625_s(cPos);
            if (!(te instanceof TileEntityReactorChamberElectric)) continue;
            TileEntityReactorChamberElectric chamber = (TileEntityReactorChamberElectric)te;
            chamber.redstone.linkTo(this.redstone);
        }
    }

    private void createCasingRedstoneLinks() {
        WorldSearchUtil.findTileEntities(this.field_145850_b, this.field_174879_c, 2, new WorldSearchUtil.ITileEntityResultHandler(){

            @Override
            public boolean onMatch(TileEntity te) {
                if (te instanceof TileEntityReactorRedstonePort) {
                    ((TileEntityReactorRedstonePort)te).redstone.linkTo(TileEntityNuclearReactorElectric.this.redstone);
                }
                return false;
            }
        });
    }

    private void removeCasingRedstoneLinks() {
        for (Redstone rs : this.redstone.getLinkedOrigins()) {
            if (!(rs.getParent() instanceof TileEntityReactorRedstonePort)) continue;
            rs.unlinkOutbound();
        }
    }

    private void enableFluidMode() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        this.createCasingRedstoneLinks();
    }

    private void disableFluidMode() {
        if (!this.addedToEnergyNet) {
            this.refreshChambers();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.removeCasingRedstoneLinks();
    }

    private boolean isFluidReactor() {
        if (!this.isFullSize()) {
            return false;
        }
        if (!this.hasFluidChamber()) {
            return false;
        }
        int range = 2;
        final MutableBoolean foundConflict = new MutableBoolean();
        WorldSearchUtil.findTileEntities(this.field_145850_b, this.field_174879_c, 4, new WorldSearchUtil.ITileEntityResultHandler(){

            @Override
            public boolean onMatch(TileEntity te) {
                if (!(te instanceof TileEntityNuclearReactorElectric)) {
                    return false;
                }
                if (te == TileEntityNuclearReactorElectric.this) {
                    return false;
                }
                TileEntityNuclearReactorElectric reactor = (TileEntityNuclearReactorElectric)te;
                if (reactor.isFullSize() && reactor.hasFluidChamber()) {
                    foundConflict.setTrue();
                    return true;
                }
                return false;
            }
        });
        return foundConflict.getValue() == false;
    }

    private boolean hasFluidChamber() {
        int y;
        int x;
        int i;
        int range = 2;
        ChunkCache cache = new ChunkCache(this.field_145850_b, this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2), 0);
        BlockPos.MutableBlockPos cPos = new BlockPos.MutableBlockPos();
        for (i = 0; i < 2; ++i) {
            int y2 = this.field_174879_c.func_177956_o() + 2 * (i * 2 - 1);
            for (int z = this.field_174879_c.func_177952_p() - 2; z <= this.field_174879_c.func_177952_p() + 2; ++z) {
                for (x = this.field_174879_c.func_177958_n() - 2; x <= this.field_174879_c.func_177958_n() + 2; ++x) {
                    cPos.func_181079_c(x, y2, z);
                    if (TileEntityNuclearReactorElectric.isFluidChamberBlock((IBlockAccess)cache, (BlockPos)cPos)) continue;
                    return false;
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            int z = this.field_174879_c.func_177952_p() + 2 * (i * 2 - 1);
            for (y = this.field_174879_c.func_177956_o() - 2 + 1; y <= this.field_174879_c.func_177956_o() + 2 - 1; ++y) {
                for (x = this.field_174879_c.func_177958_n() - 2; x <= this.field_174879_c.func_177958_n() + 2; ++x) {
                    cPos.func_181079_c(x, y, z);
                    if (TileEntityNuclearReactorElectric.isFluidChamberBlock((IBlockAccess)cache, (BlockPos)cPos)) continue;
                    return false;
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            int x2 = this.field_174879_c.func_177958_n() + 2 * (i * 2 - 1);
            for (y = this.field_174879_c.func_177956_o() - 2 + 1; y <= this.field_174879_c.func_177956_o() + 2 - 1; ++y) {
                for (int z = this.field_174879_c.func_177952_p() - 2 + 1; z <= this.field_174879_c.func_177952_p() + 2 - 1; ++z) {
                    cPos.func_181079_c(x2, y, z);
                    if (TileEntityNuclearReactorElectric.isFluidChamberBlock((IBlockAccess)cache, (BlockPos)cPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isFluidChamberBlock(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state == BlockName.resource.getBlockState(ResourceBlock.reactor_vessel)) {
            return true;
        }
        if (state.func_177230_c() != BlockName.te.getInstance()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te instanceof TileEntityReactorAccessHatch || te instanceof TileEntityReactorFluidPort || te instanceof TileEntityReactorRedstonePort;
    }

    public int gaugeLiquidScaled(int i, int tank) {
        switch (tank) {
            case 0: {
                if (this.inputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.inputTank.getFluidAmount() * i / this.inputTank.getCapacity();
            }
            case 1: {
                if (this.outputTank.getFluidAmount() <= 0) {
                    return 0;
                }
                return this.outputTank.getFluidAmount() * i / this.outputTank.getCapacity();
            }
        }
        return 0;
    }

    public FluidTank getinputtank() {
        return this.inputTank;
    }

    public FluidTank getoutputtank() {
        return this.outputTank;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.inputTank.getInfo(), this.outputTank.getInfo()};
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (!this.fluidCooled) {
            return false;
        }
        return fluid == FluidName.coolant.getInstance();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (!this.fluidCooled) {
            return false;
        }
        FluidStack fluidStack = this.outputTank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.isFluidEqual(new FluidStack(fluid, 1));
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.outputTank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.outputTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }
}

