/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine;

import ic2.core.block.BlockMultiID;
import ic2.core.block.state.IIdProvider;
import ic2.core.ref.BlockName;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMiningPipe
extends BlockMultiID<MiningPipeType> {
    private static final AxisAlignedBB pipeAabb = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB blockAabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public static BlockMiningPipe create() {
        return BlockMultiID.create(BlockMiningPipe.class, MiningPipeType.class, new Object[0]);
    }

    public BlockMiningPipe() {
        super(BlockName.mining_pipe, Material.field_151573_f);
        this.func_149711_c(6.0f);
        this.func_149752_b(10.0f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        MiningPipeType type = (MiningPipeType)this.getType(world, pos);
        if (type == null) {
            return true;
        }
        return type != MiningPipeType.pipe;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        MiningPipeType type = (MiningPipeType)this.getType(world, pos);
        if (type == null) {
            return;
        }
        AxisAlignedBB aabb = this.getAabb(type);
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return this.func_180640_a(world, pos, world.func_180495_p(pos));
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        MiningPipeType type = (MiningPipeType)this.getType(state);
        if (type == null) {
            return null;
        }
        AxisAlignedBB aabb = this.getAabb(type);
        return aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    private AxisAlignedBB getAabb(MiningPipeType type) {
        switch (type) {
            case pipe: {
                return pipeAabb;
            }
        }
        return blockAabb;
    }

    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        MiningPipeType type = (MiningPipeType)this.getType(world, pos);
        if (type == null) {
            return true;
        }
        switch (type) {
            case pipe: {
                return false;
            }
            case tip: {
                return true;
            }
        }
        return true;
    }

    @Override
    public ItemStack getItemStack(IBlockState state) {
        MiningPipeType type = (MiningPipeType)this.getType(state);
        if (type == MiningPipeType.tip) {
            return this.getItemStack(MiningPipeType.pipe);
        }
        return super.getItemStack(state);
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List<ItemStack> itemList) {
        for (MiningPipeType type : this.typeProperty.getAllowedValues()) {
            if (type == MiningPipeType.tip) continue;
            itemList.add(this.getItemStack(type));
        }
    }

    public static enum MiningPipeType implements IIdProvider
    {
        pipe,
        tip;


        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public int getId() {
            return this.ordinal();
        }
    }
}

