/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.kineticgenerator.tileentity;

import ic2.api.energy.tile.IKineticSource;
import ic2.api.item.IKineticRotor;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableClass;
import ic2.core.block.invslot.InvSlotConsumableKineticRotor;
import ic2.core.block.kineticgenerator.container.ContainerWaterKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiWaterKineticGenerator;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWaterKineticGenerator
extends TileEntityInventory
implements IKineticSource,
IHasGui {
    private boolean firsttick = true;
    private int updateTicker = IC2.random.nextInt(this.getTickRate());
    public InvSlotConsumableClass rotorSlot = new InvSlotConsumableKineticRotor((TileEntityInventory)this, "rotorslot", InvSlot.Access.IO, 1, InvSlot.InvSide.ANY, IKineticRotor.GearboxType.WATER);
    public short type = 0;
    private boolean rightFacing;
    private int distanceToNormalBiome;
    private int crossSection;
    private int obstructedCrossSection;
    private int waterFlow;
    private final double efficiencyRollOffExponent = 2.0;
    private static final float outputModifier = 0.2f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/kineticgenerator/water");
    private float angle = 0.0f;
    private float rotationSpeed;
    private static final float rotationModifier = 0.1f;
    private long lastcheck;

    private int getTickRate() {
        return 20;
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        if (this.firsttick) {
            this.updateSeaInfo();
            this.firsttick = false;
        }
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (this.type == 0) {
            BiomeGenBase biome = this.field_145850_b.func_180494_b(this.field_174879_c);
            this.type = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) ? (short)1 : (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) ? (short)2 : (short)-1);
        }
        if (this.type == -1) {
            return;
        }
        boolean needsInvUpdate = false;
        if (!this.rotorSlot.isEmpty()) {
            if (this.checkSpace(1, true) == 0) {
                if (!this.getActive()) {
                    this.setActive(true);
                    needsInvUpdate = true;
                }
            } else if (this.getActive()) {
                this.setActive(false);
                needsInvUpdate = true;
            }
        } else if (this.getActive()) {
            this.setActive(false);
            needsInvUpdate = true;
        }
        if (this.getActive()) {
            this.crossSection = this.getRotorDiameter() / 2 * 2 * 2 + 1;
            this.crossSection *= this.crossSection;
            this.obstructedCrossSection = this.checkSpace(this.getRotorDiameter() * 3, false);
            if (this.obstructedCrossSection > 0 && this.obstructedCrossSection <= (this.getRotorDiameter() + 1) / 2) {
                this.obstructedCrossSection = 0;
            }
            int rotordamage = 0;
            if (this.obstructedCrossSection < 0) {
                boolean update = this.rotationSpeed != 0.0f;
                this.rotationSpeed = 0.0f;
                this.waterFlow = 0;
                if (update) {
                    IC2.network.get(true).updateTileEntityField(this, "rotationSpeed");
                }
            } else if (this.type == 1) {
                float diff = (float)Math.sin((double)this.field_145850_b.func_72820_D() * Math.PI / 6000.0);
                diff *= Math.abs(diff);
                this.rotationSpeed = (float)((double)(diff * (float)this.distanceToNormalBiome / 100.0f) * (1.0 - Math.pow((double)this.obstructedCrossSection / (double)this.crossSection, 2.0)));
                this.waterFlow = (int)(this.rotationSpeed * 3000.0f);
                if (this.rightFacing) {
                    this.rotationSpeed *= -1.0f;
                }
                IC2.network.get(true).updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * this.getefficiency());
                rotordamage = 2;
            } else if (this.type == 2) {
                this.rotationSpeed = Math.max(Math.min(this.distanceToNormalBiome, 20), 50) / 50;
                this.waterFlow = (int)(this.rotationSpeed * 1000.0f);
                if (this.getFacing() == EnumFacing.EAST || this.getFacing() == EnumFacing.NORTH) {
                    this.rotationSpeed *= -1.0f;
                }
                IC2.network.get(true).updateTileEntityField(this, "rotationSpeed");
                this.waterFlow = (int)((float)this.waterFlow * (this.getefficiency() * (1.0f - 0.3f * this.field_145850_b.field_73012_v.nextFloat() - 0.1f * ((float)this.obstructedCrossSection / (float)this.crossSection))));
                rotordamage = 1;
            }
            this.rotorSlot.damage(rotordamage, false);
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("rotationSpeed");
        ret.add("rotorSlot");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public int getRotorDiameter() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticRotor) {
            if (this.type == 1) {
                return ((IKineticRotor)stack.func_77973_b()).getDiameter(stack);
            }
            return (((IKineticRotor)stack.func_77973_b()).getDiameter(stack) + 1) * 2 / 3;
        }
        return 0;
    }

    public int checkSpace(int length, boolean onlyrotor) {
        int box = this.getRotorDiameter() / 2;
        int lentemp = 0;
        if (onlyrotor) {
            length = 1;
            lentemp = length + 1;
        } else {
            box *= 2;
        }
        EnumFacing fwdDir = this.getFacing();
        EnumFacing rightDir = fwdDir.func_176732_a(EnumFacing.DOWN.func_176740_k());
        int ret = 0;
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        for (int up = -box; up <= box; ++up) {
            int y = yCoord + up;
            for (int right = -box; right <= box; ++right) {
                boolean occupied = false;
                for (int fwd = lentemp - length; fwd <= length; ++fwd) {
                    int z;
                    int x = xCoord + fwd * fwdDir.func_82601_c() + right * rightDir.func_82601_c();
                    BlockPos pos = new BlockPos(x, y, z = zCoord + fwd * fwdDir.func_82599_e() + right * rightDir.func_82599_e());
                    Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
                    if (block == Blocks.field_150355_j) continue;
                    occupied = true;
                    if (up == 0 && right == 0 && fwd == 0 || !(this.field_145850_b.func_175625_s(pos) instanceof TileEntityWaterKineticGenerator) || onlyrotor) continue;
                    return -1;
                }
                if (!occupied) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new ContainerWaterKineticGenerator(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiWaterKineticGenerator((ContainerWaterKineticGenerator)this.getGuiContainer(player));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public void setFacing(EnumFacing side) {
        super.setFacing(side);
        this.updateSeaInfo();
    }

    public void updateSeaInfo() {
        EnumFacing facing = this.getFacing();
        for (int i = 1; i < 200; ++i) {
            BiomeGenBase biometmp = this.field_145850_b.func_180494_b(this.field_174879_c.func_177967_a(facing, i));
            if (!this.isValidBiome(biometmp)) {
                this.distanceToNormalBiome = i;
                this.rightFacing = true;
                return;
            }
            biometmp = this.field_145850_b.func_180494_b(this.field_174879_c.func_177967_a(facing, i));
            if (this.isValidBiome(biometmp)) continue;
            this.distanceToNormalBiome = i;
            this.rightFacing = false;
            return;
        }
        this.distanceToNormalBiome = 200;
        this.rightFacing = true;
    }

    public boolean isValidBiome(BiomeGenBase biome) {
        return biome == BiomeGenBase.field_150575_M || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76781_i;
    }

    public ResourceLocation getRotorRenderTexture() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticRotor) {
            return ((IKineticRotor)stack.func_77973_b()).getRotorRenderTexture(stack);
        }
        return new ResourceLocation(IC2.textureDomain, "textures/items/rotors/wood_rotor_model.png");
    }

    public float getAngle() {
        if (this.rotationSpeed != 0.0f) {
            this.angle += (float)(System.currentTimeMillis() - this.lastcheck) * this.rotationSpeed * 0.1f;
            this.angle %= 360.0f;
            this.lastcheck = System.currentTimeMillis();
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public int maxrequestkineticenergyTick(EnumFacing directionFrom) {
        return this.getKuOutput();
    }

    @Override
    public int requestkineticenergy(EnumFacing directionFrom, int requestkineticenergy) {
        if (directionFrom.func_176734_d() == this.getFacing()) {
            return Math.min(requestkineticenergy, this.getKuOutput());
        }
        return 0;
    }

    public int getKuOutput() {
        if (this.getActive()) {
            return (int)Math.abs((float)this.waterFlow * outputModifier);
        }
        return 0;
    }

    public float getefficiency() {
        ItemStack stack = this.rotorSlot.get();
        if (stack != null && stack.func_77973_b() instanceof IKineticRotor) {
            return ((IKineticRotor)stack.func_77973_b()).getEfficiency(stack);
        }
        return 0.0f;
    }

    public String getRotorhealth() {
        if (!this.rotorSlot.isEmpty()) {
            return StatCollector.func_74837_a((String)"ic2.WaterKineticGenerator.gui.rotorhealth", (Object[])new Object[]{(int)(100.0f - (float)this.rotorSlot.get().func_77952_i() / (float)this.rotorSlot.get().func_77958_k() * 100.0f)});
        }
        return "";
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.getActive()) {
            IC2.network.get(true).updateTileEntityField(this, "rotorSlot");
        }
        super.setActive(active);
    }
}

