/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.block.TileEntityWall;
import ic2.core.block.comp.Obscuration;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.item.tool.ItemObscurator;
import ic2.core.model.AbstractSmartBlockModel;
import ic2.core.model.MergedBlockModel;
import ic2.core.model.ModelUtil;
import ic2.core.ref.BlockName;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.IPerspectiveAwareModel;

public class RenderBlockWall
extends AbstractSmartBlockModel {
    @Override
    protected IBakedModel handleBlockState(Ic2BlockState.Ic2BlockStateInstance state) {
        if (!state.hasValue(TileEntityWall.renderStateProperty)) {
            return ModelUtil.getMissingModel();
        }
        TileEntityWall.WallRenderState prop = state.getValue(TileEntityWall.renderStateProperty);
        float[][] uvs = new float[6][];
        int[][] colorMultipliers = new int[6][];
        int total = 0;
        for (int i = 0; i < 6; ++i) {
            ItemObscurator.ObscuredRenderInfo renderInfo;
            Obscuration.ObscurationData data = prop.obscurations[i];
            if (data == null || (renderInfo = ItemObscurator.getRenderInfo(data.state, data.side)) == null) continue;
            uvs[i] = renderInfo.uvs;
            colorMultipliers[i] = data.colorMultipliers;
            total += data.colorMultipliers.length;
        }
        IBakedModel baseModel = ModelUtil.getBlockModel(BlockName.wall.getBlockState(prop.color));
        if (total == 0) {
            return baseModel;
        }
        MergedBlockModel mergedModel = RenderBlockWall.generateModel(baseModel, colorMultipliers);
        mergedModel.setSprite(uvs, colorMultipliers);
        return mergedModel;
    }

    private static MergedBlockModel generateModel(IBakedModel baseModel, int[][] colorMultipliers) {
        int tint = -1;
        float offset = 0.001f;
        List[] mergedQuads = new List[6];
        int[] retextureStart = new int[6];
        IntBuffer buffer = MergedBlockModel.getQuadBuffer();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int[] sideColorMultipliers = colorMultipliers[side.ordinal()];
            List baseFaceQuads = baseModel.func_177551_a(side);
            if (sideColorMultipliers == null) {
                mergedQuads[side.ordinal()] = baseFaceQuads;
            } else {
                ArrayList<IColoredBakedQuad.ColoredBakedQuad> mergedFaceQuads = new ArrayList<IColoredBakedQuad.ColoredBakedQuad>(baseFaceQuads.size() + sideColorMultipliers.length);
                mergedFaceQuads.addAll(baseFaceQuads);
                for (int i = 0; i < sideColorMultipliers.length; ++i) {
                    RenderBlockWall.generateQuad(side, 0.001f, buffer);
                    mergedFaceQuads.add(new IColoredBakedQuad.ColoredBakedQuad(Arrays.copyOf(buffer.array(), buffer.position()), -1, side));
                    buffer.rewind();
                }
                mergedQuads[side.ordinal()] = mergedFaceQuads;
            }
            retextureStart[side.ordinal()] = baseFaceQuads.size();
        }
        return new MergedBlockModel((IPerspectiveAwareModel)baseModel, mergedQuads, retextureStart);
    }

    private static void generateQuad(EnumFacing side, float offset, IntBuffer out) {
        int color = -1;
        switch (side) {
            case DOWN: {
                MergedBlockModel.generateVertex(0.0f, -offset, 0.0f, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(1.0f, -offset, 0.0f, -1, 1.0f, 0.0f, out);
                MergedBlockModel.generateVertex(1.0f, -offset, 1.0f, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(0.0f, -offset, 1.0f, -1, 0.0f, 1.0f, out);
                break;
            }
            case UP: {
                MergedBlockModel.generateVertex(0.0f, 1.0f + offset, 0.0f, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(0.0f, 1.0f + offset, 1.0f, -1, 0.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f, 1.0f + offset, 1.0f, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f, 1.0f + offset, 0.0f, -1, 1.0f, 0.0f, out);
                break;
            }
            case NORTH: {
                MergedBlockModel.generateVertex(0.0f, 0.0f, -offset, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(0.0f, 1.0f, -offset, -1, 0.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f, 1.0f, -offset, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f, 0.0f, -offset, -1, 1.0f, 0.0f, out);
                break;
            }
            case SOUTH: {
                MergedBlockModel.generateVertex(0.0f, 0.0f, 1.0f + offset, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(1.0f, 0.0f, 1.0f + offset, -1, 1.0f, 0.0f, out);
                MergedBlockModel.generateVertex(1.0f, 1.0f, 1.0f + offset, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(0.0f, 1.0f, 1.0f + offset, -1, 0.0f, 1.0f, out);
                break;
            }
            case WEST: {
                MergedBlockModel.generateVertex(-offset, 0.0f, 0.0f, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(-offset, 0.0f, 1.0f, -1, 1.0f, 0.0f, out);
                MergedBlockModel.generateVertex(-offset, 1.0f, 1.0f, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(-offset, 1.0f, 0.0f, -1, 0.0f, 1.0f, out);
                break;
            }
            case EAST: {
                MergedBlockModel.generateVertex(1.0f + offset, 0.0f, 0.0f, -1, 0.0f, 0.0f, out);
                MergedBlockModel.generateVertex(1.0f + offset, 1.0f, 0.0f, -1, 0.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f + offset, 1.0f, 1.0f, -1, 1.0f, 1.0f, out);
                MergedBlockModel.generateVertex(1.0f + offset, 0.0f, 1.0f, -1, 1.0f, 0.0f, out);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

