/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.block.BlockBase;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.state.Ic2BlockState;
import ic2.core.init.MainConfig;
import ic2.core.item.block.ItemBlockTileEntity;
import ic2.core.model.ModelUtil;
import ic2.core.ref.BlockName;
import ic2.core.ref.IMultiBlock;
import ic2.core.ref.MetaTeBlock;
import ic2.core.ref.MetaTeBlockProperty;
import ic2.core.ref.TeBlock;
import ic2.core.util.ConfigUtil;
import ic2.core.util.Util;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockTileEntity
extends BlockBase
implements IMultiBlock<TeBlock>,
IWrenchable {
    private static final IProperty<MetaTeBlock> typeProperty = new MetaTeBlockProperty();
    private static final IProperty<EnumFacing> facingProperty = PropertyDirection.func_177714_a((String)"facing");
    private static final int removedTesToKeep = 4;
    private static final WeakReference<TileEntityBlock>[] removedTes = new WeakReference[4];
    private static int nextRemovedTeIndex;
    private final Item item;

    public BlockTileEntity() {
        super(BlockName.te, Material.field_151573_f, ItemBlockTileEntity.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(typeProperty, (Comparable)TeBlock.invalid.getMeta(false)).func_177226_a(facingProperty, (Comparable)EnumFacing.DOWN));
        this.item = Item.func_150898_a((Block)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(BlockName name) {
        final ResourceLocation loc = Util.getName(this);
        final ModelResourceLocation invalidLocation = ModelUtil.getModelLocation(loc, this.field_176227_L.func_177621_b().func_177226_a(typeProperty, (Comparable)TeBlock.invalid.getMeta(false)).func_177226_a(facingProperty, (Comparable)EnumFacing.NORTH));
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new IStateMapper(){

            public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
                IdentityHashMap<IBlockState, ModelResourceLocation> ret = new IdentityHashMap<IBlockState, ModelResourceLocation>();
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    MetaTeBlock metaTeBlock = (MetaTeBlock)state.func_177229_b(typeProperty);
                    EnumFacing facing = (EnumFacing)state.func_177229_b(facingProperty);
                    if (metaTeBlock.teBlock.supportedFacings.contains(facing) || facing == EnumFacing.DOWN && metaTeBlock.teBlock.supportedFacings.isEmpty()) {
                        ret.put(state, ModelUtil.getModelLocation(loc, state));
                        continue;
                    }
                    ret.put(state, invalidLocation);
                }
                return ret;
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)this.item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                IBlockState state = BlockTileEntity.this.func_176223_P().func_177226_a(typeProperty, (Comparable)TeBlock.get(stack.func_77952_i()).getMeta(false)).func_177226_a(facingProperty, (Comparable)EnumFacing.NORTH);
                return ModelUtil.getModelLocation(loc, state);
            }
        });
        for (TeBlock teBlock : TeBlock.values) {
            if (!teBlock.hasItem()) continue;
            IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(typeProperty, (Comparable)teBlock.getMeta(false)).func_177226_a(facingProperty, (Comparable)EnumFacing.NORTH);
            ModelBakery.registerItemVariants((Item)this.item, (ResourceLocation[])new ModelResourceLocation[]{ModelUtil.getModelLocation(loc, state)});
        }
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected BlockState func_180661_e() {
        return new Ic2BlockState(this, typeProperty, facingProperty);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return state;
        }
        return state.func_177226_a(typeProperty, (Comparable)TeBlock.get(te.getClass()).getMeta(te.getActive())).func_177226_a(facingProperty, (Comparable)te.getFacing());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (TeBlock type : TeBlock.values) {
            if (!type.hasItem()) continue;
            list.add(this.getItemStack(type));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return null;
        }
        return te.getPickBlock(player, target);
    }

    @Override
    public IBlockState getState(TeBlock variant) {
        if (variant == null) {
            throw new IllegalArgumentException("invalid type: " + variant);
        }
        return this.func_176223_P().func_177226_a(typeProperty, (Comparable)variant.getMeta(false));
    }

    @Override
    public ItemStack getItemStack(TeBlock type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
        int id = type.getId();
        if (id != -1) {
            return new ItemStack(this.item, 1, type.getId());
        }
        return null;
    }

    @Override
    public ItemStack getItemStack(String variant) {
        if (variant == null) {
            throw new IllegalArgumentException("invalid type: " + variant);
        }
        TeBlock type = TeBlock.get(variant);
        if (type == null) {
            throw new IllegalArgumentException("invalid type: " + variant);
        }
        return this.getItemStack(type);
    }

    @Override
    public String getVariant(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        if (stack.func_77973_b() != this.item) {
            throw new IllegalArgumentException("The stack " + stack + " doesn't match " + this.item + " (" + this + ")");
        }
        TeBlock type = TeBlock.get(stack.func_77960_j());
        if (type == null) {
            throw new IllegalArgumentException("The stack " + stack + " doesn't reference any valid subtype");
        }
        return type.getName();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176193_a(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos)) {
            return false;
        }
        if (stack == null) {
            return true;
        }
        if (stack.func_77973_b() != this.item) {
            return false;
        }
        TeBlock type = TeBlock.get(stack.func_77960_j());
        if (type == null) {
            return false;
        }
        TeBlock.ITePlaceHandler handler = type.getPlaceHandler();
        return handler == null || handler.canReplace(world, pos, side, stack);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.func_176193_a(world, pos, side, null);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.func_176193_a(world, pos, null, null);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return state;
        }
        return te.getExtendedState((Ic2BlockState.Ic2BlockStateInstance)state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onPlaced(stack, placer, EnumFacing.UP);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 start, Vec3 end) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_180636_a(world, pos, start, end);
        }
        return te.collisionRayTrace(start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_180646_a(world, pos);
        }
        return te.getSelectionBoundingBox();
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            super.func_180638_a(world, pos, state, mask, list, collidingEntity);
        } else {
            te.addCollisionBoxesToList(mask, list, collidingEntity);
        }
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_180640_a(world, pos, state);
        }
        return te.getSelectionBoundingBox();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onEntityCollision(entity);
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        return te.doesSideBlockRendering(face);
    }

    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        return te.isNormalCube();
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        return te.isSideSolid(side);
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return this.func_149717_k();
        }
        return te.getLightOpacity();
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return 0;
        }
        return te.getLightValue();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        return te.onActivated(player, side, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onClicked(player);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onNeighborChange(neighborBlock);
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return 0;
        }
        return te.getStrongPower(side);
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return 0;
        }
        return te.getWeakPower(side);
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return false;
        }
        return te.connectRedstone(side);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return 0;
        }
        return te.getComparatorInputOverride();
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        return te.recolor(side, color);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onExploded(explosion);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.onBlockBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te != null) {
            if (!te.onRemovedByPlayer(player, willHarvest)) {
                return false;
            }
            if (willHarvest && !world.field_72995_K) {
                BlockTileEntity.removedTes[BlockTileEntity.nextRemovedTeIndex] = new WeakReference<TileEntityBlock>(te);
                nextRemovedTeIndex = (nextRemovedTeIndex + 1) % 4;
            }
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public float func_180647_a(EntityPlayer player, World world, BlockPos pos) {
        TileEntityBlock te;
        float ret = super.func_180647_a(player, world, pos);
        if (!player.func_146099_a((Block)this) && (te = BlockTileEntity.getTe((IBlockAccess)world, pos)) != null && te.teBlock.harvestTool == TeBlock.HarvestTool.None) {
            ret *= 3.3333333f;
        }
        return ret;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        boolean ret = super.canHarvestBlock(world, pos, player);
        if (ret) {
            return ret;
        }
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        return te != null && te.teBlock.harvestTool == TeBlock.HarvestTool.None;
    }

    public String getHarvestTool(IBlockState state) {
        if (state.func_177230_c() != this) {
            return null;
        }
        return ((MetaTeBlock)state.func_177229_b(BlockTileEntity.typeProperty)).teBlock.harvestTool.toolClass;
    }

    public int getHarvestLevel(IBlockState state) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((MetaTeBlock)state.func_177229_b(BlockTileEntity.typeProperty)).teBlock.harvestTool.level;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            int checkIdx;
            World realWorld = Util.getWorld(world);
            if (realWorld != null && realWorld.field_72995_K || realWorld == null && !IC2.platform.isSimulating()) {
                return new ArrayList<ItemStack>();
            }
            int idx = nextRemovedTeIndex;
            do {
                TileEntityBlock cTe;
                WeakReference<TileEntityBlock> ref;
                if ((ref = removedTes[checkIdx = (idx + 4 - 1) % 4]) == null || (cTe = (TileEntityBlock)ref.get()) == null || realWorld != null && cTe.func_145831_w() != realWorld || !cTe.func_174877_v().equals((Object)pos)) continue;
                te = cTe;
                BlockTileEntity.removedTes[checkIdx] = null;
                break;
            } while ((idx = checkIdx) != nextRemovedTeIndex);
            if (te == null) {
                return new ArrayList<ItemStack>();
            }
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(te.getSelfDrops(fortune, ConfigUtil.getBool(MainConfig.get(), "balance/ignoreWrenchRequirement")));
        ret.addAll(te.getAuxDrops(fortune));
        return ret;
    }

    public float func_176195_g(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return 5.0f;
        }
        return te.getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return 10.0f;
        }
        return te.getExplosionResistance(exploder, explosion);
    }

    public boolean canEntityDestroy(IBlockAccess world, BlockPos pos, Entity entity) {
        TileEntityBlock te = BlockTileEntity.getTe(world, pos);
        if (te == null) {
            return true;
        }
        return te.canEntityDestroy(entity);
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return EnumFacing.DOWN;
        }
        return te.getFacing();
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        return te.setFacingWrench(newDirection, player);
    }

    @Override
    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlock te = BlockTileEntity.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return false;
        }
        return te.wrenchCanRemove(player);
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        if (!(te instanceof TileEntityBlock)) {
            return Collections.emptyList();
        }
        return ((TileEntityBlock)te).getWrenchDrops(player, fortune);
    }

    private static TileEntityBlock getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityBlock) {
            return (TileEntityBlock)te;
        }
        return null;
    }
}

