/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration.core;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import ic2.api.item.ElectricItem;
import ic2.bcIntegration.core.Trigger;
import ic2.bcIntegration.core.TriggerType;
import ic2.core.block.comp.Energy;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerCapacitor
extends Trigger {
    public TriggerCapacitor(TriggerType type) {
        super(type);
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case capacitor_empty: {
                return "Capacitor Empty";
            }
            case capacitor_has_energy: {
                return "Capacitor Has Energy";
            }
            case capacitor_has_room: {
                return "Space For Energy";
            }
            case capacitor_full: {
                return "Capacitor Full";
            }
            case charge_empty: {
                return "Charging Empty Item";
            }
            case charge_partial: {
                return "Charging Partially Charged Item";
            }
            case charge_full: {
                return "Charging Fully Charged Item";
            }
            case discharge_empty: {
                return "Discharging Empty Item";
            }
            case discharge_partial: {
                return "Discharging Partially Charged Item";
            }
            case discharge_full: {
                return "Discharging Fully Charged Item";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target == null) {
            return false;
        }
        if (target instanceof TileEntityStandardMachine) {
            TileEntityStandardMachine te = (TileEntityStandardMachine)target;
            boolean hasEnergy = te.getComponent(Energy.class).getEnergy() >= (double)te.defaultEnergyConsume;
            boolean hasRoom = te.getComponent(Energy.class).getEnergy() <= te.getComponent(Energy.class).getCapacity() - (double)te.defaultEnergyConsume;
            ItemStack item = te.dischargeSlot.get();
            switch (this.type) {
                case capacitor_empty: {
                    return !hasEnergy;
                }
                case capacitor_has_energy: {
                    return hasEnergy;
                }
                case capacitor_has_room: {
                    return hasRoom;
                }
                case capacitor_full: {
                    return !hasRoom;
                }
                case discharge_empty: {
                    return item != null && !this.canDischarge(item);
                }
                case discharge_partial: {
                    return item != null && this.canDischarge(item) && this.canCharge(item);
                }
                case discharge_full: {
                    return item != null && !this.canCharge(item);
                }
            }
            return false;
        }
        if (target instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator te = (TileEntityBaseGenerator)target;
            boolean hasEnergy = te.getComponent(Energy.class).getFillRatio() > 0.0;
            boolean hasRoom = te.getComponent(Energy.class).getFillRatio() < 1.0;
            ItemStack item = te.chargeSlot.get();
            switch (this.type) {
                case capacitor_empty: {
                    return !hasEnergy;
                }
                case capacitor_has_energy: {
                    return hasEnergy;
                }
                case capacitor_has_room: {
                    return hasRoom;
                }
                case capacitor_full: {
                    return !hasRoom;
                }
                case charge_empty: {
                    return item != null && !this.canDischarge(item);
                }
                case charge_partial: {
                    return item != null && this.canDischarge(item) && this.canCharge(item);
                }
                case charge_full: {
                    return item != null && !this.canCharge(item);
                }
            }
            return false;
        }
        if (target instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock te = (TileEntityElectricBlock)target;
            boolean hasEnergy = te.getComponent(Energy.class).getEnergy() >= te.getComponent(Energy.class).getFillRatio();
            boolean hasRoom = te.getComponent(Energy.class).getEnergy() < te.getComponent(Energy.class).getCapacity();
            ItemStack chargeItem = te.chargeSlot.get();
            ItemStack dischargeItem = te.dischargeSlot.get();
            switch (this.type) {
                case capacitor_empty: {
                    return !hasEnergy;
                }
                case capacitor_has_energy: {
                    return hasEnergy;
                }
                case capacitor_has_room: {
                    return hasRoom;
                }
                case capacitor_full: {
                    return !hasRoom;
                }
                case charge_empty: {
                    return chargeItem != null && !this.canDischarge(chargeItem);
                }
                case charge_partial: {
                    return chargeItem != null && this.canDischarge(chargeItem) && this.canCharge(chargeItem);
                }
                case charge_full: {
                    return chargeItem != null && !this.canCharge(chargeItem);
                }
                case discharge_empty: {
                    return dischargeItem != null && !this.canDischarge(dischargeItem);
                }
                case discharge_partial: {
                    return dischargeItem != null && this.canDischarge(dischargeItem) && this.canCharge(dischargeItem);
                }
                case discharge_full: {
                    return dischargeItem != null && !this.canCharge(dischargeItem);
                }
            }
            return false;
        }
        return false;
    }

    private boolean canDischarge(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        return ElectricItem.manager.getCharge(itemStack) > 0.0;
    }

    private boolean canCharge(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        return ElectricItem.manager.charge(itemStack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true) > 0.0;
    }
}

