/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration.core;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import ic2.bcIntegration.core.TriggerType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Trigger
implements ITriggerExternal {
    protected final TriggerType type;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;

    public Trigger(TriggerType type) {
        this.type = type;
        StatementManager.registerStatement((IStatement)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getUniqueTag() {
        return "IC2_" + this.type.name();
    }

    public abstract String getDescription();

    public abstract boolean isTriggerActive(TileEntity var1, EnumFacing var2, IStatementContainer var3, IStatementParameter[] var4);

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int index) {
        return null;
    }

    public IStatement rotateLeft() {
        return this;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stitchTextures(TextureStitchEvent.Pre event) {
        this.sprite = null;
        ResourceLocation location = new ResourceLocation("ic2:bcTrigger/" + this.type.name());
        this.sprite = event.map.getTextureExtry(location.toString());
        if (this.sprite == null) {
            this.sprite = event.map.func_174942_a(location);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGuiSprite() {
        return this.sprite;
    }
}

