/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public enum Direction {
    XN,
    XP,
    YN,
    YP,
    ZN,
    ZP;

    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    public static final Direction[] directions;
    public static final Set<Direction> noDirections;
    public static final Set<Direction> allDirections;

    private Direction() {
        int side = this.ordinal() / 2;
        int sign = this.getSign();
        this.xOffset = side == 0 ? sign : 0;
        this.yOffset = side == 1 ? sign : 0;
        this.zOffset = side == 2 ? sign : 0;
    }

    public static Direction fromSideValue(int side) {
        return directions[(side + 2) % 6];
    }

    public static Direction fromEnumFacing(EnumFacing dir) {
        return Direction.fromSideValue(dir.ordinal());
    }

    public TileEntity applyToTileEntity(TileEntity te) {
        return this.applyTo(te.func_145831_w(), te.func_174877_v());
    }

    public TileEntity applyTo(World world, BlockPos pos) {
        if (world != null && world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            try {
                return world.func_175625_s(pos);
            }
            catch (Exception e) {
                throw new RuntimeException("error getting TileEntity at dim " + world.field_73011_w.func_177502_q() + " " + pos);
            }
        }
        return null;
    }

    public Direction getInverse() {
        return directions[this.ordinal() ^ 1];
    }

    public int toSideValue() {
        return (this.ordinal() + 4) % 6;
    }

    private int getSign() {
        return this.ordinal() % 2 * 2 - 1;
    }

    public EnumFacing toFacing() {
        return EnumFacing.field_82609_l[this.toSideValue()];
    }

    static {
        directions = Direction.values();
        noDirections = EnumSet.noneOf(Direction.class);
        allDirections = EnumSet.allOf(Direction.class);
    }
}

