/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.util.IItemReceptor;
import com.enderio.core.common.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtil {
    public static final List<IItemReceptor> receptors;
    private static final Random rand;

    public static Object parseStringIntoRecipeItem(String string) {
        return ItemUtil.parseStringIntoRecipeItem(string, false);
    }

    public static Object parseStringIntoRecipeItem(String string, boolean forceItemStack) {
        if ("null".equals(string)) {
            return null;
        }
        if (OreDictionary.getOres((String)string).isEmpty()) {
            ItemStack stack = null;
            String[] info = string.split(";");
            Object temp = null;
            int damage = Short.MAX_VALUE;
            temp = Item.field_150901_e.func_82594_a((Object)new ResourceLocation(info[0]));
            if (info.length > 1) {
                damage = Integer.parseInt(info[1]);
            }
            if (temp instanceof Item) {
                stack = new ItemStack((Item)temp, 1, damage);
            } else if (temp instanceof Block) {
                stack = new ItemStack((Block)temp, 1, damage);
            } else if (temp instanceof ItemStack) {
                stack = ((ItemStack)temp).func_77946_l();
                stack.func_77964_b(damage);
            } else {
                throw new IllegalArgumentException(string + " is not a vaild string. Strings should be either an oredict name, or in the format objectname;damage (damage is optional)");
            }
            return stack;
        }
        if (forceItemStack) {
            return ((ItemStack)OreDictionary.getOres((String)string).get(0)).func_77946_l();
        }
        return string;
    }

    public static ItemStack parseStringIntoItemStack(String string) {
        int size = 1;
        int numIdx = string.indexOf(35);
        int nbtIdx = string.indexOf(36);
        NBTTagCompound tag = null;
        if (numIdx != -1) {
            String num = string.substring(numIdx + 1, nbtIdx == -1 ? string.length() : nbtIdx);
            try {
                size = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(num + " is not a valid stack size", e);
            }
            string = string.replace('#' + num, "");
            nbtIdx -= num.length() + 1;
        }
        if (nbtIdx != -1) {
            String nbt = string.substring(nbtIdx + 1);
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                throw new IllegalArgumentException(nbt + " is not valid NBT json.", e);
            }
            string = string.replace('$' + nbt, "");
        }
        ItemStack stack = (ItemStack)ItemUtil.parseStringIntoRecipeItem(string, true);
        stack.field_77994_a = MathHelper.func_76125_a((int)size, (int)1, (int)stack.func_77976_d());
        stack.func_77982_d(tag);
        return stack;
    }

    public static String getStringForItemStack(ItemStack stack, boolean damage, boolean size) {
        if (stack == null) {
            return null;
        }
        String base = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
        if (damage) {
            base = base + ";" + stack.func_77952_i();
        }
        if (size) {
            base = base + "#" + stack.field_77994_a;
        }
        return base;
    }

    public static boolean stacksEqual(ItemStack s1, ItemStack s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        if (s1.func_77978_p() == null && s2.func_77978_p() == null) {
            return true;
        }
        if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
            return false;
        }
        return s1.func_77978_p().equals((Object)s2.func_77978_p());
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, BlockPos pos) {
        ItemUtil.spawnItemInWorldWithRandomMotion(world, item, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnItemInWorldWithRandomMotion(World world, ItemStack item, int x, int y, int z) {
        if (item != null) {
            ItemUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(EntityItem entity) {
        entity.func_174869_p();
        float f = rand.nextFloat() * 0.1f - 0.05f;
        float f1 = rand.nextFloat() * 0.1f - 0.05f;
        float f2 = rand.nextFloat() * 0.1f - 0.05f;
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        entity.field_70170_p.func_72838_d((Entity)entity);
    }

    public static boolean itemStackMatchesOredict(ItemStack stack, String oredict) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)i);
            if (!name.equals(oredict)) continue;
            return true;
        }
        return false;
    }

    public static NBTTagCompound getNBTTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static String getDurabilityString(ItemStack item) {
        if (item == null) {
            return null;
        }
        return EnderCore.lang.localize("tooltip.durability") + " " + (item.func_77958_k() - item.func_77952_i()) + "/" + item.func_77958_k();
    }

    public static NBTTagCompound getOrCreateNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static int doInsertItem(Object into, ItemStack item, EnumFacing side) {
        if (into == null || item == null) {
            return 0;
        }
        if (into instanceof ISidedInventory) {
            return ItemUtil.doInsertItemInv((IInventory)((ISidedInventory)into), item, side, true);
        }
        if (into instanceof IInventory) {
            return ItemUtil.doInsertItemInv(ItemUtil.getInventory((IInventory)into), item, side, true);
        }
        for (IItemReceptor rec : receptors) {
            if (!rec.canInsertIntoObject(into, side)) continue;
            return rec.doInsertItem(into, item, side);
        }
        return 0;
    }

    public static int doInsertItem(IInventory inv, int startSlot, int endSlot, ItemStack item) {
        return ItemUtil.doInsertItemInv(inv, null, invSlotter.getInstance(startSlot, endSlot), item, null, true);
    }

    public static int doInsertItem(IInventory inv, int startSlot, int endSlot, ItemStack item, boolean doInsert) {
        return ItemUtil.doInsertItemInv(inv, null, invSlotter.getInstance(startSlot, endSlot), item, null, doInsert);
    }

    private static int doInsertItemInv(IInventory inv, ItemStack item, EnumFacing inventorySide, boolean doInsert) {
        ISidedInventory sidedInv = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        ISlotIterator slots = sidedInv != null ? sidedSlotter.getInstance(sidedInv.func_180463_a(inventorySide)) : invSlotter.getInstance(0, inv.func_70302_i_());
        return ItemUtil.doInsertItemInv(inv, sidedInv, slots, item, inventorySide, doInsert);
    }

    private static int doInsertItemInv(IInventory inv, ISidedInventory sidedInv, ISlotIterator slots, ItemStack item, EnumFacing inventorySide, boolean doInsert) {
        int numInserted = 0;
        int numToInsert = item.field_77994_a;
        int firstFreeSlot = -1;
        while (numToInsert > 0 && slots.hasNext()) {
            int slot = slots.nextSlot();
            if (sidedInv != null && !sidedInv.func_180462_a(slot, item, inventorySide)) continue;
            ItemStack contents = inv.func_70301_a(slot);
            if (contents != null) {
                int freeSpace;
                if (!ItemUtil.areStackMergable(contents, item) || (freeSpace = Math.min(inv.func_70297_j_(), contents.func_77976_d()) - contents.field_77994_a) <= 0) continue;
                int noToInsert = Math.min(numToInsert, freeSpace);
                ItemStack toInsert = item.func_77946_l();
                toInsert.field_77994_a = contents.field_77994_a + noToInsert;
                if (sidedInv == null && !inv.func_94041_b(slot, toInsert)) continue;
                numInserted += noToInsert;
                numToInsert -= noToInsert;
                if (!doInsert) continue;
                inv.func_70299_a(slot, toInsert);
                continue;
            }
            if (firstFreeSlot != -1) continue;
            firstFreeSlot = slot;
        }
        if (numToInsert > 0 && firstFreeSlot != -1) {
            ItemStack toInsert = item.func_77946_l();
            toInsert.field_77994_a = ItemUtil.min(numToInsert, inv.func_70297_j_(), toInsert.func_77976_d());
            if (sidedInv != null || inv.func_94041_b(firstFreeSlot, toInsert)) {
                numInserted += toInsert.field_77994_a;
                numToInsert -= toInsert.field_77994_a;
                if (doInsert) {
                    inv.func_70299_a(firstFreeSlot, toInsert);
                }
            }
        }
        if (numInserted > 0 && doInsert) {
            inv.func_70296_d();
        }
        return numInserted;
    }

    private static final int min(int i1, int i2, int i3) {
        return i1 < i2 ? (i1 < i3 ? i1 : i3) : (i2 < i3 ? i2 : i3);
    }

    public static boolean isStackFull(ItemStack contents) {
        if (contents == null) {
            return false;
        }
        return contents.field_77994_a >= contents.func_77976_d();
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest neighbour = null;
            boolean reverse = false;
            if (chest.field_145991_k != null) {
                neighbour = chest.field_145991_k;
                reverse = true;
            } else if (chest.field_145990_j != null) {
                neighbour = chest.field_145990_j;
            } else if (chest.field_145992_i != null) {
                neighbour = chest.field_145992_i;
                reverse = true;
            } else if (chest.field_145988_l != null) {
                neighbour = chest.field_145988_l;
            }
            if (neighbour != null) {
                if (reverse) {
                    return new InventoryLargeChest("", (ILockableContainer)neighbour, (ILockableContainer)inv);
                }
                return new InventoryLargeChest("", (ILockableContainer)inv, (ILockableContainer)neighbour);
            }
        }
        return inv;
    }

    public static boolean areStackMergable(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null || !s1.func_77985_e() || !s2.func_77985_e()) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean areStacksEqual(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    static {
        block2: {
            receptors = new ArrayList<IItemReceptor>();
            rand = new Random();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Machines will not be able to output to BC pipes.");
            }
        }
    }

    private static final class sidedSlotter
    implements ISlotIterator {
        private static final sidedSlotter me = new sidedSlotter();
        private int[] slots;
        private int current;

        private sidedSlotter() {
        }

        public static final sidedSlotter getInstance(int[] slots) {
            sidedSlotter.me.slots = slots;
            sidedSlotter.me.current = 0;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.slots[this.current++];
        }

        @Override
        public final boolean hasNext() {
            return this.slots != null && this.current < this.slots.length;
        }
    }

    private static final class invSlotter
    implements ISlotIterator {
        private static final invSlotter me = new invSlotter();
        private int end;
        private int current;

        private invSlotter() {
        }

        public static final invSlotter getInstance(int start, int end) {
            invSlotter.me.end = end;
            invSlotter.me.current = start;
            return me;
        }

        @Override
        public final int nextSlot() {
            return this.current++;
        }

        @Override
        public final boolean hasNext() {
            return this.current < this.end;
        }
    }

    private static interface ISlotIterator {
        public int nextSlot();

        public boolean hasNext();
    }
}

