/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.IFluidReceptor;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.Loader;

public class FluidUtil {
    public static final List<IFluidReceptor> fluidReceptors;

    public static Map<EnumFacing, IFluidHandler> getNeighbouringFluidHandlers(IBlockAccess world, BlockCoord bc) {
        HashMap<EnumFacing, IFluidHandler> res = new HashMap<EnumFacing, IFluidHandler>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IFluidHandler fh = FluidUtil.getFluidHandler(world, bc.getLocation(dir));
            if (fh == null) continue;
            res.put(dir, fh);
        }
        return res;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockCoord bc) {
        return FluidUtil.getFluidHandler(world, bc.x, bc.y, bc.z);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        return FluidUtil.getFluidHandler(te);
    }

    public static IFluidHandler getFluidHandler(TileEntity te) {
        if (te instanceof IFluidHandler) {
            IFluidHandler res = (IFluidHandler)te;
            for (IFluidReceptor rec : fluidReceptors) {
                if (rec.isValidReceptor(res)) continue;
                return null;
            }
            return res;
        }
        return null;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
                return new FluidStack(fluid, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean doPull(IFluidHandler into, EnumFacing fromDir, int maxVolume) {
        FluidTankInfo[] infos;
        TileEntity te = (TileEntity)into;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.func_145831_w(), loc);
        if (target != null && (infos = target.getTankInfo(fromDir.func_176734_d())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !into.canFill(fromDir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(maxVolume, canPull.amount);
                FluidStack drained = target.drain(fromDir.func_176734_d(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = into.fill(fromDir, drained, false)) <= 0) continue;
                drained = target.drain(fromDir.func_176734_d(), filled, true);
                into.fill(fromDir, drained, true);
                return true;
            }
        }
        return false;
    }

    public static boolean doPush(IFluidHandler from, EnumFacing fromDir, int maxVolume) {
        TileEntity te = (TileEntity)from;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.func_145831_w(), loc);
        if (target == null) {
            return false;
        }
        FluidTankInfo[] infos = from.getTankInfo(fromDir);
        boolean res = false;
        if (infos != null) {
            for (FluidTankInfo info : infos) {
                FluidStack maxDrain;
                FluidStack canDrain;
                if (info.fluid == null || info.fluid.amount <= 0 || !from.canDrain(fromDir, info.fluid.getFluid()) || (canDrain = from.drain(fromDir, maxDrain = new FluidStack(info.fluid, maxVolume), false)) == null || canDrain.amount <= 0) continue;
                int filled = target.fill(fromDir.func_176734_d(), canDrain, true);
                from.drain(fromDir, new FluidStack(info.fluid, filled), true);
                res |= true;
            }
        }
        return res;
    }

    public static FluidAndStackResult tryFillContainer(ItemStack target, FluidStack source) {
        if (target != null && target.func_77973_b() != null && source != null && source.getFluid() != null && source.amount > 0) {
            FluidStack resultFluid;
            if (target.func_77973_b() instanceof IFluidContainerItem) {
                ItemStack resultStack = target.func_77946_l();
                resultStack.field_77994_a = 1;
                int amount = ((IFluidContainerItem)target.func_77973_b()).fill(resultStack, source, true);
                if (amount <= 0) {
                    return new FluidAndStackResult(null, null, target, source);
                }
                FluidStack resultFluid2 = source.copy();
                resultFluid2.amount = amount;
                ItemStack remainderStack = target.func_77946_l();
                --remainderStack.field_77994_a;
                if (remainderStack.field_77994_a <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = source.copy();
                remainderFluid.amount -= amount;
                if (remainderFluid.amount <= 0) {
                    remainderFluid = null;
                }
                return new FluidAndStackResult(resultStack, resultFluid2, remainderStack, remainderFluid);
            }
            ItemStack resultStack = FluidContainerRegistry.fillFluidContainer((FluidStack)source.copy(), (ItemStack)target);
            if (resultStack != null && (resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)resultStack)) != null) {
                ItemStack remainderStack = target.func_77946_l();
                --remainderStack.field_77994_a;
                if (remainderStack.field_77994_a <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = source.copy();
                remainderFluid.amount -= resultFluid.amount;
                if (remainderFluid.amount <= 0) {
                    remainderFluid = null;
                }
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
        }
        return new FluidAndStackResult(null, null, target, source);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, FluidStack target, int capacity) {
        if (source != null && source.func_77973_b() != null) {
            int maxDrain = capacity - (target != null ? target.amount : 0);
            if (source.func_77973_b() instanceof IFluidContainerItem) {
                ItemStack resultStack = source.func_77946_l();
                resultStack.field_77994_a = 1;
                FluidStack resultFluid = ((IFluidContainerItem)source.func_77973_b()).drain(resultStack, maxDrain, true);
                if (resultFluid == null || resultFluid.amount <= 0 || target != null && resultFluid.getFluid() != target.getFluid()) {
                    return new FluidAndStackResult(null, null, source, target);
                }
                ItemStack remainderStack = source.func_77946_l();
                --remainderStack.field_77994_a;
                if (remainderStack.field_77994_a <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                remainderFluid.amount += resultFluid.amount;
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
            FluidStack resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)source);
            if (resultFluid != null && resultFluid.amount > 0 && resultFluid.amount <= maxDrain && (target == null || resultFluid.isFluidEqual(target))) {
                ItemStack resultStack = source.func_77973_b().getContainerItem(source);
                ItemStack remainderStack = source.func_77946_l();
                --remainderStack.field_77994_a;
                if (remainderStack.field_77994_a <= 0) {
                    remainderStack = null;
                }
                FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                remainderFluid.amount += resultFluid.amount;
                return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
            }
        }
        return new FluidAndStackResult(null, null, source, target);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, ITankAccess tank) {
        if (source != null && source.func_77973_b() != null) {
            FluidStack resultFluid;
            FluidTank targetTank;
            if (source.func_77973_b() instanceof IFluidContainerItem) {
                FluidStack fluid = ((IFluidContainerItem)source.func_77973_b()).getFluid(source);
                FluidTank fluidTank = targetTank = fluid != null ? tank.getInputTank(fluid) : null;
                if (targetTank != null) {
                    FluidStack target = targetTank.getFluid();
                    int maxDrain = targetTank.getCapacity() - (target != null ? target.amount : 0);
                    ItemStack resultStack = source.func_77946_l();
                    resultStack.field_77994_a = 1;
                    FluidStack resultFluid2 = ((IFluidContainerItem)source.func_77973_b()).drain(resultStack, maxDrain, true);
                    if (resultFluid2 == null || resultFluid2.amount <= 0 || target != null && !resultFluid2.isFluidEqual(target)) {
                        return new FluidAndStackResult(null, null, source, target);
                    }
                    ItemStack remainderStack = source.func_77946_l();
                    --remainderStack.field_77994_a;
                    if (remainderStack.field_77994_a <= 0) {
                        remainderStack = null;
                    }
                    FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid2, 0);
                    remainderFluid.amount += resultFluid2.amount;
                    return new FluidAndStackResult(resultStack, resultFluid2, remainderStack, remainderFluid);
                }
            }
            if ((resultFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)source)) != null && resultFluid.amount > 0 && (targetTank = tank.getInputTank(resultFluid)) != null) {
                FluidStack target = targetTank.getFluid();
                int maxDrain = targetTank.getCapacity() - (target != null ? target.amount : 0);
                if (resultFluid.amount <= maxDrain && (target == null || resultFluid.isFluidEqual(target))) {
                    ItemStack resultStack = source.func_77973_b().getContainerItem(source);
                    ItemStack remainderStack = source.func_77946_l();
                    --remainderStack.field_77994_a;
                    if (remainderStack.field_77994_a <= 0) {
                        remainderStack = null;
                    }
                    FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(resultFluid, 0);
                    remainderFluid.amount += resultFluid.amount;
                    return new FluidAndStackResult(resultStack, resultFluid, remainderStack, remainderFluid);
                }
            }
        }
        return new FluidAndStackResult(null, null, source, null);
    }

    public static boolean fillPlayerHandItemFromInternalTank(World world, BlockPos pos, EntityPlayer entityPlayer, ITankAccess tank) {
        return FluidUtil.fillPlayerHandItemFromInternalTank(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityPlayer, tank);
    }

    public static boolean fillPlayerHandItemFromInternalTank(World world, int x, int y, int z, EntityPlayer entityPlayer, ITankAccess tank) {
        for (FluidTank subTank : tank.getOutputTanks()) {
            FluidAndStackResult fill = FluidUtil.tryFillContainer(entityPlayer.field_71071_by.func_70448_g(), subTank.getFluid());
            if (fill.result.fluidStack == null) continue;
            subTank.setFluid(fill.remainder.fluidStack);
            tank.setTanksDirty();
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                int i;
                if (fill.remainder.itemStack == null) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.result.itemStack);
                    return true;
                }
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.remainder.itemStack);
                if (fill.result.itemStack.func_77985_e()) {
                    for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                        ItemStack inventoryItem = entityPlayer.field_71071_by.field_70462_a[i];
                        if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.field_77994_a >= inventoryItem.func_77976_d()) continue;
                        fill.result.itemStack.field_77994_a += inventoryItem.field_77994_a;
                        entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                        return true;
                    }
                }
                for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                    if (entityPlayer.field_71071_by.field_70462_a[i] != null) continue;
                    entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                    return true;
                }
                if (!world.field_72995_K) {
                    double x0 = ((double)x + entityPlayer.field_70165_t) / 2.0;
                    double y0 = ((double)y + entityPlayer.field_70163_u) / 2.0 + 0.5;
                    double z0 = ((double)z + entityPlayer.field_70161_v) / 2.0;
                    Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillInternalTankFromPlayerHandItem(World world, BlockPos pos, EntityPlayer entityPlayer, ITankAccess tank) {
        return FluidUtil.fillInternalTankFromPlayerHandItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityPlayer, tank);
    }

    public static boolean fillInternalTankFromPlayerHandItem(World world, int x, int y, int z, EntityPlayer entityPlayer, ITankAccess tank) {
        FluidAndStackResult fill = FluidUtil.tryDrainContainer(entityPlayer.field_71071_by.func_70448_g(), tank);
        if (fill.result.fluidStack == null) {
            return false;
        }
        tank.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        tank.setTanksDirty();
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            int i;
            if (fill.remainder.itemStack == null) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.result.itemStack);
                return true;
            }
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.remainder.itemStack);
            if (fill.result.itemStack == null) {
                return true;
            }
            if (fill.result.itemStack.func_77985_e()) {
                for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack inventoryItem = entityPlayer.field_71071_by.field_70462_a[i];
                    if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.field_77994_a >= inventoryItem.func_77976_d()) continue;
                    fill.result.itemStack.field_77994_a += inventoryItem.field_77994_a;
                    entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                    return true;
                }
            }
            for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                if (entityPlayer.field_71071_by.field_70462_a[i] != null) continue;
                entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                return true;
            }
            if (!world.field_72995_K) {
                double x0 = ((double)x + entityPlayer.field_70165_t) / 2.0;
                double y0 = ((double)y + entityPlayer.field_70163_u) / 2.0 + 0.5;
                double z0 = ((double)z + entityPlayer.field_70161_v) / 2.0;
                Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
            }
        }
        return true;
    }

    public static boolean areFluidsTheSame(Fluid fluid, Fluid fluid2) {
        if (fluid == null) {
            return fluid2 == null;
        }
        if (fluid2 == null) {
            return false;
        }
        return fluid == fluid2 || fluid.getName().equals(fluid2.getName());
    }

    static {
        block2: {
            fluidReceptors = new ArrayList<IFluidReceptor>();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Fluid conduits will show connections to all Build Craft pipes.");
            }
        }
    }

    public static class FluidAndStackResult {
        public final FluidAndStack result;
        public final FluidAndStack remainder;

        public FluidAndStackResult(FluidAndStack result, FluidAndStack remainder) {
            this.result = result;
            this.remainder = remainder;
        }

        public FluidAndStackResult(FluidStack fluidStackResult, ItemStack itemStackResult, FluidStack fluidStackRemainder, ItemStack itemStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }

        public FluidAndStackResult(ItemStack itemStackResult, FluidStack fluidStackResult, ItemStack itemStackRemainder, FluidStack fluidStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }
    }

    public static class FluidAndStack {
        public final FluidStack fluidStack;
        public final ItemStack itemStack;

        public FluidAndStack(FluidStack fluidStack, ItemStack itemStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }

        public FluidAndStack(ItemStack itemStack, FluidStack fluidStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }
    }
}

