/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public final class BoundingBox {
    public static final BoundingBox UNIT_CUBE = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    public BoundingBox(AxisAlignedBB bb) {
        this(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = (float)minX;
        this.minY = (float)minY;
        this.minZ = (float)minZ;
        this.maxX = (float)maxX;
        this.maxY = (float)maxY;
        this.maxZ = (float)maxZ;
    }

    public BoundingBox(Vector3d min, Vector3d max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public BoundingBox(BoundingBox copy) {
        this(copy.minX, copy.minY, copy.minZ, copy.maxX, copy.maxY, copy.maxZ);
    }

    public BoundingBox(BlockCoord bc) {
        this(bc.getBlockPos());
    }

    public BoundingBox(BlockPos bc) {
        this(bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), bc.func_177958_n() + 1, bc.func_177956_o() + 1, bc.func_177952_p() + 1);
    }

    public BoundingBox(Block block) {
        this(block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    public BoundingBox expandBy(BoundingBox other) {
        return new BoundingBox(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.min(this.minZ, other.minZ), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY), Math.max(this.maxZ, other.maxZ));
    }

    public boolean contains(BoundingBox other) {
        return this.minX >= other.minX && this.minY <= other.minY && this.minZ <= other.minZ && this.maxX >= other.maxX && this.maxY <= other.maxY && this.maxZ <= other.maxZ;
    }

    public boolean intersects(BoundingBox other) {
        return other.maxX > this.minX && other.minX < this.maxX ? (other.maxY > this.minY && other.minY < this.maxY ? other.maxZ > this.minZ && other.minZ < this.maxZ : false) : false;
    }

    public boolean isValid() {
        return this.minX < this.maxX && this.minY < this.maxY && this.minZ < this.maxZ;
    }

    public BoundingBox scale(double x, double y, double z) {
        return this.scale((float)x, (float)y, (float)z);
    }

    public BoundingBox scale(float x, float y, float z) {
        x = 1.0f - x;
        y = 1.0f - y;
        z = 1.0f - z;
        float w = (this.maxX - this.minX) * x / 2.0f;
        float h = (this.maxY - this.minY) * y / 2.0f;
        float d = (this.maxZ - this.minZ) * z / 2.0f;
        return new BoundingBox(this.minX + w, this.minY + h, this.minZ + d, this.maxX - w, this.maxY - h, this.maxZ - d);
    }

    public BoundingBox translate(float x, float y, float z) {
        return new BoundingBox(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public BoundingBox translate(Vector3d translation) {
        return this.translate((float)translation.x, (float)translation.y, (float)translation.z);
    }

    public BoundingBox translate(Vector3f vec) {
        return this.translate(vec.x, vec.y, vec.z);
    }

    public List<Vertex> getCornersWithUvForFace(EnumFacing face) {
        return this.getCornersWithUvForFace(face, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public List<Vertex> getCornersWithUvForFace(EnumFacing face, float minU, float maxU, float minV, float maxV) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.minZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.minX, this.maxY, this.maxZ), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            default: {
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.minZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.maxX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.minX, this.minY, this.maxZ), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, minV)));
            }
        }
        return result;
    }

    public List<Vector3f> getCornersForFace(EnumFacing face) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                break;
            }
            case SOUTH: {
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                break;
            }
            case EAST: {
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                break;
            }
            case WEST: {
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
                break;
            }
            case UP: {
                result.add(new Vector3f(this.maxX, this.maxY, this.maxZ));
                result.add(new Vector3f(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3f(this.minX, this.maxY, this.minZ));
                result.add(new Vector3f(this.minX, this.maxY, this.maxZ));
                break;
            }
            default: {
                result.add(new Vector3f(this.minX, this.minY, this.maxZ));
                result.add(new Vector3f(this.minX, this.minY, this.minZ));
                result.add(new Vector3f(this.maxX, this.minY, this.minZ));
                result.add(new Vector3f(this.maxX, this.minY, this.maxZ));
            }
        }
        return result;
    }

    public List<Vector3d> getCornersForFaceD(EnumFacing face) {
        ArrayList<Vector3d> result = new ArrayList<Vector3d>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3d(this.minX, this.maxY, this.minZ));
                result.add(new Vector3d(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3d(this.maxX, this.minY, this.minZ));
                result.add(new Vector3d(this.minX, this.minY, this.minZ));
                break;
            }
            case SOUTH: {
                result.add(new Vector3d(this.minX, this.maxY, this.maxZ));
                result.add(new Vector3d(this.minX, this.minY, this.maxZ));
                result.add(new Vector3d(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3d(this.maxX, this.maxY, this.maxZ));
                break;
            }
            case EAST: {
                result.add(new Vector3d(this.maxX, this.minY, this.maxZ));
                result.add(new Vector3d(this.maxX, this.minY, this.minZ));
                result.add(new Vector3d(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3d(this.maxX, this.maxY, this.maxZ));
                break;
            }
            case WEST: {
                result.add(new Vector3d(this.minX, this.maxY, this.maxZ));
                result.add(new Vector3d(this.minX, this.maxY, this.minZ));
                result.add(new Vector3d(this.minX, this.minY, this.minZ));
                result.add(new Vector3d(this.minX, this.minY, this.maxZ));
                break;
            }
            case UP: {
                result.add(new Vector3d(this.maxX, this.maxY, this.maxZ));
                result.add(new Vector3d(this.maxX, this.maxY, this.minZ));
                result.add(new Vector3d(this.minX, this.maxY, this.minZ));
                result.add(new Vector3d(this.minX, this.maxY, this.maxZ));
                break;
            }
            default: {
                result.add(new Vector3d(this.minX, this.minY, this.maxZ));
                result.add(new Vector3d(this.minX, this.minY, this.minZ));
                result.add(new Vector3d(this.maxX, this.minY, this.minZ));
                result.add(new Vector3d(this.maxX, this.minY, this.maxZ));
            }
        }
        return result;
    }

    public Vector3d getCenter() {
        return new Vector3d(this.minX + (this.maxX - this.minX) / 2.0f, this.minY + (this.maxY - this.minY) / 2.0f, this.minZ + (this.maxZ - this.minZ) / 2.0f);
    }

    public float sizeX() {
        return Math.abs(this.maxX - this.minX);
    }

    public float sizeY() {
        return Math.abs(this.maxY - this.minY);
    }

    public float sizeZ() {
        return Math.abs(this.maxZ - this.minZ);
    }

    public Vector3d getMin() {
        return new Vector3d(this.minX, this.minY, this.minZ);
    }

    public Vector3d getMax() {
        return new Vector3d(this.maxX, this.maxY, this.maxZ);
    }

    public float getArea() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    public String toString() {
        return "BoundingBox [minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "]";
    }

    public BoundingBox fixMinMax() {
        float mnX = this.minX;
        float mnY = this.minY;
        float mnZ = this.minZ;
        float mxX = this.maxX;
        float mxY = this.maxY;
        float mxZ = this.maxZ;
        boolean mod = false;
        if (this.minX > this.maxX) {
            mnX = this.maxX;
            mxX = this.minX;
            mod = true;
        }
        if (this.minY > this.maxY) {
            mnY = this.maxY;
            mxY = this.minY;
            mod = true;
        }
        if (this.minZ > this.maxZ) {
            mnZ = this.maxZ;
            mxZ = this.minZ;
            mod = true;
        }
        if (!mod) {
            return this;
        }
        return new BoundingBox(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    public AxisAlignedBB getAxisAlignedBB() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.maxX);
        result = 31 * result + Float.floatToIntBits(this.maxY);
        result = 31 * result + Float.floatToIntBits(this.maxZ);
        result = 31 * result + Float.floatToIntBits(this.minX);
        result = 31 * result + Float.floatToIntBits(this.minY);
        result = 31 * result + Float.floatToIntBits(this.minZ);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Float.floatToIntBits(this.maxX) != Float.floatToIntBits(other.maxX)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxY) != Float.floatToIntBits(other.maxY)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxZ) != Float.floatToIntBits(other.maxZ)) {
            return false;
        }
        if (Float.floatToIntBits(this.minX) != Float.floatToIntBits(other.minX)) {
            return false;
        }
        if (Float.floatToIntBits(this.minY) != Float.floatToIntBits(other.minY)) {
            return false;
        }
        return Float.floatToIntBits(this.minZ) == Float.floatToIntBits(other.minZ);
    }

    public BoundingBox transform(VertexTransform vertexTransform) {
        Vector3d min = new Vector3d(this.minX, this.minY, this.minZ);
        Vector3d max = new Vector3d(this.maxX, this.maxY, this.maxZ);
        vertexTransform.apply(min);
        vertexTransform.apply(max);
        return new BoundingBox(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }
}

