/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.IHideable;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.EnderWidget;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class VScrollbar
implements IHideable {
    protected final IGuiScreen gui;
    protected int xOrigin;
    protected int yOrigin;
    protected int height;
    protected int x;
    protected int y;
    protected Rectangle wholeArea;
    protected Rectangle btnUp;
    protected Rectangle btnDown;
    protected Rectangle thumbArea;
    protected int scrollPos;
    protected int scrollMax;
    protected boolean pressedUp;
    protected boolean pressedDown;
    protected boolean pressedThumb;
    protected int scrollDir;
    protected long timeNextScroll;
    protected boolean visible = true;

    public VScrollbar(IGuiScreen gui, int xOrigin, int yOrigin, int height) {
        this.gui = gui;
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        this.height = height;
    }

    public void adjustPosition() {
        this.x = this.xOrigin + this.gui.getGuiLeft();
        this.y = this.yOrigin + this.gui.getGuiTop();
        this.wholeArea = new Rectangle(this.x, this.y, EnderWidget.VSCROLL_THUMB_OFF.width, this.height);
        this.btnUp = new Rectangle(this.x, this.y, EnderWidget.UP_ARROW_OFF.width, EnderWidget.UP_ARROW_OFF.height);
        this.btnDown = new Rectangle(this.x, this.y + Math.max(0, this.height - EnderWidget.DOWN_ARROW_OFF.height), EnderWidget.DOWN_ARROW_OFF.width, EnderWidget.DOWN_ARROW_OFF.height);
        this.thumbArea = new Rectangle(this.x, this.y + this.btnUp.height, EnderWidget.VSCROLL_THUMB_OFF.width, Math.max(0, this.height - (this.btnUp.height + this.btnDown.height)));
    }

    public int getScrollPos() {
        return this.scrollPos;
    }

    public void setScrollPos(int scrollPos) {
        this.scrollPos = this.limitPos(scrollPos);
    }

    public void scrollBy(int amount) {
        this.setScrollPos(this.scrollPos + amount);
    }

    public int getScrollMax() {
        return this.scrollMax;
    }

    public void setScrollMax(int scrollMax) {
        this.scrollMax = scrollMax;
        this.setScrollPos(this.scrollPos);
    }

    public void drawScrollbar(int mouseX, int mouseY) {
        if (this.visible) {
            long time;
            EnderWidget iconDown;
            EnderWidget iconUp;
            boolean hoverUp = this.btnUp.contains(mouseX, mouseY);
            boolean hoverDown = this.btnDown.contains(mouseX, mouseY);
            if (this.pressedUp) {
                iconUp = hoverUp ? EnderWidget.UP_ARROW_HOVER_ON : EnderWidget.UP_ARROW_ON;
            } else {
                EnderWidget enderWidget = iconUp = hoverUp ? EnderWidget.UP_ARROW_HOVER_OFF : EnderWidget.UP_ARROW_OFF;
            }
            if (this.pressedDown) {
                iconDown = hoverDown ? EnderWidget.DOWN_ARROW_HOVER_ON : EnderWidget.DOWN_ARROW_ON;
            } else {
                EnderWidget enderWidget = iconDown = hoverDown ? EnderWidget.DOWN_ARROW_HOVER_OFF : EnderWidget.DOWN_ARROW_OFF;
            }
            if (this.scrollDir != 0 && this.timeNextScroll - (time = Minecraft.func_71386_F()) <= 0L) {
                this.timeNextScroll = time + 100L;
                this.scrollBy(this.scrollDir);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EnderWidget.TEXTURE);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            WorldRenderer renderer = Tessellator.func_178181_a().func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            iconUp.getMap().render(iconUp, this.btnUp.x, this.btnUp.y, false);
            iconDown.getMap().render(iconDown, this.btnDown.x, this.btnDown.y, false);
            if (this.getScrollMax() > 0) {
                boolean hoverThumb;
                int thumbPos = this.getThumbPosition();
                boolean bl = hoverThumb = this.thumbArea.contains(mouseX, mouseY) && mouseY >= thumbPos && mouseY < thumbPos + EnderWidget.VSCROLL_THUMB_OFF.height;
                EnderWidget iconThumb = this.pressedThumb ? EnderWidget.VSCROLL_THUMB_HOVER_ON : (hoverThumb ? EnderWidget.VSCROLL_THUMB_HOVER_OFF : EnderWidget.VSCROLL_THUMB_OFF);
                iconThumb.getMap().render((IWidgetIcon)iconThumb, (double)this.thumbArea.x, (double)thumbPos, 100.0, false);
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPopAttrib();
        }
    }

    public boolean mouseClicked(int x, int y, int button) {
        if (button == 0) {
            if (this.getScrollMax() > 0 && this.thumbArea.contains(x, y)) {
                int thumbPos = this.getThumbPosition();
                this.pressedUp = y < thumbPos;
                this.pressedDown = y >= thumbPos + EnderWidget.VSCROLL_THUMB_OFF.height;
                this.pressedThumb = !this.pressedUp && !this.pressedDown;
            } else {
                this.pressedUp = this.btnUp.contains(x, y);
                this.pressedDown = this.btnDown.contains(x, y);
                this.pressedThumb = false;
            }
            this.scrollDir = (this.pressedDown ? 1 : 0) - (this.pressedUp ? 1 : 0);
            if (this.scrollDir != 0) {
                this.timeNextScroll = Minecraft.func_71386_F() + 200L;
                this.scrollBy(this.scrollDir);
            }
        }
        return this.isDragActive();
    }

    public boolean mouseClickMove(int x, int y, int button, long time) {
        if (this.pressedThumb) {
            int pos = y - (this.thumbArea.y + EnderWidget.VSCROLL_THUMB_OFF.height / 2);
            int len = this.thumbArea.height - EnderWidget.VSCROLL_THUMB_OFF.height;
            if (len > 0) {
                this.setScrollPos(Math.round((float)pos * (float)this.getScrollMax() / (float)len));
            }
            return true;
        }
        return false;
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        this.pressedUp = false;
        this.pressedDown = false;
        this.pressedThumb = false;
        this.scrollDir = 0;
    }

    public void mouseWheel(int x, int y, int delta) {
        if (!this.isDragActive()) {
            this.scrollBy(-Integer.signum(delta));
        }
    }

    public boolean isDragActive() {
        return this.pressedUp || this.pressedDown || this.pressedThumb;
    }

    protected int getThumbPosition() {
        return this.thumbArea.y + (this.thumbArea.height - EnderWidget.VSCROLL_THUMB_OFF.height) * this.scrollPos / this.getScrollMax();
    }

    protected int limitPos(int pos) {
        return Math.max(0, Math.min(pos, this.getScrollMax()));
    }

    @Override
    public void setIsVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

