/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.GuiButtonHideable;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.EnderWidget;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class IconButton
extends GuiButtonHideable {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    protected IWidgetIcon icon;
    private int xOrigin;
    private int yOrigin;
    protected IGuiScreen gui;
    protected String[] toolTipText;
    private GuiToolTip toolTip;
    private int marginY = 0;
    private int marginX = 0;

    public IconButton(IGuiScreen gui, int id, int x, int y, IWidgetIcon icon) {
        super(id, x, y, 16, 16, "");
        this.gui = gui;
        this.icon = icon;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public void setToolTip(String ... tooltipText) {
        if (this.toolTip == null) {
            this.toolTip = new GuiToolTip(this.getBounds(), tooltipText);
        } else {
            this.toolTip.setToolTipText(tooltipText);
        }
        this.toolTipText = tooltipText;
    }

    protected void setToolTip(GuiToolTip newToolTip) {
        boolean addTooltip = false;
        if (this.toolTip != null) {
            addTooltip = this.gui.removeToolTip(this.toolTip);
        }
        this.toolTip = newToolTip;
        if (addTooltip && this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.xOrigin, this.yOrigin, this.getWidth(), this.getHeight());
    }

    public void onGuiInit() {
        this.gui.addButton(this);
        if (this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.field_146128_h = this.xOrigin + this.gui.getGuiLeft();
        this.field_146129_i = this.yOrigin + this.gui.getGuiTop();
    }

    public void detach() {
        this.gui.removeToolTip(this.toolTip);
        this.gui.removeButton(this);
    }

    public void setSize(int width, int height) {
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.updateTooltipBounds();
    }

    public IconButton setPosition(int x, int y) {
        this.xOrigin = x;
        this.yOrigin = y;
        this.updateTooltipBounds();
        return this;
    }

    private void updateTooltipBounds() {
        if (this.toolTip != null) {
            this.toolTip.setBounds(new Rectangle(this.xOrigin, this.yOrigin, this.field_146120_f, this.field_146121_g));
        }
    }

    public IconButton setIconMargin(int x, int y) {
        this.marginX = x;
        this.marginY = y;
        return this;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    public IWidgetIcon getIcon() {
        return this.icon;
    }

    public void setIcon(IWidgetIcon icon) {
        this.icon = icon;
    }

    public GuiToolTip getToolTip() {
        return this.toolTip;
    }

    public void setXOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public void setYOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    public boolean mousePressedButton(Minecraft mc, int x, int y, int button) {
        return false;
    }

    protected boolean checkMousePress(Minecraft mc, int x, int y) {
        return super.func_146116_c(mc, x, y);
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.toolTip != null) {
            this.toolTip.setIsVisible(this.isVisible());
        }
        if (this.isVisible()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int hoverState = this.func_146114_a(this.field_146123_n);
            this.func_146119_b(mc, mouseX, mouseY);
            IWidgetIcon background = this.getIconForHoverState(hoverState);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int x = this.field_146128_h;
            int y = this.field_146129_i;
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            background.getMap().render(background, x, y, this.field_146120_f, this.field_146121_g, 0.0, true);
            if (this.icon != null) {
                this.icon.getMap().render(this.icon, x + this.marginX, y + this.marginY, this.field_146120_f - 2 * this.marginX, this.field_146121_g - 2 * this.marginY, 0.0, true);
            }
            GL11.glPopAttrib();
        }
    }

    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (hoverState == 0) {
            return EnderWidget.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return EnderWidget.BUTTON_HIGHLIGHT;
        }
        return EnderWidget.BUTTON;
    }
}

