/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.common.util.ManeuverGearHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGrapplingHook
implements IMessage {
    int dimension;
    int entityID;
    ManeuverGearHelper.ManeuverGearOperator operator;

    public MessageGrapplingHook(EntityPlayer player, ManeuverGearHelper.ManeuverGearOperator operator) {
        this.dimension = player.field_70170_p.field_73011_w.func_177502_q();
        this.entityID = player.func_145782_y();
        this.operator = operator;
    }

    public MessageGrapplingHook() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.entityID = buf.readInt();
        this.operator = ManeuverGearHelper.ManeuverGearOperator.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.entityID);
        buf.writeInt(this.operator.ordinal());
    }

    public static class Handler
    implements IMessageHandler<MessageGrapplingHook, IMessage> {
        public IMessage onMessage(MessageGrapplingHook message, MessageContext ctx) {
            Entity entity;
            WorldServer world = DimensionManager.getWorld((int)message.dimension);
            if (world != null && (entity = world.func_73045_a(message.entityID)) != null && entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                switch (message.operator) {
                    case PRESS_0: {
                        ManeuverGearHelper.pressHookButton(player, 0);
                        break;
                    }
                    case PRESS_1: {
                        ManeuverGearHelper.pressHookButton(player, 1);
                        break;
                    }
                    case RELEASE_0: {
                        ManeuverGearHelper.releaseHookButton(player, 0);
                        break;
                    }
                    case RELEASE_1: {
                        ManeuverGearHelper.releaseHookButton(player, 1);
                        break;
                    }
                    case RETRACT_0: {
                        ManeuverGearHelper.returnHook(player, 0);
                        break;
                    }
                    case RETRACT_1: {
                        ManeuverGearHelper.returnHook(player, 1);
                        break;
                    }
                    case RETRACT_ALL: {
                        ManeuverGearHelper.returnHook(player, 0);
                        ManeuverGearHelper.returnHook(player, 1);
                        break;
                    }
                    case PRESS_SPACE: {
                        ManeuverGearHelper.doGasJump(player);
                        break;
                    }
                }
            }
            return null;
        }
    }
}

