/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PeripheralRefinery
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getInputFluidTanks", "getOutputTank", "getRecipe", "setEnabled", "isValidRecipe", "getEmptyCannisters", "getFullCannisters", "getMaxEnergyStored", "getEnergyStored", "isActive"};

    public PeripheralRefinery(World w, BlockPos pos) {
        super(w, pos);
    }

    public String getType() {
        return "IE:refinery";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityRefinery te = this.getTileEntity(TileEntityRefinery.class);
        if (te == null) {
            throw new LuaException("The refinery was removed");
        }
        switch (method) {
            case 0: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(2);
                ret.put("input1", Utils.saveFluidTank(te.tanks[0]));
                ret.put("input2", Utils.saveFluidTank(te.tanks[1]));
                return new Object[]{ret};
            }
            case 1: {
                return new Object[]{Utils.saveFluidTank(te.tanks[2])};
            }
            case 2: {
                RefineryRecipe ref = RefineryRecipe.findRecipe(te.tanks[0].getFluid(), te.tanks[1].getFluid());
                if (ref == null) {
                    throw new LuaException("The recipe of the refinery is invalid");
                }
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveFluidStack(ref.input0));
                ret.put("input2", Utils.saveFluidStack(ref.input1));
                ret.put("output", Utils.saveFluidStack(ref.output));
                return new Object[]{ret};
            }
            case 3: {
                boolean param;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = param = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
            case 4: {
                return new Object[]{RefineryRecipe.findRecipe(te.tanks[0].getFluid(), te.tanks[1].getFluid()) != null};
            }
            case 5: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveStack(te.inventory[1]));
                ret.put("input2", Utils.saveStack(te.inventory[3]));
                ret.put("output", Utils.saveStack(te.inventory[4]));
                return new Object[]{ret};
            }
            case 6: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveStack(te.inventory[0]));
                ret.put("input2", Utils.saveStack(te.inventory[2]));
                ret.put("output", Utils.saveStack(te.inventory[5]));
                return new Object[]{ret};
            }
            case 7: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 8: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
            case 9: {
                return new Object[]{te.shouldRenderAsActive()};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityRefinery te = (TileEntityRefinery)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        ++te.controllingComputers;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityRefinery te = (TileEntityRefinery)this.w.func_175625_s(this.pos);
        if (te == null) {
            return;
        }
        --te.controllingComputers;
    }
}

