/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static Method m_getHarvestLevel = null;

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = Utils.copyStackWithAmount(stack, 1);
        List s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!ItemStack.func_77989_b((ItemStack)comp, (ItemStack)st)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return Utils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).func_77952_i() == Short.MAX_VALUE || ItemStack.func_77970_a((ItemStack)((ItemStack)o), (ItemStack)stack));
        }
        if (o instanceof ArrayList) {
            for (Object io : (ArrayList)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).func_77952_i() != Short.MAX_VALUE && !ItemStack.func_77970_a((ItemStack)((ItemStack)io), (ItemStack)stack)) continue;
                return true;
            }
        } else if (o instanceof ItemStack[]) {
            for (ItemStack io : (ItemStack[])o) {
                if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.func_77952_i() != Short.MAX_VALUE && !ItemStack.func_77970_a((ItemStack)io, (ItemStack)stack)) continue;
                return true;
            }
        } else if (o instanceof String) {
            return Utils.compareToOreName(stack, (String)o);
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = amount;
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return stack.func_77952_i();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return true;
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return true;
        }
        return false;
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.tag != null && fs.tag.func_74764_b("pressurized")) {
            fs.tag.func_82580_o("pressurized");
            if (fs.tag.func_82582_d()) {
                fs.tag = null;
            }
        }
        return fs;
    }

    public static BlockPos toCC(Object object) {
        return ApiUtils.toBlockPos(object);
    }

    public static DirectionalBlockPos toDirCC(Object object, EnumFacing direction) {
        if (object instanceof BlockPos) {
            return new DirectionalBlockPos((BlockPos)object, direction);
        }
        if (object instanceof TileEntity) {
            return new DirectionalBlockPos(((TileEntity)object).func_174877_v(), direction);
        }
        return null;
    }

    public static boolean isBlockAt(World world, BlockPos pos, Block b, int meta) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().equals(b)) {
            return meta < 0 || meta == Short.MAX_VALUE || state.func_177230_c().func_176201_c(state) == meta;
        }
        return false;
    }

    public static boolean isOreBlockAt(World world, BlockPos pos, String oreName) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return Utils.compareToOreName(stack, oreName);
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))));
    }

    public static String getModVersion(String modid) {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equalsIgnoreCase(modid)) continue;
            return container.getVersion();
        }
        return "";
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.func_174877_v().equals((Object)tile1.func_174877_v());
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.field_70127_C + (living.field_70125_A - living.field_70127_C) * f;
        float f2 = living.field_70126_B + (living.field_70177_z - living.field_70126_B) * f;
        double d0 = living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)f;
        double d1 = living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)f + (double)(world.field_72995_K ? living.func_70047_e() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.func_70047_e());
        double d2 = living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)f;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, BlockPos cc0, BlockPos cc1, Vec3 pos0, Vec3 pos1) {
        HashSet<BlockPos> inter = Utils.rayTrace(pos0, pos1, world);
        for (BlockPos cc : inter) {
            if (cc.equals((Object)cc0) || cc.equals((Object)cc1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static Vec3 getFlowVector(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockFluidBase) {
            return ((BlockFluidBase)world.func_180495_p(pos).func_177230_c()).getFlowVector((IBlockAccess)world, pos);
        }
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid)) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        BlockLiquid block = (BlockLiquid)world.func_180495_p(pos).func_177230_c();
        Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
        Material mat = block.func_149688_o();
        int i = Utils.getEffectiveFlowDecay((IBlockAccess)world, pos, mat);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            int j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos, mat);
            if (j < 0) {
                if (world.func_180495_p(blockpos).func_177230_c().func_149688_o().func_76230_c() || (j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos.func_177977_b(), mat)) < 0) continue;
                int k = j - (i - 8);
                vec3 = vec3.func_72441_c((double)((blockpos.func_177958_n() - pos.func_177958_n()) * k), (double)((blockpos.func_177956_o() - pos.func_177956_o()) * k), (double)((blockpos.func_177952_p() - pos.func_177952_p()) * k));
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            vec3 = vec3.func_72441_c((double)((blockpos.func_177958_n() - pos.func_177958_n()) * l), (double)((blockpos.func_177956_o() - pos.func_177956_o()) * l), (double)((blockpos.func_177952_p() - pos.func_177952_p()) * l));
        }
        if ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockLiquid.field_176367_b) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos1 = pos.func_177972_a(enumfacing1);
                if (!block.func_176212_b((IBlockAccess)world, blockpos1, enumfacing1) && !block.func_176212_b((IBlockAccess)world, blockpos1.func_177984_a(), enumfacing1)) continue;
                vec3 = vec3.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.func_72432_b();
    }

    static int getEffectiveFlowDecay(IBlockAccess world, BlockPos pos, Material mat) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_149688_o() != mat) {
            return -1;
        }
        int l = state.func_177230_c().func_176201_c(state);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3 addVectors(Vec3 vec0, Vec3 vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static boolean isVecInEntityHead(EntityLivingBase entity, Vec3 vec) {
        if (entity.field_70131_O / entity.field_70130_N < 2.0f) {
            return false;
        }
        double d = vec.field_72448_b - (entity.field_70163_u + (double)entity.func_70047_e());
        return Math.abs(d) < 0.25;
    }

    public static NBTTagCompound getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = ItemDye.field_150922_c[j];
        }
        expl.func_74783_a("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.func_74774_a("Type", (byte)type);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)expl);
        tag.func_74782_a("Explosions", (NBTBase)list);
        return tag;
    }

    public static FluidStack drainFluidBlock(World world, BlockPos pos, boolean doDrain) {
        Block b = world.func_180495_p(pos).func_177230_c();
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (b instanceof IFluidBlock) {
                if (((IFluidBlock)b).canDrain(world, pos)) {
                    return ((IFluidBlock)b).drain(world, pos, doDrain);
                }
                return null;
            }
            if (b.func_176201_c(world.func_180495_p(pos)) == 0) {
                if (doDrain) {
                    world.func_175698_g(pos);
                }
                return new FluidStack(f, 1000);
            }
            return null;
        }
        return null;
    }

    public static Fluid getRelatedFluid(World w, BlockPos pos) {
        Block b = w.func_180495_p(pos).func_177230_c();
        return FluidRegistry.lookupFluidForBlock((Block)b);
    }

    public static boolean placeFluidBlock(World world, BlockPos pos, FluidStack fluid) {
        boolean canPlace;
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        Block fluidBlock = fluid.getFluid().getBlock();
        if (Blocks.field_150355_j.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150358_i;
        } else if (Blocks.field_150353_l.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150356_k;
        }
        boolean bl = canPlace = b == null || b.isAir((IBlockAccess)world, pos) || b.func_176200_f(world, pos);
        if (fluidBlock != null && canPlace && fluid.amount >= 1000) {
            boolean placed = false;
            if (fluidBlock instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)fluidBlock;
                placed = world.func_175656_a(pos, fluidBlock.func_176203_a(blockFluid.getMaxRenderHeightMeta()));
            } else {
                placed = world.func_175656_a(pos, fluidBlock.func_176223_P());
            }
            if (placed) {
                fluid.amount -= 1000;
            }
            return placed;
        }
        return false;
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.fluid.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer);
        }
        return containers;
    }

    public static IBlockState getStateFromItemStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        Block block = Utils.getBlockFromItem(stack.func_77973_b());
        if (block != null) {
            return block.func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    public static Block getBlockFromItem(Item item) {
        if (item == Items.field_151066_bu) {
            return Blocks.field_150383_bp;
        }
        return Block.func_149634_a((Item)item);
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        return stack != null && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.func_77946_l(), (boolean)true)) == null || temp.field_77994_a < stack.field_77994_a);
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        if (stack != null && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.func_77946_l(), (boolean)true)) == null || temp.field_77994_a < stack.field_77994_a)) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side, boolean simulate) {
        if (inventory != null && stack != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        if (stack != null) {
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
            ei.field_70181_x = 0.025000000372529;
            if (facing != null) {
                ei.field_70159_w = 0.075f * (float)facing.func_82601_c();
                ei.field_70179_y = 0.075f * (float)facing.func_82599_e();
            }
            world.func_72838_d((Entity)ei);
        }
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos, stack, null);
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, Utils.copyStackWithAmount(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - existingStack.field_77994_a;
            existingStack.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack fillFluidContainer(FluidTank tank, ItemStack containerIn, ItemStack containerOut) {
        if (tank.getFluidAmount() > 0 && containerIn != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)containerIn)) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)containerIn);
                if (filledContainer != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
                    if (fs.amount <= tank.getFluidAmount() && filledContainer.field_77994_a + (containerOut != null ? containerOut.field_77994_a : 0) <= filledContainer.func_77976_d() && (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true))) {
                        tank.drain(fs.amount, true);
                        return filledContainer;
                    }
                }
            } else if (containerIn.func_77973_b() instanceof IFluidContainerItem) {
                int space;
                IFluidContainerItem iContainer = (IFluidContainerItem)containerIn.func_77973_b();
                int available = tank.getFluidAmount();
                if (available >= (space = iContainer.getCapacity(containerIn) - (iContainer.getFluid(containerIn) == null ? 0 : iContainer.getFluid((ItemStack)containerIn).amount)) && iContainer.fill(containerIn, tank.getFluid(), false) == space) {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.func_77970_a((ItemStack)filledContainer, (ItemStack)containerOut) && containerOut.field_77994_a < containerOut.func_77976_d()) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                } else if (containerIn.field_77994_a == 1) {
                    int filled = iContainer.fill(containerIn, tank.getFluid(), true);
                    tank.drain(filled, true);
                } else {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.func_77970_a((ItemStack)filledContainer, (ItemStack)containerOut) && containerOut.field_77994_a < containerOut.func_77976_d()) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack drainFluidContainer(FluidTank tank, ItemStack containerIn) {
        ItemStack emptyContainer;
        FluidStack fs;
        if (containerIn != null && FluidContainerRegistry.isFilledContainer((ItemStack)containerIn) && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)containerIn)) != null && tank.getFluidAmount() + fs.amount <= tank.getCapacity() && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)containerIn)) != null && tank.fill(fs, true) == fs.amount) {
            return emptyContainer;
        }
        return null;
    }

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fluid != null) {
            return fluid;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        }
        return null;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return FluidContainerRegistry.isContainer((ItemStack)stack) || stack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static boolean fillPlayerItemFromFluidHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        IFluidContainerItem container;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)equipped)) {
            ItemStack filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)equipped);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledStack);
            if (fluid == null || filledStack == null) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (equipped.field_77994_a == 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledStack);
                    --equipped.field_77994_a;
                    if (equipped.field_77994_a <= 0) {
                        equipped = null;
                    }
                } else {
                    --equipped.field_77994_a;
                    if (!player.field_71071_by.func_70441_a(filledStack)) {
                        player.func_146097_a(filledStack, false, true);
                    }
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
            }
            handler.drain(null, fluid.amount, true);
            return true;
        }
        if (equipped.func_77973_b() instanceof IFluidContainerItem && (container = (IFluidContainerItem)equipped.func_77973_b()).fill(equipped, tankFluid, false) > 0) {
            int fill;
            if (world.field_72995_K) {
                return true;
            }
            if (equipped.field_77994_a > 1) {
                ItemStack filled = Utils.copyStackWithAmount(equipped, 1);
                --equipped.field_77994_a;
                fill = container.fill(filled, tankFluid, true);
                if (!player.field_71071_by.func_70441_a(filled)) {
                    player.func_146097_a(filled, false, true);
                }
            } else {
                fill = container.fill(equipped, tankFluid, true);
            }
            handler.drain(null, fill, true);
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return true;
        }
        return false;
    }

    public static boolean fillFluidHandlerWithPlayerItem(World world, IFluidHandler handler, EntityPlayer player) {
        IFluidContainerItem container;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)equipped);
        if (fluid != null) {
            if (handler.fill(null, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d) {
                if (world.field_72995_K) {
                    return true;
                }
                ItemStack filledStack = FluidContainerRegistry.drainFluidContainer((ItemStack)equipped);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (equipped.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        player.field_71071_by.func_70441_a(filledStack);
                    } else {
                        --equipped.field_77994_a;
                        if (filledStack != null && !player.field_71071_by.func_70441_a(filledStack)) {
                            player.func_146097_a(filledStack, false, true);
                        }
                    }
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
                handler.fill(null, fluid, true);
                return true;
            }
        } else if (equipped.func_77973_b() instanceof IFluidContainerItem && (fluid = (container = (IFluidContainerItem)equipped.func_77973_b()).getFluid(equipped)) != null && handler.fill(null, fluid, false) > 0) {
            if (world.field_72995_K) {
                return true;
            }
            int fill = handler.fill(null, fluid, true);
            if (equipped.field_77994_a > 1) {
                ItemStack emptied = Utils.copyStackWithAmount(equipped, 1);
                --equipped.field_77994_a;
                container.drain(emptied, fill, true);
                if (!player.field_71071_by.func_70441_a(emptied)) {
                    player.func_146097_a(emptied, false, true);
                }
            } else {
                container.drain(equipped, fill, true);
            }
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return true;
        }
        return false;
    }

    public static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe irecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!irecipe.func_77569_a(crafting, world)) continue;
            return irecipe;
        }
        return null;
    }

    public static HashSet<BlockPos> rayTrace(Vec3 start, Vec3 end, World world) {
        Vec3 tmp;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        if (start.field_72450_a > end.field_72450_a) {
            Vec3 tmp2 = start;
            start = end;
            end = tmp2;
        }
        double min = start.field_72450_a;
        double dif = end.field_72450_a - min;
        double lengthAdd = Math.ceil(min) - start.field_72450_a;
        Vec3 mov = start.func_178788_d(end);
        if (mov.field_72450_a != 0.0) {
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72450_a);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150482_ag);
        }
        if (mov.field_72448_b != 0.0) {
            if (start.field_72448_b > end.field_72448_b) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72448_b;
            dif = end.field_72448_b - min;
            lengthAdd = Math.ceil(min) - start.field_72448_b;
            mov = start.func_178788_d(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72448_b);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150366_p);
        }
        if (mov.field_72449_c != 0.0) {
            if (start.field_72449_c > end.field_72449_c) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72449_c;
            dif = end.field_72449_c - min;
            lengthAdd = Math.ceil(min) - start.field_72449_c;
            mov = start.func_178788_d(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72449_c);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150352_o);
        }
        return ret;
    }

    private static void ray(double dif, Vec3 mov, Vec3 start, double lengthAdd, HashSet<BlockPos> ret, World world, HashSet<BlockPos> checked, Block tmp) {
        boolean place = false;
        double standartOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            Block b;
            IBlockState state;
            Vec3 pos = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd + standartOff));
            Vec3 posNext = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i + 1) + lengthAdd + standartOff));
            Vec3 posPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd - standartOff));
            Vec3 posVeryPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i - 1) + lengthAdd - standartOff));
            BlockPos blockPos = new BlockPos((int)Math.floor(pos.field_72450_a), (int)Math.floor(pos.field_72448_b), (int)Math.floor(pos.field_72449_c));
            if (!checked.contains(blockPos) && (double)i + lengthAdd + standartOff < dif) {
                state = world.func_180495_p(blockPos);
                b = state.func_177230_c();
                if (b.func_176209_a(state, false) && b.func_180636_a(world, blockPos, pos, posNext) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
            }
            if (!checked.contains(blockPos = new BlockPos((int)Math.floor(posPrev.field_72450_a), (int)Math.floor(posPrev.field_72448_b), (int)Math.floor(posPrev.field_72449_c))) && (double)i + lengthAdd - standartOff < dif) {
                state = world.func_180495_p(blockPos);
                b = state.func_177230_c();
                if (b.func_176209_a(state, false) && b.func_180636_a(world, blockPos, posVeryPrev, posPrev) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
            }
            ++i;
        }
    }

    public static Vec3 scalarProd(Vec3 v, double s) {
        return new Vec3(v.field_72450_a * s, v.field_72448_b * s, v.field_72449_c * s);
    }

    public static BlockPos rayTraceForFirst(Vec3 start, Vec3 end, World w, Set<BlockPos> ignore) {
        HashSet<BlockPos> trace = Utils.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.field_72450_a != end.field_72450_a) {
            trace = Utils.findMinOrMax(trace, start.field_72450_a > end.field_72450_a, 0);
        }
        if (start.field_72448_b != end.field_72448_b) {
            trace = Utils.findMinOrMax(trace, start.field_72448_b > end.field_72448_b, 0);
        }
        if (start.field_72449_c != end.field_72449_c) {
            trace = Utils.findMinOrMax(trace, start.field_72449_c > end.field_72449_c, 0);
        }
        if (trace.size() > 0) {
            BlockPos ret = trace.iterator().next();
            return ret;
        }
        return null;
    }

    public static HashSet<BlockPos> findMinOrMax(HashSet<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177956_o());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177952_p());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static TileEntity getExistingTileEntity(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static ItemStack[] readInventory(NBTTagList nbt, int size) {
        ItemStack[] inv = new ItemStack[size];
        int max = nbt.func_74745_c();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound itemTag = nbt.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= size) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        return inv;
    }

    public static NBTTagList writeInventory(ItemStack[] inv) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            inv[i].func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        return invList;
    }

    public static void modifyInvStackSize(ItemStack[] inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.length && inv[slot] != null) {
            inv[slot].field_77994_a += amount;
            if (inv[slot].field_77994_a <= 0) {
                inv[slot] = null;
            }
        }
    }

    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getInventory().length; ++j) {
            ItemStack itemstack = inv.getInventory()[j];
            if (itemstack == null) continue;
            f += (float)itemstack.field_77994_a / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getInventory().length) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static void generateChestContents(Random random, List<WeightedRandomChestContent> listIn, IIEInventory inv, int max) {
        for (int i = 0; i < max; ++i) {
            WeightedRandomChestContent weightedrandomchestcontent = (WeightedRandomChestContent)WeightedRandom.func_76271_a((Random)random, listIn);
            ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)weightedrandomchestcontent.field_76297_b, (int)weightedrandomchestcontent.field_76295_d, (int)weightedrandomchestcontent.field_76296_e);
            ItemStack[] inventory = inv.getInventory();
            ItemStack[] itemStackArray = stacks;
            int n = itemStackArray.length;
            for (int j = 0; j < n; ++j) {
                ItemStack stack;
                inventory[random.nextInt((int)inventory.length)] = stack = itemStackArray[j];
            }
        }
    }

    public static Map<String, Object> saveStack(ItemStack stack) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (stack != null && stack.func_77973_b() != null) {
            ret.put("size", stack.field_77994_a);
            ret.put("name", Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()));
            ret.put("nameUnlocalized", stack.func_77977_a());
            ret.put("label", stack.func_82833_r());
            ret.put("damage", stack.func_77952_i());
            ret.put("maxDamage", stack.func_77958_k());
            ret.put("maxSize", stack.func_77976_d());
            ret.put("hasTag", stack.func_77942_o());
        }
        return ret;
    }

    public static Map<String, Object> saveFluidTank(FluidTank tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getFluid().getUnlocalizedName());
            ret.put("amount", tank.getFluidAmount());
            ret.put("capacity", tank.getCapacity());
            ret.put("hasTag", tank.getFluid().tag != null);
        }
        return ret;
    }

    public static Map<String, Object> saveFluidStack(FluidStack tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getUnlocalizedName());
            ret.put("amount", tank.amount);
            ret.put("hasTag", tank.tag != null);
        }
        return ret;
    }

    public static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final Container nullContainer = new Container(){

            public void func_75130_a(IInventory paramIInventory) {
            }

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }
    }
}

