/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class RotationUtil {
    public static RotationType getRotationType(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null && state.func_177230_c() != null) {
            if (state.func_177230_c().equals(Blocks.field_150331_J) || state.func_177230_c().equals(Blocks.field_150320_F)) {
                return RotationType.SIXWAYS;
            }
            if (state.func_177230_c().equals(Blocks.field_150367_z) || state.func_177230_c().equals(Blocks.field_150409_cd)) {
                return RotationType.SIXWAYS;
            }
            if (state.func_177230_c() instanceof BlockDirectional && !state.func_177230_c().equals(Blocks.field_150324_C) && !state.func_177230_c().equals(Blocks.field_150375_by)) {
                return RotationType.DIRECTIONAL;
            }
            if (state.func_177230_c().equals(Blocks.field_150460_al) || state.func_177230_c().equals(Blocks.field_150470_am) || state.func_177230_c().equals(Blocks.field_150477_bB)) {
                return RotationType.HORIZONTAL;
            }
            if (state.func_177230_c() instanceof BlockStairs) {
                return RotationType.STAIRS;
            }
            if (state.func_177230_c() instanceof BlockRail) {
                return RotationType.RAIL;
            }
            if (state.func_177230_c().equals(Blocks.field_150486_ae) || state.func_177230_c().equals(Blocks.field_150447_bR)) {
                return RotationType.CHEST;
            }
            if (state.func_177230_c().equals(Blocks.field_150472_an)) {
                return RotationType.SIGN;
            }
        }
        return null;
    }

    public static boolean rotateBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        RotationType type = RotationUtil.getRotationType(world, pos);
        if (type == null) {
            return false;
        }
        PropertyDirection propDir = null;
        EnumFacing facing = null;
        switch (type) {
            case SIXWAYS: {
                EnumFacing fNew;
                for (IProperty prop : state.func_177227_a()) {
                    if (!(prop instanceof PropertyDirection)) continue;
                    propDir = (PropertyDirection)prop;
                    break;
                }
                if (propDir == null || (fNew = (facing = (EnumFacing)state.func_177229_b(propDir)).func_176732_a(side.func_176740_k())) == facing) break;
                if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE | player.func_70093_af()) {
                    fNew = fNew.func_176734_d();
                }
                state = state.func_177226_a((IProperty)propDir, (Comparable)fNew);
                world.func_175656_a(pos, state);
                return true;
            }
            case DIRECTIONAL: {
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
                state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)(player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e()));
                world.func_175656_a(pos, state);
                return true;
            }
            case HORIZONTAL: {
                for (IProperty prop : state.func_177227_a()) {
                    if (!(prop instanceof PropertyDirection)) continue;
                    propDir = (PropertyDirection)prop;
                    break;
                }
                if (propDir == null) break;
                facing = (EnumFacing)state.func_177229_b(propDir);
                state = state.func_177226_a((IProperty)propDir, (Comparable)(player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e()));
                world.func_175656_a(pos, state);
                return true;
            }
            case STAIRS: {
                for (IProperty prop : state.func_177227_a()) {
                    if (!(prop instanceof PropertyDirection)) continue;
                    propDir = (PropertyDirection)prop;
                    break;
                }
                if (propDir == null) break;
                facing = (EnumFacing)state.func_177229_b(propDir);
                state = state.func_177226_a((IProperty)propDir, (Comparable)(player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e()));
                world.func_175656_a(pos, state);
                return true;
            }
            case RAIL: {
                BlockRailBase.EnumRailDirection railDir;
                BlockRailBase.EnumRailDirection newRailDir = railDir = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)BlockRail.field_176565_b);
                if (railDir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                    newRailDir = BlockRailBase.EnumRailDirection.EAST_WEST;
                }
                if (railDir == BlockRailBase.EnumRailDirection.EAST_WEST) {
                    newRailDir = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                }
                if (newRailDir == railDir) break;
                state = state.func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)newRailDir);
                world.func_175656_a(pos, state);
                return true;
            }
            case CHEST: {
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a);
                for (EnumFacing offset : EnumFacing.field_176754_o) {
                    if (world.func_180495_p(pos.func_177972_a(offset)).func_177230_c() != state.func_177230_c()) continue;
                    state = state.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176734_d());
                    world.func_175656_a(pos, state);
                    world.func_175656_a(pos.func_177972_a(offset), state);
                    return true;
                }
                state = state.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)(player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e()));
                world.func_175656_a(pos, state);
                return true;
            }
            case SIGN: {
                int signRotation = (Integer)state.func_177229_b((IProperty)BlockStandingSign.field_176413_a);
                signRotation = (Integer)state.func_177229_b((IProperty)BlockStandingSign.field_176413_a) + (player.func_70093_af() ? 15 : 1);
                state = state.func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(signRotation % 16));
                world.func_175656_a(pos, state);
                return true;
            }
        }
        return false;
    }

    public static boolean rotateEntity(Entity entity, EntityPlayer player) {
        if (entity instanceof EntityArmorStand) {
            // empty if block
        }
        return false;
    }

    public static enum RotationType {
        SIXWAYS,
        DIRECTIONAL,
        HORIZONTAL,
        STAIRS,
        RAIL,
        CHEST,
        SIGN;

    }
}

