/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class ItemWireCoil
extends ItemIEBase
implements IWireCoil {
    public ItemWireCoil() {
        super("wirecoil", 64, "copper", "electrum", "hv", "rope", "structural");
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        switch (stack.func_77952_i()) {
            default: {
                return WireType.COPPER;
            }
            case 1: {
                return WireType.ELECTRUM;
            }
            case 2: {
                return WireType.STEEL;
            }
            case 3: {
                return WireType.STRUCTURE_ROPE;
            }
            case 4: 
        }
        return WireType.STRUCTURE_STEEL;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (stack.func_77952_i() > 2) {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.coil.construction0"));
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.coil.construction1"));
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            WireType wire = this.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
            if (!((tileEntity = world.func_175625_s(masterPos)) instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return false;
            }
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(wire, target)) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongCable", new Object[0]));
                return false;
            }
            if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.field_73011_w.func_177502_q(), masterPos.func_177958_n(), masterPos.func_177956_o(), masterPos.func_177952_p()});
                target.writeToNBT(stack.func_77978_p());
            } else {
                WireType type = this.getWireType(stack);
                int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                TileEntity tileEntityLinkingPos = world.func_175625_s(linkPos);
                int distanceSq = (int)Math.ceil(linkPos.func_177951_i((Vec3i)masterPos));
                if (array[0] != world.field_73011_w.func_177502_q()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.wrongDimension", new Object[0]));
                } else if (linkPos.equals((Object)masterPos)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.sameConnection", new Object[0]));
                } else if (distanceSq > type.getMaxLength() * type.getMaxLength()) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.tooFar", new Object[0]));
                } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                } else {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                    boolean connectionExists = false;
                    Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
                    if (outputs != null) {
                        for (ImmersiveNetHandler.Connection con : outputs) {
                            if (!con.end.equals((Object)Utils.toCC(nodeLink))) continue;
                            connectionExists = true;
                        }
                    }
                    if (connectionExists) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.connectionExists", new Object[0]));
                    } else {
                        boolean canSee;
                        Vec3 rtOff0 = nodeHere.getRaytraceOffset(nodeLink).func_72441_c((double)masterPos.func_177958_n(), (double)masterPos.func_177956_o(), (double)masterPos.func_177952_p());
                        Vec3 rtOff1 = nodeLink.getRaytraceOffset(nodeHere).func_72441_c((double)linkPos.func_177958_n(), (double)linkPos.func_177956_o(), (double)linkPos.func_177952_p());
                        HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                        ignore.addAll(nodeHere.getIgnored(nodeLink));
                        ignore.addAll(nodeLink.getIgnored(nodeHere));
                        boolean bl = canSee = Utils.rayTraceForFirst(rtOff0, rtOff1, world, ignore) == null;
                        if (canSee) {
                            TargetingInfo targetLink = TargetingInfo.readFromNBT(stack.func_77978_p());
                            ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink), (int)Math.sqrt(distanceSq), type);
                            nodeHere.connectCable(type, target);
                            nodeLink.connectCable(type, targetLink);
                            IESaveData.setDirty(world.field_73011_w.func_177502_q());
                            player.func_71029_a((StatBase)IEAchievements.connectWire);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                            ((TileEntity)nodeHere).func_70296_d();
                            world.func_175641_c(masterPos, ((TileEntity)nodeHere).func_145838_q(), -1, 0);
                            world.func_175689_h(masterPos);
                            ((TileEntity)nodeLink).func_70296_d();
                            world.func_175641_c(linkPos, ((TileEntity)nodeLink).func_145838_q(), -1, 0);
                            world.func_175689_h(linkPos);
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.cantSee", new Object[0]));
                        }
                    }
                }
                ItemNBTHelper.remove(stack, "linkingPos");
                ItemNBTHelper.remove(stack, "side");
                ItemNBTHelper.remove(stack, "hitX");
                ItemNBTHelper.remove(stack, "hitY");
                ItemNBTHelper.remove(stack, "hitZ");
            }
            return true;
        }
        return false;
    }
}

