/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.client.models.ModelManeuverGear;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntityGrapplingHook;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ManeuverGearHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.BaublesHelper;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class ItemManeuverGear
extends ItemArmor
implements IBauble,
IFluxContainerItem,
IEnergyContainerItem,
ISpecialArmor {
    public static int hookCost = 80;
    public static int rechargeCooldown = 100;
    public static int rechargeFlux = 20;
    public static double jumpCost = 0.125;
    @SideOnly(value=Side.CLIENT)
    ModelBiped armorModel;

    public ItemManeuverGear() {
        super(ItemArmor.ArmorMaterial.LEATHER, 0, 2);
        String name = "maneuverGear";
        this.func_77655_b("ImmersiveEngineering." + name);
        this.func_77637_a(ImmersiveEngineering.creativeTab);
        GameRegistry.registerItem((Item)this, (String)name);
        IEContent.registeredIEItems.add((Item)this);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "immersiveengineering:textures/models/maneuverGear.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot, ModelBiped _default) {
        ModelManeuverGear model = ModelManeuverGear.getModel();
        return model;
    }

    public int func_82814_b(ItemStack stack) {
        return 0xFFFFFF;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{ItemNBTHelper.getInt(stack, "energy")}));
        list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.gasStored", (Object[])new Object[]{Utils.formatDouble(ItemNBTHelper.getFloat(stack, "gas") * 100.0f, "0.###") + "%"}));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack belt;
        if (player.field_70170_p.field_72995_K) {
            return stack;
        }
        if (Lib.BAUBLES && (belt = BaublesHelper.getBauble(player, 3)) == null) {
            BaublesHelper.setBauble(player, 3, stack.func_77946_l());
            stack.field_77994_a = 0;
            return stack;
        }
        int i = EntityLiving.func_82159_b((ItemStack)stack) - 1;
        ItemStack itemstack = player.func_82169_q(i);
        if (itemstack == null) {
            player.func_70062_b(i + 1, stack.func_77946_l());
            stack.field_77994_a = 0;
        }
        return stack;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.onEquippedTick((EntityLivingBase)player, stack);
    }

    public void onEquippedTick(EntityLivingBase player, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "cooldown")) {
            EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks((EntityPlayer)player);
            if ((hooks[0] == null || hooks[0].field_70128_L) && (hooks[1] == null || hooks[1].field_70128_L)) {
                int cooldown = ItemNBTHelper.getInt(stack, "cooldown");
                if (--cooldown <= 0) {
                    ItemNBTHelper.remove(stack, "cooldown");
                } else {
                    ItemNBTHelper.setInt(stack, "cooldown", cooldown);
                }
            }
        } else {
            float gas = ItemNBTHelper.getFloat(stack, "gas");
            if (gas < 1.0f && this.extractEnergy(stack, rechargeFlux, true) == rechargeFlux) {
                this.extractEnergy(stack, rechargeFlux, false);
                gas = Math.min(1.0f, gas + 0.03125f);
                ItemNBTHelper.setFloat(stack, "gas", gas);
            }
        }
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.field_77881_a == armorType && entity instanceof EntityPlayer && !ManeuverGearHelper.isPlayerWearing3DMG((EntityPlayer)entity);
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && !ManeuverGearHelper.isPlayerWearing3DMG((EntityPlayer)entity);
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.BELT;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase entity) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase entity) {
    }

    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        this.onEquippedTick(entity, stack);
    }

    @Override
    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return ItemNBTHelper.insertFluxItem(container, energy, this.getMaxEnergyStored(container), simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return ItemNBTHelper.extractFluxFromItem(container, energy, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getFluxStoredInItem(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 8000;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }
}

