/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJerrycan
extends ItemIEBase
implements IFluidContainerItem {
    public ItemJerrycan() {
        super("jerrycan", 1, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            EnumChatFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? EnumChatFormatting.GRAY : fs.getFluid().getRarity().field_77937_e;
            list.add(rarity + fs.getLocalizedName() + EnumChatFormatting.GRAY + ": " + fs.amount + "/" + this.getCapacity(stack) + "mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.empty"));
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IFluidHandler) {
                return Utils.fillFluidHandlerWithPlayerItem(world, (IFluidHandler)tileEntity, player);
            }
            FluidStack fs = this.getFluid(stack);
            if (Utils.placeFluidBlock(world, pos.func_177972_a(side), fs)) {
                if (fs.amount <= 0) {
                    fs = null;
                }
                ItemNBTHelper.setFluidStack(stack, "fluid", fs);
                return true;
            }
        }
        return false;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "jerrycanDrain");
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "jerrycanDrain")) {
            ItemStack ret = stack.func_77946_l();
            this.drain(ret, ItemNBTHelper.getInt(stack, "jerrycanDrain"), true);
            ItemNBTHelper.remove(ret, "jerrycanDrain");
            return ret;
        }
        return stack;
    }

    public FluidStack getFluid(ItemStack container) {
        return ItemNBTHelper.getFluidStack(container, "fluid");
    }

    public int getCapacity(ItemStack container) {
        return 10000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidStack fs;
        if (resource != null && ((fs = this.getFluid(container)) == null || resource.isFluidEqual(fs))) {
            int space = fs == null ? this.getCapacity(container) : this.getCapacity(container) - fs.amount;
            int accepted = Math.min(space, resource.amount);
            if (fs == null) {
                fs = Utils.copyFluidStackWithAmount(resource, accepted, false);
            } else {
                fs.amount += accepted;
            }
            if (doFill) {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
            return accepted;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack fs = this.getFluid(container);
        if (fs == null) {
            return null;
        }
        int drained = Math.min(maxDrain, fs.amount);
        FluidStack stack = new FluidStack(fs, drained);
        if (doDrain) {
            fs.amount -= drained;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(container, "fluid");
            } else {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
        }
        return stack;
    }
}

