/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotFlare;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotHoming;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBullet
extends ItemIEBase
implements IBullet {
    public ItemBullet() {
        super("bullet", 64, "emptyCasing", "emptyShell", "casull", "armorPiercing", "buckshot", "HE", "dragonsbreath", "homing", "wolfpack", "silver", "potion", "flare");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getSubNames().length; ++i) {
            if ((i == 7 || i == 8) && (!Loader.isModLoaded((String)"Botania") || !Config.getBoolean("compat_Botania"))) continue;
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (stack.func_77952_i() == 10) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (pot != null && pot.func_77973_b() instanceof ItemPotion) {
                List effects = ((ItemPotion)pot.func_77973_b()).func_77832_l(pot);
                HashMultimap hashmultimap = HashMultimap.create();
                if (effects != null && !effects.isEmpty()) {
                    for (PotionEffect potioneffect : effects) {
                        String s1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                        Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                        Map map = potion.func_111186_k();
                        if (map != null && map.size() > 0) {
                            for (Map.Entry entry : map.entrySet()) {
                                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                                AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                                hashmultimap.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1);
                            }
                        }
                        if (potioneffect.func_76458_c() > 0) {
                            s1 = s1 + " " + StatCollector.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                        }
                        if (potioneffect.func_76459_b() > 20) {
                            s1 = s1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                        }
                        if (potion.func_76398_f()) {
                            list.add(EnumChatFormatting.RED + s1);
                            continue;
                        }
                        list.add(EnumChatFormatting.GRAY + s1);
                    }
                } else {
                    String s = StatCollector.func_74838_a((String)"potion.empty").trim();
                    list.add(EnumChatFormatting.GRAY + s);
                }
                if (!hashmultimap.isEmpty()) {
                    list.add("");
                    list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
                    for (Map.Entry entry1 : hashmultimap.entries()) {
                        AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                        double d0 = attributemodifier2.func_111164_d();
                        double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                        if (d0 > 0.0) {
                            list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        list.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                    }
                }
            }
        } else if (stack.func_77952_i() == 11) {
            String hexCol = Integer.toHexString(this.func_82790_a(stack, 1));
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.bullet.flareColour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() == 10) {
            String s = this.func_77657_g(stack);
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (pot != null) {
                if (pot.func_77973_b().getClass().getName().equalsIgnoreCase("ganymedes01.etfuturum.items.LingeringPotion")) {
                    s = s + ".linger";
                } else if (ItemPotion.func_77831_g((int)pot.func_77952_i())) {
                    s = s + ".splash";
                }
            }
            return StatCollector.func_74838_a((String)(s + ".name")).trim();
        }
        return super.func_77653_i(stack);
    }

    public int func_82790_a(ItemStack stack, int pass) {
        if (stack.func_77952_i() == 10 && pass == 1) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            return PotionHelper.func_77915_a((int)(pot != null ? pot.func_77952_i() : 0), (boolean)false);
        }
        if (stack.func_77952_i() == 11 && pass == 1) {
            return ItemNBTHelper.hasKey(stack, "flareColour") ? ItemNBTHelper.getInt(stack, "flareColour") : 13381126;
        }
        return super.func_82790_a(stack, pass);
    }

    @Override
    public ItemStack getCasing(ItemStack stack) {
        return new ItemStack((Item)this, 1, stack.func_77952_i() == 1 || stack.func_77952_i() == 4 || stack.func_77952_i() == 6 || stack.func_77952_i() == 11 ? 1 : 0);
    }

    @Override
    public boolean canSpawnBullet(ItemStack bulletStack) {
        return bulletStack != null && bulletStack.func_77952_i() > 1 && (bulletStack.func_77952_i() != 10 || ItemNBTHelper.getItemStack(bulletStack, "potion") != null);
    }

    @Override
    public void spawnBullet(EntityPlayer player, ItemStack bulletStack, boolean electro) {
        Vec3 vec = player.func_70040_Z();
        int type = bulletStack.func_77952_i() - 2;
        switch (type) {
            case 0: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 1: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 2: {
                for (int i = 0; i < 10; ++i) {
                    Vec3 vecDir = vec.func_72441_c(player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1);
                    this.doSpawnBullet(player, vec, vecDir, type, bulletStack, electro);
                }
                break;
            }
            case 3: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 4: {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vecDir = vec.func_72441_c(player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1);
                    EntityRevolvershot shot = this.doSpawnBullet(player, vec, vecDir, type, bulletStack, electro);
                    shot.setTickLimit(10);
                    shot.func_70015_d(3);
                }
                break;
            }
            case 5: {
                EntityRevolvershotHoming bullet = new EntityRevolvershotHoming(player.field_70170_p, (EntityLivingBase)player, vec.field_72450_a * 1.5, vec.field_72448_b * 1.5, vec.field_72449_c * 1.5, type, bulletStack);
                bullet.field_70159_w = vec.field_72450_a;
                bullet.field_70181_x = vec.field_72448_b;
                bullet.field_70179_y = vec.field_72449_c;
                bullet.bulletElectro = electro;
                player.field_70170_p.func_72838_d((Entity)bullet);
                break;
            }
            case 6: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 7: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 8: {
                EntityRevolvershot shot = this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                shot.bulletPotion = ItemNBTHelper.getItemStack(bulletStack, "potion");
                break;
            }
            case 9: {
                EntityRevolvershotFlare flare = new EntityRevolvershotFlare(player.field_70170_p, (EntityLivingBase)player, vec.field_72450_a * 1.5, vec.field_72448_b * 1.5, vec.field_72449_c * 1.5, type, bulletStack);
                flare.field_70159_w = vec.field_72450_a;
                flare.field_70181_x = vec.field_72448_b;
                flare.field_70179_y = vec.field_72449_c;
                flare.bulletElectro = electro;
                flare.colour = this.func_82790_a(bulletStack, 1);
                flare.setColourSynced();
                player.field_70170_p.func_72838_d((Entity)flare);
            }
        }
    }

    EntityRevolvershot doSpawnBullet(EntityPlayer player, Vec3 vecSpawn, Vec3 vecDir, int type, ItemStack stack, boolean electro) {
        EntityRevolvershot bullet = new EntityRevolvershot(player.field_70170_p, (EntityLivingBase)player, vecDir.field_72450_a * 1.5, vecDir.field_72448_b * 1.5, vecDir.field_72449_c * 1.5, type, stack);
        bullet.field_70159_w = vecDir.field_72450_a;
        bullet.field_70181_x = vecDir.field_72448_b;
        bullet.field_70179_y = vecDir.field_72449_c;
        bullet.bulletElectro = electro;
        player.field_70170_p.func_72838_d((Entity)bullet);
        return bullet;
    }
}

