/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.util.IEExplosion;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityIEExplosive
extends EntityTNTPrimed {
    float explosionPower;
    boolean explosionSmoke = true;
    boolean explosionFire = false;
    float explosionDropChance;
    public Block block;
    public int meta;
    String name;
    static int dataMarker_block = 12;
    static int dataMarker_meta = 13;
    static int dataMarker_fuse = 14;

    public EntityIEExplosive(World world) {
        super(world);
    }

    public EntityIEExplosive(World world, double x, double y, double z, EntityLivingBase igniter, IBlockState blockstate, float explosionPower) {
        super(world, x, y, z, igniter);
        this.explosionPower = explosionPower;
        this.block = blockstate.func_177230_c();
        this.meta = blockstate.func_177230_c().func_176201_c(blockstate);
        this.explosionDropChance = 1.0f / explosionPower;
        this.setBlockSynced();
    }

    public EntityIEExplosive(World world, BlockPos pos, EntityLivingBase igniter, IBlockState blockstate, float explosionPower) {
        this(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, igniter, blockstate, explosionPower);
    }

    public EntityIEExplosive setSmoking(boolean smoke) {
        this.explosionSmoke = smoke;
        return this;
    }

    public EntityIEExplosive setFlaming(boolean fire) {
        this.explosionFire = fire;
        return this;
    }

    public EntityIEExplosive setDropChance(float chance) {
        this.explosionDropChance = chance;
        return this;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(dataMarker_block, (Object)"");
        this.field_70180_af.func_75682_a(dataMarker_meta, (Object)0);
        this.field_70180_af.func_75682_a(dataMarker_fuse, (Object)0);
    }

    public void setBlockSynced() {
        if (this.block != null) {
            this.field_70180_af.func_75692_b(dataMarker_block, (Object)this.block.getRegistryName());
            this.field_70180_af.func_75692_b(dataMarker_meta, (Object)this.meta);
            this.field_70180_af.func_75692_b(dataMarker_fuse, (Object)this.field_70516_a);
        }
    }

    public void getBlockSynced() {
        this.block = Block.func_149684_b((String)this.field_70180_af.func_75681_e(dataMarker_block));
        this.meta = this.field_70180_af.func_75679_c(dataMarker_meta);
        this.field_70516_a = this.field_70180_af.func_75679_c(dataMarker_fuse);
    }

    public String func_70005_c_() {
        ItemStack s;
        if (this.block != null && this.name == null && (s = new ItemStack(this.block, 1, this.meta)) != null && s.func_77973_b() != null) {
            this.name = s.func_82833_r();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.func_70005_c_();
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74776_a("explosionPower", this.explosionPower);
        tagCompound.func_74757_a("explosionSmoke", this.explosionSmoke);
        tagCompound.func_74757_a("explosionFire", this.explosionFire);
        if (this.block != null) {
            tagCompound.func_74778_a("block", this.block.getRegistryName());
            tagCompound.func_74768_a("meta", this.meta);
        }
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.explosionPower = tagCompound.func_74760_g("explosionPower");
        this.explosionSmoke = tagCompound.func_74767_n("explosionSmoke");
        this.explosionFire = tagCompound.func_74767_n("explosionFire");
        if (tagCompound.func_74764_b("block")) {
            this.block = Block.func_149684_b((String)tagCompound.func_74779_i("block"));
            this.meta = tagCompound.func_74762_e("meta");
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.block == null) {
            this.getBlockSynced();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        if (this.field_70516_a-- <= 0) {
            IEExplosion explosion;
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && !ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)(explosion = new IEExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, this.explosionPower, this.explosionFire, this.explosionSmoke).setDropChance(this.explosionDropChance)))) {
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

