/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.ManeuverGearHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityGrapplingHook
extends EntityIEProjectile {
    static final int dataMarker_hookNr = 13;
    static final int dataMarker_mode = 14;
    int hookNr = -1;
    ManeuverGearHelper.HookMode hookMode = ManeuverGearHelper.HookMode.LAUNCHING;
    double speed = 0.5;

    public EntityGrapplingHook(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityGrapplingHook(World world, double x, double y, double z, double ax, double ay, double az) {
        super(world, x, y, z, ax, ay, az);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityGrapplingHook(World world, EntityLivingBase living, double ax, double ay, double az) {
        super(world, living, ax, ay, az);
        this.func_70105_a(0.5f, 0.5f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
    }

    public void setHookNrSynced() {
        this.field_70180_af.func_75692_b(13, (Object)this.hookNr);
    }

    public int getHookNrSynced() {
        return this.field_70180_af.func_75679_c(13);
    }

    public int getHookNr() {
        return this.hookNr;
    }

    public void setHookNr(int nr) {
        this.hookNr = nr;
    }

    public void setHookModeSynced() {
        this.field_70180_af.func_75692_b(14, (Object)this.hookMode.ordinal());
    }

    public ManeuverGearHelper.HookMode getHookModeSynced() {
        int i = this.field_70180_af.func_75679_c(14);
        if (i >= 0 && i < ManeuverGearHelper.HookMode.values().length) {
            return ManeuverGearHelper.HookMode.values()[i];
        }
        return null;
    }

    public ManeuverGearHelper.HookMode getHookMode() {
        return this.hookMode;
    }

    public void setHookMode(ManeuverGearHelper.HookMode mode) {
        this.hookMode = mode;
    }

    public double getHookSpeed() {
        return this.speed;
    }

    @Override
    public double getGravity() {
        return 0.0;
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void func_70030_z() {
        Entity target;
        super.func_70030_z();
        this.hookMode = this.getHookModeSynced();
        if (this.getHookNr() < 0) {
            this.hookNr = this.getHookNrSynced();
        }
        if ((target = this.getShooter()) != null && target instanceof EntityPlayer) {
            if (this.func_70068_e(target) > 4096.0) {
                this.func_70106_y();
            }
            if (this.hookNr >= 0 && this.hookNr < 2 && ManeuverGearHelper.getHooks((EntityPlayer)target)[this.hookNr] != this) {
                ManeuverGearHelper.getHooks((EntityPlayer)((EntityPlayer)target))[this.hookNr] = this;
            }
            if (this.hookMode == ManeuverGearHelper.HookMode.RETURNING) {
                this.blockZ = -1;
                this.blockY = -1;
                this.blockX = -1;
                this.field_70254_i = false;
                this.inBlock = null;
                this.inMeta = -1;
                double redirectionSpeed = 0.25;
                Vec3 newMotion = new Vec3(this.field_70159_w * (1.0 - redirectionSpeed) + (target.field_70165_t - this.field_70165_t) * redirectionSpeed, this.field_70181_x * (1.0 - redirectionSpeed) + (target.field_70163_u + (double)(target.field_70131_O / 2.0f) - this.field_70163_u) * redirectionSpeed, this.field_70179_y * (1.0 - redirectionSpeed) + (target.field_70161_v - this.field_70161_v) * redirectionSpeed).func_72432_b();
                this.field_70159_w = newMotion.field_72450_a * 1.5;
                this.field_70181_x = newMotion.field_72448_b * 1.5;
                this.field_70179_y = newMotion.field_72449_c * 1.5;
            } else if (this.hookMode == ManeuverGearHelper.HookMode.REELING && this.func_70068_e(target) > 4.0 && this.speed < 1.0) {
                this.speed += 0.125;
            } else if (this.hookMode == ManeuverGearHelper.HookMode.LAUNCHING) {
                this.speed = 0.5;
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.getShooter() instanceof EntityPlayer) {
            EntityGrapplingHook[] hooks = ManeuverGearHelper.getHooks((EntityPlayer)this.getShooter());
            int iHook = this.getHookNrSynced();
            if (hooks != null && iHook > 0 && iHook < hooks.length) {
                hooks[iHook] = null;
            }
        }
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
    }

    @Override
    public void func_70100_b_(EntityPlayer player) {
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("hookNr", this.hookNr);
        nbt.func_74768_a("mode", this.hookMode.ordinal());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.hookNr = nbt.func_74762_e("hookNr");
        this.hookMode = ManeuverGearHelper.HookMode.values()[nbt.func_74762_e("mode")];
    }
}

