/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDevice0;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntitySorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.entities.EntityIEExplosive;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockWoodenDevice0
extends BlockIETileProvider<BlockTypes_WoodenDevice0> {
    boolean isExploding = false;

    public BlockWoodenDevice0() {
        super("woodenDevice0", Material.field_151575_d, PropertyEnum.func_177709_a((String)"type", BlockTypes_WoodenDevice0.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_HORIZONTAL, IEProperties.SIDECONFIG[0], IEProperties.SIDECONFIG[1], IEProperties.MULTIBLOCKSLAVE});
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setMetaLightOpacity(BlockTypes_WoodenDevice0.WORKBENCH.getMeta(), 0);
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public int getExplosivesType(IBlockState state) {
        if (!state.func_177227_a().contains(this.property)) {
            return -1;
        }
        if (state.func_177229_b((IProperty)this.property) == BlockTypes_WoodenDevice0.GUNPOWDER_BARREL) {
            return 0;
        }
        return -1;
    }

    public void doExplosion(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter, int explosivesType) {
        if (!world.field_72995_K && explosivesType == 0) {
            EntityIEExplosive explosive = new EntityIEExplosive(world, pos, igniter, state, 4.0f).setDropChance(1.0f);
            world.func_72838_d((Entity)explosive);
            world.func_72956_a((Entity)explosive, "game.tnt.primed", 1.0f, 1.0f);
            world.func_175698_g(pos);
        }
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        EnumFacing f;
        return stack.func_77952_i() != BlockTypes_WoodenDevice0.WORKBENCH.getMeta() || !((f = EnumFacing.func_176733_a((double)player.field_70177_z)).func_176740_k() == EnumFacing.Axis.Z ? !world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c().func_176200_f(world, pos.func_177982_a(1, 0, 0)) && !world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c().func_176200_f(world, pos.func_177982_a(-1, 0, 0)) : !world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c().func_176200_f(world, pos.func_177982_a(0, 0, 1)) && !world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c().func_176200_f(world, pos.func_177982_a(0, 0, -1)));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item item;
        int explosivesType = this.getExplosivesType(state);
        if (explosivesType >= 0 && player.func_71045_bC() != null && ((item = player.func_71045_bC().func_77973_b()) == Items.field_151033_d || item == Items.field_151059_bz)) {
            this.doExplosion(world, pos, state, (EntityLivingBase)player, explosivesType);
            if (item == Items.field_151033_d) {
                player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
            } else if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        this.isExploding = true;
        return super.func_149659_a(explosionIn);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!this.isExploding || this.getExplosivesType(state) < 0) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
        this.isExploding = false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        if (this.func_176201_c(world.func_180495_p(pos)) == BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()) {
            return 1200000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Override
    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        super.func_176204_a(world, pos, state, block);
        int explosivesType = this.getExplosivesType(state);
        if (explosivesType >= 0 && world.func_175640_z(pos)) {
            this.doExplosion(world, pos, state, null, explosivesType);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        int explosivesType = this.getExplosivesType(state);
        if (explosivesType >= 0 && world.func_175640_z(pos)) {
            this.doExplosion(world, pos, state, null, explosivesType);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosionIn) {
        int explosivesType = this.getExplosivesType(world.func_180495_p(pos));
        if (explosivesType >= 0) {
            this.doExplosion(world, pos, world.func_180495_p(pos), null, explosivesType);
        }
        super.onBlockExploded(world, pos, explosionIn);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        int explosivesType = this.getExplosivesType(state);
        if (!world.field_72995_K && entity instanceof EntityArrow && ((EntityArrow)entity).func_70027_ad() && explosivesType >= 0) {
            this.doExplosion(world, pos, state, ((EntityArrow)entity).field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)((EntityArrow)entity).field_70250_c : null, explosivesType);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (BlockTypes_WoodenDevice0.values()[meta]) {
            case CRATE: {
                return new TileEntityWoodenCrate();
            }
            case WORKBENCH: {
                return new TileEntityModWorkbench();
            }
            case BARREL: {
                return new TileEntityWoodenBarrel();
            }
            case SORTER: {
                return new TileEntitySorter();
            }
            case REINFORCED_CRATE: {
                return new TileEntityWoodenCrate();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

