/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySilo
extends TileEntityMultiblockPart<TileEntitySilo> {
    public ItemStack identStack;
    public int storageAmount = 0;
    static int maxStorage = 41472;
    ItemStack inputStack;
    ItemStack outputStack;
    ItemStack prevInputStack;
    ItemStack prevOutputStack;
    boolean lockItem = false;
    private int[] oldComps = new int[6];
    private int masterCompOld;
    private boolean forceUpdate = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    IItemHandler insertionHandler = new SiloInventoryHandler(this);

    public void func_73660_a() {
        if (this.field_174879_c == 4 && !this.field_145850_b.field_72995_K && this.outputStack == null && this.storageAmount > 0 && this.identStack != null) {
            this.func_70296_d();
        }
        if (this.field_174879_c == 4 && !this.field_145850_b.field_72995_K && this.outputStack != null && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 && this.field_145850_b.func_82737_E() % 8L == 0L) {
            this.updateComparatorValuesPart1();
            for (int i = 0; i < 6; ++i) {
                if (i == 1 || this.outputStack == null) continue;
                EnumFacing f = EnumFacing.func_82600_a((int)i);
                TileEntity inventory = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
                ItemStack stack = Utils.copyStackWithAmount(this.identStack, 1);
                if ((stack = Utils.insertStackIntoInventory(inventory, stack, f.func_176734_d())) != null) continue;
                --this.outputStack.field_77994_a;
                this.func_70296_d();
                if (this.outputStack == null) break;
            }
            this.updateComparatorValuesPart2();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("identStack")) {
            NBTTagCompound t = nbt.func_74775_l("identStack");
            this.identStack = ItemStack.func_77949_a((NBTTagCompound)t);
        } else {
            this.identStack = null;
        }
        this.storageAmount = nbt.func_74762_e("storageAmount");
        this.lockItem = nbt.func_74767_n("lockItem");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.identStack != null) {
            NBTTagCompound t = this.identStack.func_77955_b(new NBTTagCompound());
            nbt.func_74782_a("identStack", (NBTBase)t);
        }
        nbt.func_74768_a("storageAmount", this.storageAmount);
        nbt.func_74757_a("lockItem", this.lockItem);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8) {
            return new float[]{this.field_174879_c < 6 ? 0.0f : 0.75f, 0.0f, this.field_174879_c == 0 || this.field_174879_c == 6 ? 0.0f : 0.75f, this.field_174879_c > 2 ? 1.0f : 0.25f, 1.0f, this.field_174879_c == 2 || this.field_174879_c == 8 ? 1.0f : 0.25f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return null;
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.FENCE.getMeta()) : new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    public void disassemble() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.field_145850_b.func_175625_s(startPos) instanceof TileEntitySilo)) {
                return;
            }
            for (int yy = 0; yy <= 6; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_175625_s(startPos.func_177982_a(xx, yy, zz));
                        if (te instanceof TileEntitySilo) {
                            s = ((TileEntitySilo)te).getOriginalBlock();
                            ((TileEntitySilo)te).formed = false;
                        }
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblock) {
                            this.field_145850_b.func_175698_g(startPos.func_177982_a(xx, yy, zz));
                        }
                        this.field_145850_b.func_175656_a(startPos.func_177982_a(xx, yy, zz), Block.func_149634_a((Item)s.func_77973_b()).func_176203_a(s.func_77952_i()));
                    }
                }
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        int oldStorage = this.storageAmount;
        if (this.inputStack != null) {
            if (this.identStack == null) {
                this.identStack = this.inputStack;
            }
            if (maxStorage - this.storageAmount > 0) {
                this.storageAmount = this.prevInputStack == null ? (this.storageAmount += this.inputStack.field_77994_a) : (this.storageAmount += this.inputStack.field_77994_a - this.prevInputStack.field_77994_a);
                if (this.storageAmount > maxStorage) {
                    this.storageAmount = maxStorage;
                }
            }
            if (maxStorage - this.storageAmount >= this.identStack.func_77976_d()) {
                this.inputStack = null;
                this.prevInputStack = null;
            } else {
                this.inputStack = Utils.copyStackWithAmount(this.identStack, this.identStack.func_77976_d() - (maxStorage - this.storageAmount));
                this.prevInputStack = this.inputStack.func_77946_l();
            }
        }
        if (this.prevOutputStack != null) {
            this.storageAmount = this.outputStack == null ? (this.storageAmount -= this.prevOutputStack.field_77994_a) : (this.storageAmount -= this.prevOutputStack.field_77994_a - this.outputStack.field_77994_a);
            if (this.storageAmount < 0) {
                this.storageAmount = 0;
            }
        }
        if (this.storageAmount == 0 && !this.lockItem) {
            this.identStack = null;
            this.outputStack = null;
            this.prevOutputStack = null;
            this.inputStack = null;
            this.prevInputStack = null;
            this.forceUpdate = true;
        } else if (this.identStack != null) {
            if (this.outputStack == null) {
                this.outputStack = this.identStack.func_77946_l();
            }
            this.outputStack.field_77994_a = Math.min(this.outputStack.func_77976_d(), this.storageAmount);
            this.prevOutputStack = this.outputStack.func_77946_l();
        }
        if (this.storageAmount != oldStorage || this.forceUpdate) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
        this.forceUpdate = false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.field_174879_c == 4 ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 7, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if ((this.field_174879_c == 4 || this.field_174879_c == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if ((this.field_174879_c == 4 || this.field_174879_c == 58) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getComparatorOutput() {
        if (this.field_174879_c == 4) {
            return 15 * this.storageAmount / maxStorage;
        }
        TileEntitySilo master = (TileEntitySilo)this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 6 && master != null) {
            int layer = this.offset[1] - 1;
            int vol = maxStorage / 6;
            int filled = master.storageAmount - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = maxStorage / 6;
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.storageAmount / maxStorage;
    }

    private void updateComparatorValuesPart2() {
        int vol = maxStorage / 6;
        if (15 * this.storageAmount / maxStorage != this.masterCompOld) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
        }
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = this.func_174877_v().func_177982_a(-this.offset[0] + x, -this.offset[1] + i + 1, -this.offset[2] + z);
                    this.field_145850_b.func_175685_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
                }
            }
        }
    }

    public static class SiloInventoryHandler
    implements IItemHandlerModifiable {
        TileEntitySilo silo;

        public SiloInventoryHandler(TileEntitySilo silo) {
            this.silo = silo;
        }

        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.silo.inputStack : this.silo.outputStack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.func_77946_l();
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            int space = maxStorage - silo.storageAmount;
            if (slot != 0 || space < 1 || stack == null || silo.identStack != null && !ItemHandlerHelper.canItemStacksStack((ItemStack)silo.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.field_77994_a);
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.inputStack = stack.func_77946_l();
                silo.func_70296_d();
                silo.updateComparatorValuesPart2();
            }
            stack.field_77994_a -= accepted;
            if (stack.field_77994_a < 1) {
                stack = null;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            TileEntitySilo silo = (TileEntitySilo)this.silo.master();
            if (slot != 1 || silo.storageAmount < 1 || amount < 1 || silo.outputStack == null) {
                return null;
            }
            ItemStack out = silo.outputStack.field_77994_a > amount ? Utils.copyStackWithAmount(silo.outputStack, amount) : silo.outputStack;
            if (!simulate) {
                silo.updateComparatorValuesPart1();
                silo.storageAmount -= out.field_77994_a;
                silo.func_70296_d();
                silo.updateComparatorValuesPart2();
            }
            return out;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

