/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySampleDrill
extends TileEntityIEBase
implements ITickable,
IFluxReceiver,
IEnergyReceiver,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHasObjProperty {
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public int dummy = 0;
    public int process = 0;
    public boolean active = false;
    public ItemStack sample;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> displayList = Lists.newArrayList((Object[])new String[]{"drill_base"});

    public static boolean _Immovable() {
        return true;
    }

    public void func_73660_a() {
        boolean powered;
        if (this.dummy != 0 || this.field_145850_b.field_72995_K || this.field_145850_b.func_175623_d(this.func_174877_v().func_177982_a(0, -1, 0)) || this.sample != null) {
            return;
        }
        boolean bl = powered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        if (!this.active && powered) {
            this.active = true;
        } else if (this.active && !powered && this.process >= Config.getInt("coredrill_time")) {
            this.active = false;
        }
        if (this.active && this.process < Config.getInt("coredrill_time") && this.energyStorage.extractEnergy(Config.getInt("coredrill_consumption"), false) == Config.getInt("coredrill_consumption")) {
            ++this.process;
            if (this.process >= Config.getInt("coredrill_time")) {
                int cx = this.func_174877_v().func_177958_n() >> 4;
                int cz = this.func_174877_v().func_177952_p() >> 4;
                ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.field_145850_b, cx, cz);
                this.sample = this.createCoreSample(this.field_145850_b, this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4, info);
            }
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)Config.getInt("coredrill_time");
    }

    public boolean isSamplingFinished() {
        return this.process >= Config.getInt("coredrill_time");
    }

    public String getVein() {
        if (this.sample == null) {
            return "";
        }
        return this.sample.func_77978_p().func_74779_i("mineral");
    }

    public int getExpectedVeinYield() {
        if (this.sample == null) {
            return -1;
        }
        return ExcavatorHandler.mineralVeinCapacity - this.sample.func_77978_p().func_74762_e("depletion");
    }

    public ItemStack createCoreSample(World world, int chunkX, int chunkZ, ExcavatorHandler.MineralWorldInfo info) {
        ItemStack stack = new ItemStack((Item)IEContent.itemCoresample);
        ItemNBTHelper.setLong(stack, "timestamp", world.func_82737_E());
        ItemNBTHelper.setIntArray(stack, "coords", new int[]{world.field_73011_w.func_177502_q(), chunkX, chunkZ});
        if (info.mineralOverride != null) {
            ItemNBTHelper.setString(stack, "mineral", info.mineralOverride.name);
        } else if (info.mineral != null) {
            ItemNBTHelper.setString(stack, "mineral", info.mineral.name);
        } else {
            return stack;
        }
        if (ExcavatorHandler.mineralVeinCapacity < 0 || info.depletion < 0) {
            ItemNBTHelper.setBoolean(stack, "infinite", true);
        } else {
            ItemNBTHelper.setInt(stack, "depletion", info.depletion);
        }
        return stack;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74768_a("process", this.process);
        nbt.func_74757_a("active", this.active);
        if (this.sample != null) {
            nbt.func_74782_a("sample", (NBTBase)this.sample.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.dummy = nbt.func_74762_e("dummy");
        this.process = nbt.func_74762_e("process");
        this.active = nbt.func_74767_n("active");
        if (nbt.func_74764_b("sample")) {
            this.sample = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("sample"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.dummy == 0 ? new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 3, 1)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.dummy == 0;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).receiveEnergy(from, maxReceive, simulate);
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getEnergyStored(from);
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).getMaxEnergyStored(from);
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(pos.func_177982_a(0, i, 0), state);
            ((TileEntitySampleDrill)this.field_145850_b.func_175625_s((BlockPos)pos.func_177982_a((int)0, (int)i, (int)0))).dummy = i;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0)) instanceof TileEntitySampleDrill)) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0));
        }
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof TileEntitySampleDrill) {
            return ((TileEntitySampleDrill)te).interact(side, player, hitX, hitY, hitZ);
        }
        if (this.sample != null) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_70099_a(this.sample.func_77946_l(), 0.5f);
            }
            this.sample = null;
            this.active = false;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        if (!this.active) {
            this.active = true;
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return displayList;
    }
}

