/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityConveyorBelt
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHammerInteraction {
    public boolean transportUp = false;
    public boolean transportDown = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean dropping = false;
    IItemHandler insertionHandler = new ConveyorInventoryHandler(this);

    public TileEntityConveyorBelt() {
    }

    public TileEntityConveyorBelt(boolean dropping) {
        this.dropping = dropping;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (!(entity == null || entity.field_70128_L || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af() || !(entity.field_70163_u - (double)this.func_174877_v().func_177956_o() >= 0.0) || !(entity.field_70163_u - (double)this.func_174877_v().func_177956_o() < 0.5))) {
            boolean contact;
            if (world.func_175687_A(this.field_174879_c) > 0) {
                return;
            }
            double vBase = 1.15;
            double vX = 0.1 * vBase * (double)this.facing.func_82601_c();
            double vY = entity.field_70181_x;
            double vZ = 0.1 * vBase * (double)this.facing.func_82599_e();
            if (this.transportUp) {
                vY = 0.17 * vBase;
            } else if (this.transportDown) {
                vY = -0.07 * vBase;
            }
            if (this.transportUp || this.transportDown) {
                entity.field_70122_E = false;
            }
            if (this.facing == EnumFacing.WEST || this.facing == EnumFacing.EAST) {
                if (entity.field_70161_v > (double)this.func_174877_v().func_177952_p() + 0.65) {
                    vZ = -0.1 * vBase;
                } else if (entity.field_70161_v < (double)this.func_174877_v().func_177952_p() + 0.35) {
                    vZ = 0.1 * vBase;
                }
            } else if (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) {
                if (entity.field_70165_t > (double)this.func_174877_v().func_177958_n() + 0.65) {
                    vX = -0.1 * vBase;
                } else if (entity.field_70165_t < (double)this.func_174877_v().func_177958_n() + 0.35) {
                    vX = 0.1 * vBase;
                }
            }
            if (entity.field_70143_R < 3.0f) {
                entity.field_70143_R = 0.0f;
            }
            entity.field_70159_w = vX;
            entity.field_70181_x = vY;
            entity.field_70179_y = vZ;
            double distX = Math.abs((double)this.func_174877_v().func_177972_a(this.facing).func_177958_n() + 0.5 - entity.field_70165_t);
            double distZ = Math.abs((double)this.func_174877_v().func_177972_a(this.facing).func_177952_p() + 0.5 - entity.field_70161_v);
            double treshold = 0.9;
            boolean bl = this.facing.func_176740_k() == EnumFacing.Axis.Z ? distZ < treshold : (contact = distX < treshold);
            if (contact && this.transportUp && !world.func_180495_p(this.func_174877_v().func_177972_a(this.facing).func_177984_a()).func_177230_c().func_149730_j()) {
                double move = 0.4;
                entity.func_70107_b(entity.field_70165_t + move * (double)this.facing.func_82601_c(), entity.field_70163_u + 1.75 * move, entity.field_70161_v + move * (double)this.facing.func_82599_e());
            }
            if (entity instanceof EntityItem) {
                TileEntity inventoryTile;
                ((EntityItem)entity).func_174873_u();
                EnumFacing inventoryDir = this.facing;
                if (this.dropping) {
                    inventoryTile = world.func_175625_s(this.func_174877_v().func_177982_a(0, -1, 0));
                    contact = Math.abs(this.facing.func_176740_k() == EnumFacing.Axis.Z ? (double)this.func_174877_v().func_177952_p() + 0.5 - entity.field_70161_v : (double)this.func_174877_v().func_177958_n() + 0.5 - entity.field_70165_t) < 0.2;
                    inventoryDir = EnumFacing.DOWN;
                } else {
                    inventoryTile = world.func_175625_s(this.func_174877_v().func_177972_a(inventoryDir).func_177982_a(0, this.transportUp ? 1 : (this.transportDown ? -1 : 0), 0));
                    boolean bl2 = this.facing.func_176740_k() == EnumFacing.Axis.Z ? distZ < 0.7 : (contact = distX < 0.7);
                }
                if (!world.field_72995_K) {
                    if (contact && inventoryTile != null && !(inventoryTile instanceof TileEntityConveyorBelt)) {
                        ItemStack stack = ((EntityItem)entity).func_92059_d();
                        if (stack != null) {
                            ItemStack ret = Utils.insertStackIntoInventory(inventoryTile, stack, inventoryDir.func_176734_d());
                            if (ret == null) {
                                entity.func_70106_y();
                            } else if (ret.field_77994_a < stack.field_77994_a) {
                                ((EntityItem)entity).func_92058_a(ret);
                            }
                        }
                    } else if (this.dropping && contact && world.func_175623_d(this.func_174877_v().func_177982_a(0, -1, 0))) {
                        entity.field_70159_w = 0.0;
                        entity.field_70179_y = 0.0;
                        entity.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() - 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    }
                }
            }
        }
    }

    public boolean renderWall(int i) {
        if (this.transportDown || this.transportUp) {
            return false;
        }
        EnumFacing side = i == 0 ? this.facing.func_176735_f() : this.facing.func_176746_e();
        BlockPos pos = this.func_174877_v().func_177972_a(side);
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof TileEntityConveyorBelt && ((TileEntityConveyorBelt)te).facing == side.func_176734_d()) {
            return false;
        }
        te = this.field_145850_b.func_175625_s(pos.func_177982_a(0, -1, 0));
        if (te instanceof TileEntityConveyorBelt && ((TileEntityConveyorBelt)te).facing == side.func_176734_d() && ((TileEntityConveyorBelt)te).transportUp) {
            return false;
        }
        te = this.field_145850_b.func_175625_s(pos.func_177982_a(0, 1, 0));
        return !(te instanceof TileEntityConveyorBelt) || ((TileEntityConveyorBelt)te).facing != side.func_176734_d() || !((TileEntityConveyorBelt)te).transportDown;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.transportUp = nbt.func_74767_n("transportUp");
        this.transportDown = nbt.func_74767_n("transportDown");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.dropping = nbt.func_74767_n("dropping");
        if (descPacket && this.field_145850_b != null) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74757_a("transportUp", this.transportUp);
        nbt.func_74757_a("transportDown", this.transportDown);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("dropping", this.dropping);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return placer.func_70093_af();
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (this.transportUp) {
                this.transportUp = false;
                this.transportDown = true;
            } else if (this.transportDown) {
                this.transportDown = false;
            } else {
                this.transportUp = true;
            }
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, this.transportUp || this.transportDown ? 1.125f : 0.125f, 1.0f};
    }

    @Override
    public float[] getSpecialCollisionBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f};
    }

    @Override
    public float[] getSpecialSelectionBounds() {
        return null;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) <= 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class ConveyorInventoryHandler
    implements IItemHandlerModifiable {
        TileEntityConveyorBelt conveyor;

        public ConveyorInventoryHandler(TileEntityConveyorBelt conveyor) {
            this.conveyor = conveyor;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return null;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate) {
                this.conveyor.func_145831_w().func_72838_d((Entity)new EntityItem(this.conveyor.func_145831_w(), (double)this.conveyor.func_174877_v().func_177958_n() + 0.5, (double)this.conveyor.func_174877_v().func_177956_o() + 0.25, (double)this.conveyor.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l()));
            }
            return null;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

