/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockIETileProvider<E extends Enum<E>>
extends BlockIEBase<E>
implements ITileEntityProvider {
    public BlockIETileProvider(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
        super(name, material, mainProperty, itemBlock, additionalProperties);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IItemHandler h;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IEBlockInterfaces.ITileDrop) && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (h = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IEInventoryHandler) {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i) == null) continue;
                BlockIETileProvider.func_180635_a((World)world, (BlockPos)pos, (ItemStack)h.getStackInSlot(i));
                ((IEInventoryHandler)h).setStackInSlot(i, null);
            }
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
        }
        if (tile instanceof IImmersiveConnectable && world.func_82736_K().func_82766_b("doTileDrops") && world != null && (!world.field_72995_K || !Minecraft.func_71410_x().func_71356_B())) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(tile), world, !world.field_72995_K);
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile) {
        ItemStack s;
        if (tile instanceof IEBlockInterfaces.ITileDrop && (s = ((IEBlockInterfaces.ITileDrop)tile).getTileDrop(player, state)) != null) {
            BlockIETileProvider.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
            return;
        }
        super.func_180657_a(world, player, pos, state, tile);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack s;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop && (s = ((IEBlockInterfaces.ITileDrop)tile).getTileDrop(player, world.func_180495_p(pos))) != null) {
            return s;
        }
        return super.getPickBlock(target, world, pos, player);
    }

    @Override
    public boolean func_180648_a(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        super.func_180648_a(worldIn, pos, state, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IAttachedIntegerProperies) {
            for (String s : ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntPropertyNames()) {
                state = this.applyProperty(state, ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntProperty(s), ((IEBlockInterfaces.IAttachedIntegerProperies)tile).getIntPropertyValue(s));
            }
        }
        if (tile instanceof IEBlockInterfaces.IDirectionalTile) {
            int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            PropertyDirection prop = limit == 2 ? IEProperties.FACING_HORIZONTAL : (limit == 3 ? IEProperties.FACING_VERTICAL : IEProperties.FACING_ALL);
            state = this.applyProperty(state, prop, ((IEBlockInterfaces.IDirectionalTile)tile).getFacing());
        } else if (state.func_177227_a().contains(IEProperties.FACING_HORIZONTAL)) {
            state = state.func_177226_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH);
        } else if (state.func_177227_a().contains(IEProperties.FACING_ALL)) {
            state = state.func_177226_a((IProperty)IEProperties.FACING_ALL, (Comparable)EnumFacing.NORTH);
        }
        if (tile instanceof IEBlockInterfaces.IConfigurableSides) {
            for (int i = 0; i < 6; ++i) {
                if (!state.func_177227_a().contains(IEProperties.SIDECONFIG[i])) continue;
                state = state.func_177226_a((IProperty)IEProperties.SIDECONFIG[i], (Comparable)((Object)((IEBlockInterfaces.IConfigurableSides)tile).getSideConfig(i)));
            }
        }
        if (tile instanceof IEBlockInterfaces.IActiveState) {
            state = this.applyProperty(state, ((IEBlockInterfaces.IActiveState)tile).getBoolProperty(IEBlockInterfaces.IActiveState.class), ((IEBlockInterfaces.IActiveState)tile).getIsActive());
        }
        if (tile instanceof IEBlockInterfaces.IDualState) {
            state = this.applyProperty(state, ((IEBlockInterfaces.IDualState)tile).getBoolProperty(IEBlockInterfaces.IDualState.class), ((IEBlockInterfaces.IDualState)tile).getIsSecondState());
        }
        if (tile instanceof TileEntityMultiblockPart) {
            state = this.applyProperty(state, IEProperties.MULTIBLOCKSLAVE, ((TileEntityMultiblockPart)tile).isDummy());
        } else if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            state = this.applyProperty(state, IEProperties.MULTIBLOCKSLAVE, ((IEBlockInterfaces.IHasDummyBlocks)tile).isDummy());
        }
        if (tile instanceof IEBlockInterfaces.IMirrorAble) {
            state = this.applyProperty(state, ((IEBlockInterfaces.IMirrorAble)tile).getBoolProperty(IEBlockInterfaces.IMirrorAble.class), ((IEBlockInterfaces.IMirrorAble)tile).getIsMirrored());
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IEBlockInterfaces.IAdvancedHasObjProperty) {
                state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.instance, (Object)((IEBlockInterfaces.IAdvancedHasObjProperty)te).getOBJState());
            } else if (te instanceof IEBlockInterfaces.IHasObjProperty) {
                state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.instance, (Object)new OBJModel.OBJState(((IEBlockInterfaces.IHasObjProperty)te).compileDisplayList(), true));
            }
            if (te instanceof IEBlockInterfaces.IDynamicTexture) {
                state = ((IExtendedBlockState)state).withProperty(IEProperties.OBJ_TEXTURE_REMAP, ((IEBlockInterfaces.IDynamicTexture)te).getTextureReplacements());
            }
            if (te instanceof IOBJModelCallback) {
                state = ((IExtendedBlockState)state).withProperty(IEProperties.OBJ_MODEL_CALLBACK, (Object)((IOBJModelCallback)te));
            }
        }
        return state;
    }

    @Override
    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalTile) {
            EnumFacing f = EnumFacing.DOWN;
            int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            if (limit == 0) {
                f = side;
            } else if (limit == 1) {
                f = BlockPistonBase.func_180695_a((World)world, (BlockPos)pos, (EntityLivingBase)placer);
            } else if (limit == 2) {
                f = EnumFacing.func_176733_a((double)placer.field_70177_z);
            } else if (limit == 3) {
                f = side != EnumFacing.DOWN && (side == EnumFacing.UP || (double)hitY <= 0.5) ? EnumFacing.UP : EnumFacing.DOWN;
            } else if (limit == 4) {
                f = EnumFacing.func_176733_a((double)placer.field_70177_z);
                if (f == EnumFacing.SOUTH || f == EnumFacing.WEST) {
                    f = f.func_176734_d();
                }
            } else {
                f = EnumFacing.func_82600_a((int)(limit - 5));
            }
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(((IEBlockInterfaces.IDirectionalTile)tile).mirrorFacingOnPlacement(placer) ? f.func_176734_d() : f);
            if (tile instanceof IEBlockInterfaces.IAdvancedDirectionalTile) {
                ((IEBlockInterfaces.IAdvancedDirectionalTile)tile).onDirectionalPlacement(side, hitX, hitY, hitZ, placer);
            }
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            ((IEBlockInterfaces.IHasDummyBlocks)tile).placeDummies(pos, state, side, hitX, hitY, hitZ);
        }
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            ((IEBlockInterfaces.ITileDrop)tile).readOnPlacement(placer, stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides && Utils.isHammer(player.func_71045_bC()) && !world.field_72995_K) {
            int iSide;
            int n = iSide = player.func_70093_af() ? side.func_176734_d().ordinal() : side.ordinal();
            if (!world.field_72995_K && ((IEBlockInterfaces.IConfigurableSides)tile).toggleSide(iSide, player)) {
                return true;
            }
        }
        if (tile instanceof IEBlockInterfaces.IDirectionalTile && Utils.isHammer(player.func_71045_bC()) && ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, hitX, hitY, hitZ, (EntityLivingBase)player) && !world.field_72995_K) {
            EnumFacing f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
            int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
            if (limit == 0) {
                f = player.func_70093_af() ? side.func_176734_d() : side;
            } else if (limit == 1) {
                f = player.func_70093_af() ? f.func_176732_a(side.func_176740_k()).func_176734_d() : f.func_176732_a(side.func_176740_k());
            } else if (limit == 2) {
                f = player.func_70093_af() ? f.func_176735_f() : f.func_176746_e();
            }
            ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
            tile.func_70296_d();
            world.func_175689_h(tile.func_174877_v());
            world.func_175641_c(tile.func_174877_v(), tile.func_145838_q(), 255, 0);
            return true;
        }
        if (tile instanceof IEBlockInterfaces.IHammerInteraction && Utils.isHammer(player.func_71045_bC()) && (b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hitX, hitY, hitZ))) {
            return b;
        }
        if (tile instanceof IEBlockInterfaces.IPlayerInteraction && (b = ((IEBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hitX, hitY, hitZ))) {
            return b;
        }
        if (tile instanceof IEBlockInterfaces.IGuiTile && !player.func_70093_af() && ((IEBlockInterfaces.IGuiTile)tile).canOpenGui()) {
            TileEntity master = ((IEBlockInterfaces.IGuiTile)tile).getGuiMaster();
            if (!world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, ((IEBlockInterfaces.IGuiTile)tile).getGuiID(), world, master.func_174877_v().func_177958_n(), master.func_174877_v().func_177956_o(), master.func_174877_v().func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.INeighbourChangeTile && !world.field_72995_K) {
            ((IEBlockInterfaces.INeighbourChangeTile)tile).onNeighborBlockChange(world, pos, state, neighborBlock);
        }
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.ILightValue) {
            return ((IEBlockInterfaces.ILightValue)te).getLightValue();
        }
        return 0;
    }

    public int func_180662_a(IBlockAccess world, BlockPos pos, int renderPass) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IColouredTile) {
            ((IEBlockInterfaces.IColouredTile)te).getRenderColour();
        }
        return 0xFFFFFF;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IBlockBounds) {
            float[] bounds = ((IEBlockInterfaces.IBlockBounds)te).getBlockBounds();
            if (bounds != null && bounds.length > 5) {
                this.func_149676_a(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IEBlockInterfaces.IBlockBounds && ((IEBlockInterfaces.IBlockBounds)te).getSpecialCollisionBounds() != null) {
                float[] bounds = ((IEBlockInterfaces.IBlockBounds)te).getSpecialCollisionBounds();
                return AxisAlignedBB.func_178781_a((double)((float)pos.func_177958_n() + bounds[0]), (double)((float)pos.func_177956_o() + bounds[1]), (double)((float)pos.func_177952_p() + bounds[2]), (double)((float)pos.func_177958_n() + bounds[3]), (double)((float)pos.func_177956_o() + bounds[4]), (double)((float)pos.func_177952_p() + bounds[5]));
            }
            this.func_180654_a((IBlockAccess)world, pos);
        }
        return super.func_180640_a(world, pos, state);
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IBlockBounds && ((IEBlockInterfaces.IBlockBounds)te).getSpecialSelectionBounds() != null) {
            float[] bounds = ((IEBlockInterfaces.IBlockBounds)te).getSpecialSelectionBounds();
            return AxisAlignedBB.func_178781_a((double)((float)pos.func_177958_n() + bounds[0]), (double)((float)pos.func_177956_o() + bounds[1]), (double)((float)pos.func_177952_p() + bounds[2]), (double)((float)pos.func_177958_n() + bounds[3]), (double)((float)pos.func_177956_o() + bounds[4]), (double)((float)pos.func_177952_p() + bounds[5]));
        }
        this.func_180654_a((IBlockAccess)world, pos);
        return super.func_180646_a(world, pos);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity ent) {
        List<AxisAlignedBB> bounds;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IAdvancedCollisionBounds && (bounds = ((IEBlockInterfaces.IAdvancedCollisionBounds)te).getAdvancedColisionBounds()) != null && !bounds.isEmpty()) {
            for (AxisAlignedBB aabb : bounds) {
                if (aabb == null || !mask.func_72326_a(aabb)) continue;
                list.add(aabb);
            }
            return;
        }
        super.func_180638_a(world, pos, state, mask, list, ent);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 start, Vec3 end) {
        List<AxisAlignedBB> list;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IAdvancedSelectionBounds && (list = ((IEBlockInterfaces.IAdvancedSelectionBounds)te).getAdvancedSelectionBounds()) != null && !list.isEmpty()) {
            for (AxisAlignedBB aabb : list) {
                aabb = aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
                MovingObjectPosition mop = this.doRaytrace(world, pos, start, end);
                if (mop == null) continue;
                return mop;
            }
            return null;
        }
        return super.func_180636_a(world, pos, start, end);
    }

    public MovingObjectPosition doRaytrace(World world, BlockPos pos, Vec3 start, Vec3 end) {
        start = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        end = end.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vec3 vec3 = start.func_72429_b(end, this.field_149759_B);
        Vec3 vec31 = start.func_72429_b(end, this.field_149755_E);
        Vec3 vec32 = start.func_72435_c(end, this.field_149760_C);
        Vec3 vec33 = start.func_72435_c(end, this.field_149756_F);
        Vec3 vec34 = start.func_72434_d(end, this.field_149754_D);
        Vec3 vec35 = start.func_72434_d(end, this.field_149757_G);
        if (!this.func_149654_a(vec3)) {
            vec3 = null;
        }
        if (!this.func_149654_a(vec31)) {
            vec31 = null;
        }
        if (!this.func_149687_b(vec32)) {
            vec32 = null;
        }
        if (!this.func_149687_b(vec33)) {
            vec33 = null;
        }
        if (!this.func_149661_c(vec34)) {
            vec34 = null;
        }
        if (!this.func_149661_c(vec35)) {
            vec35 = null;
        }
        Vec3 vec36 = null;
        if (vec3 != null && (vec36 == null || start.func_72436_e(vec3) < start.func_72436_e(vec36))) {
            vec36 = vec3;
        }
        if (vec31 != null && (vec36 == null || start.func_72436_e(vec31) < start.func_72436_e(vec36))) {
            vec36 = vec31;
        }
        if (vec32 != null && (vec36 == null || start.func_72436_e(vec32) < start.func_72436_e(vec36))) {
            vec36 = vec32;
        }
        if (vec33 != null && (vec36 == null || start.func_72436_e(vec33) < start.func_72436_e(vec36))) {
            vec36 = vec33;
        }
        if (vec34 != null && (vec36 == null || start.func_72436_e(vec34) < start.func_72436_e(vec36))) {
            vec36 = vec34;
        }
        if (vec35 != null && (vec36 == null || start.func_72436_e(vec35) < start.func_72436_e(vec36))) {
            vec36 = vec35;
        }
        if (vec36 == null) {
            return null;
        }
        EnumFacing enumfacing = null;
        if (vec36 == vec3) {
            enumfacing = EnumFacing.WEST;
        }
        if (vec36 == vec31) {
            enumfacing = EnumFacing.EAST;
        }
        if (vec36 == vec32) {
            enumfacing = EnumFacing.DOWN;
        }
        if (vec36 == vec33) {
            enumfacing = EnumFacing.UP;
        }
        if (vec36 == vec34) {
            enumfacing = EnumFacing.NORTH;
        }
        if (vec36 == vec35) {
            enumfacing = EnumFacing.SOUTH;
        }
        return new MovingObjectPosition(vec36.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), enumfacing, pos);
    }

    protected boolean func_149654_a(Vec3 point) {
        return point == null ? false : point.field_72448_b >= this.field_149760_C && point.field_72448_b <= this.field_149756_F && point.field_72449_c >= this.field_149754_D && point.field_72449_c <= this.field_149757_G;
    }

    protected boolean func_149687_b(Vec3 point) {
        return point == null ? false : point.field_72450_a >= this.field_149759_B && point.field_72450_a <= this.field_149755_E && point.field_72449_c >= this.field_149754_D && point.field_72449_c <= this.field_149757_G;
    }

    protected boolean func_149661_c(Vec3 point) {
        return point == null ? false : point.field_72450_a >= this.field_149759_B && point.field_72450_a <= this.field_149755_E && point.field_72448_b >= this.field_149760_C && point.field_72448_b <= this.field_149756_F;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)te).getComparatorInputOverride();
        }
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIEBase) {
            ((TileEntityIEBase)te).onEntityCollision(world, entity);
        }
    }
}

